RACES = {
	{ -- Supply Run (Crap BMX, by Snowy) | BULLWORTH ACADEMY | 8:00 PM - 2:00 AM
		name = "Supply Run (Bike)",
		id = "school_supplyrun_bike",
		description = "The Nerds are out of supplies! It's time to hit up Sweet Cavity, Yum Yum Market, and Dragon's Wing. (Vehicle: Crap BMX)",
		warp_pos = {198.76, -23.37, 6.19, -93.3}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {20, 0},
		end_time = {2, 0},
		area = 0,
		weather = 0,
		clock = {22, 30},
		blip = {201.92, -23.42, 6.24, 8}, -- last number is radius to play
		spectator_bounds = {161.42, -176.39, 166.08, -159.31}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {163.84, -172.21, 7.78, 1.3}, -- last number is spawn radius not heading
		max_timer = 360, -- max seconds
		vehicle = 274, -- crapbmx
		laps = 1,
		cameras = {
			time_15 = {190.78, -147.64, 10.08, 187.04, -156.89, 9.44},
			time_10 = {160.92, -151.37, 9.80, 162.25, -161.27, 9.40},
		},
		spawns = {
			{158.69, -178.40, 8.30, 148.2},
			{160.76, -179.05, 8.30, 164.0},
			{162.37, -179.22, 8.30, 166.5},
			{164.68, -179.00, 8.30, 135.2},
			{165.71, -180.37, 8.30, 127.9},
			{156.87, -180.03, 8.30, 151.2},
			{158.77, -180.63, 8.30, 154.4},
			{160.39, -181.51, 8.30, 150.9},
			{161.89, -181.95, 8.30, 142.5},
			{162.92, -182.91, 8.30, 114.8},
		},
		checkpoints = {
			{113.03, -193.90, 8.43},
			{28.37, -219.88, 3.84},
			{-8.44, -222.13, 2.19},
			{-20.91, -247.56, 5.87},
			{-62.29, -238.02, 6.34},
			{-63.40, -185.66, 4.58},
			{-69.93, -158.55, 8.70},
			{-134.82, -84.12, 6.30},
			{-68.20, -19.66, 4.79},
			{39.96, 4.08, 4.84},
			{128.09, 45.06, 4.21},
			{181.06, 31.51, 6.92},
			{254.55, 6.74, 6.23},
			{321.45, -0.14, 4.93},
			{330.48, -109.49, 6.76},
			{433.39, -96.02, 6.07},
			{472.00, -61.99, 6.28, sound = "BuyItem"}, -- sweet cavity
			{500.83, -43.78, 5.88},
			{528.59, -41.97, 5.93},
			{576.89, -42.86, 6.16},
			{570.33, -89.44, 6.06},
			{533.49, -82.45, 5.12, sound = "BuyItem"}, -- yum yum
			{522.16, -77.25, 4.75},
			{517.28, -56.32, 6.05, sound = "BuyItem"}, -- dragon wing
			{508.24, -44.13, 5.86},
			{467.13, -54.39, 6.02},
			{454.30, -86.95, 5.91},
			{321.46, -41.99, 5.22},
			{308.85, 3.17, 4.92},
			{242.96, 12.46, 6.53},
			{180.60, 32.96, 6.93},
			{-63.48, -11.68, 4.80},
			{-90.17, -159.09, 4.61},
			{-70.00, -228.17, 6.55},
			{-17.54, -245.21, 5.81},
			{1.82, -218.97, 1.73},
			{87.46, -195.79, 8.49},
			{134.75, -195.62, 8.30},
			{158.15, -182.13, 8.30},
		},
		music_replay = 85, -- 70
		music = {
			intro = "MS_FriendshipAllyLow", -- "MS_SearchingMid"
			gameplay = "MS_FriendshipAllyHigh", -- "MS_SearchingHigh"
			results = "MS_FriendshipAllyMid",
		},
	},
	{ -- Going Downhill (Skateboard, by Snowy) | OLD BULLWORTH VALE | 2:00 PM - 8:00 PM
		name = "Going Downhill (Skateboard)",
		id = "downhill_skate",
		description = "A high speed race from the Happy Endings Retirement Home, all the way to Happy Volts Asylum. (Vehicle: Skateboard)",
		warp_pos = {342.50, 263.53, 6.23, 75.6}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {14, 0},
		end_time = {20, 0},
		area = 0,
		weather = 0,
		clock = {16, 0},
		blip = {335.32, 269.05, 5.89, 8}, -- last number is radius to play
		spectator_bounds = {-73.64, -333.93, -62.09, -313.51}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {-67.98, -323.62, 4.17, 1.2}, -- last number is spawn radius not heading
		max_timer = 210, -- max seconds
		vehicle = -1,
		weapon = 437,
		laps = 1,
		cameras = {
			time_15 = {537.22, 343.08, 19.29, 537.73, 353.03, 18.43},
			time_10 = {539.44, 360.47, 19.95, 539.44, 350.47, 19.75},
		},
		spawns = {
			{543.06, 354.20, 16.76, 174.2},
			{540.38, 354.80, 16.76, 179.8},
			{537.63, 354.63, 16.76, 177.9},
			{535.08, 354.71, 16.76, -174.0},
			{536.40, 352.40, 16.56, 174.3},
			{538.02, 352.35, 16.56, 174.3},
			{539.52, 352.30, 16.56, 174.3},
			{541.30, 352.23, 16.56, 174.3},
			{548.02, 350.55, 16.66, 130.8},
			{530.13, 350.13, 16.46, -138.8},
		},
		checkpoints = {
			{539.60, 309.01, 16.76},
			{539.75, 223.09, 16.15},
			{562.08, 74.72, 13.68},
			{577.14, -41.56, 5.65},
			{573.21, -123.60, 5.42},
			{498.01, -167.03, 3.92},
			{477.34, -284.92, 2.79},
			{493.41, -401.65, 2.26},
			{472.25, -420.04, 2.08},
			{378.29, -425.43, 2.68},
			{242.17, -427.62, 2.65},
			{147.38, -450.08, 2.49},
			{106.82, -361.70, 1.39},
			{43.52, -367.05, 0.37},
			{-20.04, -308.44, 3.18},
			{-60.00, -314.90, 4.27},
		},
		music_replay = 95,
		music = {
			intro = "MS_EpicConfrontationMid",
			gameplay = "MS_EpicConfrontationHighPart2",
			results = "MS_EpicConfrantation_NIS",
		},
	},
	{ -- Neighborhood Nuisance (Gokart, by SWEGTA) | OLD BULLWORTH VALE | 8:00 AM - 2:00 PM
		name = "Neighborhood Nuisance (Gokart)",
		id = "vale_gokartneighborhood",
		description = "Wake up the local residents with the sweet, sweet sound of gokart engines. (Vehicle: Gokart)",
		warp_pos = {342.50, 263.53, 6.23, 75.6}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {8, 0},
		end_time = {14, 0},
		area = 0,
		weather = 0,
		clock = {11, 38},
		blip = {340.69, 268.98, 6.10, 8}, -- last number is radius to play
		spectator_bounds = {528.51, 256.00, 535.61, 282.76}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {532.62, 260.81, 16.86, 1.2}, -- last number is spawn radius not heading
		max_timer = 210, -- max seconds
		vehicle = 289,
		laps = 3,
		cameras = {
			results = {539.87, 216.26, 18.58, 539.91, 226.24, 19.30},
			time_15 = {547.99, 248.95, 17.66, 537.99, 249.05, 17.46},
			time_10 = {520.80, 249.50, 16.89, 530.69, 249.20, 18.29},
		},
		spawns = {
			{529.49, 245.59, 18.55, 87.1},
			{529.45, 247.18, 18.55, 87.1},
			{529.39, 249.67, 18.55, 92.0},
			{529.16, 251.75, 18.55, 92.0},
			{529.16, 253.66, 18.55, 95.6},
			{535.60, 252.28, 18.60, 91.2},
			{535.54, 249.77, 18.60, 96.4},
			{535.57, 246.93, 18.60, 93.2},
		},
		checkpoints = {
			{454.61, 249.62, 10.35},
			{435.74, 222.69, 9.97},
			{381.93, 198.12, 6.32},
			{340.32, 206.34, 4.53},
			{339.71, 239.93, 6.94},
			{356.52, 287.28, 7.77},
			{358.47, 324.80, 13.08},
			{335.83, 354.22, 15.26},
			{290.40, 378.23, 20.11},
			{302.31, 422.93, 20.94},
			{360.00, 420.24, 20.97},
			{395.92, 454.29, 22.85},
			{470.44, 518.20, 20.25},
			{553.68, 440.54, 17.15},
			{556.92, 412.10, 18.96},
			{539.22, 320.73, 16.76},
			{539.00, 254.78, 16.45},
		},
		music_replay = 0,
		music = {
			intro = "MS_EpicConfrontationMid",
			gameplay = "MS_EpicConfrontationHighPart2",
			results = "MS_EpicConfrantation_NIS",
		},
	},
	{ -- Downsized (Minicar, by SWEGTA) | BLUE SKIES | 8:00 AM - 2:00 PM
		name = "Downsized (Minicar)",
		id = "blue_skies_minicar",
		description = "Take a proper gander at the local scenery of Blue Skies. (Vehicle: Minicar)",
		warp_pos = {236.37, -432.52, 2.70, -151.6}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {8, 0},
		end_time = {14, 0},
		area = 0,
		weather = 0,
		clock = {17, 00},
		blip = {239.94, -438.85, 2.66, 8}, -- last number is radius to play
		spectator_bounds = {247.52, -419.70, 253.55, -410.78}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {250.67, -412.19, 2.65, 1.2}, -- last number is spawn radius not heading
		max_timer = 300, -- max seconds
		vehicle = "minicar",
		laps = 1,
		cameras = {
			results = {271.42, -432.57, 9.61, 261.88, -430.27, 7.70},
			time_15 = {251.09, -424.23, 3.46, 241.52, -427.03, 4.16},
			time_10 = {228.93, -432.98, 4.61, 238.39, -429.87, 3.72},
		},
		spawns = {
			{244.22, -429.85, 4.24, -74.3},
			{244.14, -424.75, 4.23, -73.1},
			{240.57, -430.00, 4.25, -68.4},
			{239.68, -427.06, 4.25, -65.9},
			{238.59, -431.31, 4.27, -65.0},
			{236.55, -428.08, 4.22, -62.8},
			{233.00, -429.90, 4.19, -62.8},
			{233.87, -433.12, 4.27, -66.3},
		},
		checkpoints = {
			{274.04, -423.98, 2.43},
			{330.50, -437.21, 3.18},
			{411.09, -425.35, 2.86},
			{450.41, -453.86, 2.78},
			{443.56, -488.10, 3.31},
			{527.44, -512.95, 6.43},
			{541.21, -475.83, 4.43},
			{551.31, -436.94, 4.43},
			{571.39, -400.45, 5.96},
			{571.92, -288.11, 3.69},
			{524.05, -221.75, 7.11},
			{468.73, -221.36, 7.2},
			{277.31, -315.15, 8.04},
			{56.07, -343.20, 8.0},
			{-29.33, -251.78, 6.25},
			{-45.24, -307.00, 3.97},
			{-8.93, -315.65, 3.30},
			{42.62, -366.37, 0.36},
			{130.90, -382.46, 2.59},
			{148.69, -454.27, 2.53},
			{183.36, -459.97, 2.52},
			{247.09, -425.85, 2.63},
		},
		music_replay = 170,
		music = {
			intro = "MS_Misbehaving_NISPrankInfo",
			gameplay = "MS_GoKarts02",
			results = "MS_Misbehaving_NISPrankInfo",
		},
	},
	{ -- Outdoors Adventure (Homemade Gokart, by SWEGTA) | BULLWORTH ACADEMY | 2:00 PM - 8:00 PM
		name = "Outdoors Adventure (Homemade Gokart)",
		id = "school_homemadegokart",
		description = "It's time for some fresh air! ... after you've made your way through industrial air and gokart fumes. (Vehicle: Homemade Gokart)",
		warp_pos = {198.76, -23.37, 6.19, -93.3}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {14, 0},
		end_time = {20, 0},
		area = 0,
		weather = 0,
		clock = {15, 15},
		blip = {201.92, -23.42, 6.24, 8}, -- last number is radius to play
		spectator_bounds = {-45.02, -86.21, -33.56, -60.89}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {-39.54, -73.68, 1.00, 3}, -- last number is spawn radius not heading
		max_timer = 300, -- max seconds
		vehicle = "homemade_gokart",
		laps = 1,
		cameras = {
			results = {-45.77, -73.44, 1.38, -54.20, -73.25, 6.74},
			time_15 = {-45.73, -83.30, 1.52, -51.58, -75.66, 4.24},
			time_10 = {21.51, -67.02, 14.39, 11.77, -67.69, 12.24},
		},
		spawns = {
			{-49.77, -79.11, 1.97, -87.9},
			{-49.86, -77.29, 1.98, -89.0},
			{-49.85, -75.70, 1.96, -88.4},
			{-49.89, -73.67, 1.93, -89.1},
			{-49.87, -71.89, 1.91, -90.5},
			{-49.73, -70.15, 1.88, -87.8},
			{-49.89, -68.39, 1.88, -88.0},
			{-49.96, -66.52, 1.86, -88.7},
			{-50.04, -64.79, 1.85, -89.2},
			{-49.88, -81.01, 1.96, -90.2},
		},
		checkpoints = {
			{9.51, -72.90, 5.51-0.60},
			{128.66, -73.05, 6.61-0.60},
			{271.24, -73.00, 6.58-0.60},
			{341.74, -63.58, 4.99-0.60},
			{410.49, -70.81, 6.10-0.60},
			{438.89, -104.16, 5.94-0.60},
			{425.96, -206.24, 4.05-0.60},
			{447.91, -239.26, 7.26-0.60},
			{521.14, -221.27, 7.71-0.60},
			{571.50, -325.23, 4.45-0.60},
			{528.26, -426.85, 4.81-0.60},
			{566.16, -387.13, 3.10-0.60},
			{555.16, -358.96, 3.93-0.60},
			{537.63, -356.26, 3.25-0.60},
			{506.32, -374.01, 4.40-0.60},
			{477.88, -374.09, 3.45-0.60},
			{467.67, -400.21, 4.16-0.60},
			{377.87, -425.26, 3.27-0.60},
			{296.35, -418.90, 3.75-0.60},
			{320.90, -370.80, 3.27-0.60},
			{309.80, -340.26, 3.27-0.60},
			{264.21, -356.65, 3.28-0.60},
			{151.59, -370.77, 3.18-0.60},
			{72.44, -358.24, 0.89-0.60},
			{11.96, -271.90, 2.91-0.60},
			{-69.96, -224.35, 6.11-0.60},
			{-67.81, -160.75, 7.29-0.60},
			{-68.79, -20.91, 4.85-0.60},
			{191.39, 29.03, 4.25-0.60},
			{225.80, 6.34, 6.50-0.60},
			{124.01, -73.21, 6.58-0.60},
			{9.52, -73.10, 5.51-0.60},
			{-27.30, -73.66, 1.59-0.60},
		},
		music_replay = 197,
		music = {
			intro = "MS_TensionBuilder01",
			gameplay = "MS_JockBossBattle",
			results = "MS_TensionBuilder01",
		},
	},
	{ -- Graveyard Shift (Creepy Car, by SWEGTA) | NEW COVENTRY | 8:00 PM - 2:00 AM
		name = "Graveyard Shift (Creepy Car)",
		id = "coventry_creepycar",
		description = "Bring out your dead! ... and dispose of them properly at the graveyard. (Vehicle: Creepy Car)",
		warp_pos = {478.82, -311.32, 2.82, 88.2}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {20, 0},
		end_time = {2, 0},
		area = 0,
		weather = 2,
		clock = {23, 00},
		blip = {471.21, -312.13, 2.89, 8}, -- last number is radius to play
		spectator_bounds = {638.82, 182.48, 654.14, 188.04}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {645.32, 187.43, 18.23, 3}, -- last number is spawn radius not heading
		max_timer = 300, -- max seconds
		vehicle = "creepycar",
		laps = 1,
		cameras = {
			results = {647.97, 185.46, 18.17, 655.93, 183.78, 23.98},
			time_15 = {102.42, -346.46, 8.54, 112.30, -345.09, 9.33},
			time_10 = {49.04, -356.01, 9.22, 39.43, -358.73, 9.63},
		},
		spawns = {
			{-6.42, -368.14, 8.69, -70.7},
			{-4.95, -372.45, 8.69, -71.3},
			{-4.08, -376.11, 8.69, -73.2},
			{2.01, -365.52, 8.69, -72.2},
			{3.01, -370.02, 8.68, -74.0},
			{4.03, -373.80, 8.69, -73.4},
			{11.74, -362.85, 8.68, -72.5},
			{12.77, -366.85, 8.69, -73.8},
			{13.89, -371.01, 8.69, -73.7},
			{22.87, -368.15, 8.68, -73.2},
			{21.84, -364.12, 8.69, -73.1},
			{20.71, -360.39, 8.69, -72.3},
		},
		checkpoints = {
			{111.65, -344.86, 8.96-0.90},
			{293.59, -311.60, 9.19-0.90},
			{505.31, -224.40, 8.06-0.90},
			{580.42, -385.15, 5.79-0.90},
			{510.93, -459.46, 4.76-0.90},
			{490.33, -414.07, 2.93-0.90},
			{501.96, -215.68, 2.93-0.90},
			{543.79, -134.37, 6.36-0.90},
			{577.04, -47.55, 6.53-0.70},
			{539.07, 334.51, 17.59-0.90},
			{552.83, 452.67, 18.31-0.80},
			{447.07, 520.82, 22.84-0.90},
			{372.40, 383.64, 20.63-0.90},
			{380.63, 189.94, 7.07-0.90},
			{416.42, 162.02, 7.02-0.90},
			{436.59, 94.39, 6.11-0.90},
			{476.82, 99.80, 7.34-0.90},
			{520.77, 132.20, 11.43-0.90},
			{648.83, 152.59, 18.62-0.90},
			{630.05, 219.31, 18.05-0.90},
		},
		music_replay = 59,
		music = {
			intro = "MS_HalloweenMid",
			gameplay = "MS_HalloweenHigh",
			results = "MS_HalloweenLow",
		},
	},
	{ -- Radioactive Trip (Super Gokart, by SWEGTA) | BLUE SKIES | 2:00 PM - 8:00 PM
		name = "Radioactive Trip (Super Gokart)",
		id = "blue_skies_radioactivegokart",
		description = "The gokarts have fallen into toxic waste! Perfect time to take 'em for a spin across Bullworth. (Vehicle: Super Gokart)",
		warp_pos = {236.37, -432.52, 2.70, -151.6}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {14, 0},
		end_time = {20, 0},
		area = 0,
		weather = 3,
		clock = {21, 30},
		blip = {239.94, -438.85, 2.66, 8}, -- last number is radius to play
		spectator_bounds = {135.46, -504.75, 137.31, -484.42}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {137.83, -493.91, 2.49, 3}, -- last number is spawn radius not heading
		max_timer = 300, -- max seconds
		vehicle = {
			"supergokartA",
			"supergokartB",
		},
		laps = 1,
		cameras = {
			results = {128.44, -493.02, 3.48, 137.67, -489.50, 5.05},
			time_15 = {116.67, -507.66, 3.74, 109.06, -514.03, 4.97},
			time_10 = {160.79, -475.12, 6.16, 152.66, -480.90, 6.79},
		},
		spawns = {
			{114.16, -520.04, 3.84, -47.2},
			{113.06, -518.89, 3.75, -49.2},
			{111.91, -517.69, 3.68, -46.3},
			{110.72, -516.34, 3.63, -47.8},
			{109.47, -515.04, 3.58, -49.2},
			{108.18, -513.59, 3.53, -49.4},
			{107.01, -512.36, 3.48, -47.9},
			{105.68, -510.80, 3.47, -51.1},
			{104.60, -509.60, 3.46, -48.0},
			{103.51, -508.45, 3.45, -47.9},
		},
		checkpoints = {
			{150.51, -482.78, 2.90-0.60},
			{219.68, -438.87, 3.33-0.60},
			{308.80, -434.10, 3.19-0.60},
			{439.66, -411.60, 3.06-0.60},
			{509.20, -396.99, 2.76-0.60},
			{545.76, -368.94, 2.59-0.60},
			{541.52, -293.50, 2.63-0.60},
			{500.90, -220.04, 2.59-0.60},
			{520.10, -167.39, 7.81-0.60},
			{547.67, -160.24, 11.59-0.60},
			{578.48, -142.72, 8.45-0.60},
			{560.95, -113.70, 6.11-0.60},
			{522.28, -105.94, 4.99-0.60},
			{512.45, -65.19, 5.72-0.60},
			{493.78, -44.04, 5.95-0.60},
			{466.93, -31.38, 6.41-0.60},
			{555.24, 11.39, 7.32-0.60},
			{592.17, 34.00, 13.24-0.60},
			{649.60, 99.16, 9.16-0.60},
			{606.36, 126.12, 12.87-0.60},
			{529.31, 110.67, 8.77-0.60},
			{479.06, 159.44, 10.01-0.60},
			{461.86, 75.46, 4.70-0.60},
			{386.60, 100.70, 5.79-0.60},
			{339.74, 70.93, 6.89-0.60},
			{327.70, -106.40, 6.82-0.60},
			{440.81, -109.69, 5.08-0.60},
			{430.44, -264.00, 3.36-0.60},
			{460.65, -379.63, 3.70-0.60},
			{443.96, -411.85, 3.10-0.60},
			{344.81, -434.70, 3.34-0.60},
			{249.28, -425.08, 3.20-0.60},
			{150.18, -483.17, 2.90-0.60},
		},
		music_replay = 125,
		music = {
			intro = "E_HQMX_Dropouts",
			gameplay = "MS_RussellInTheHole",
			results = "E_HQMX_Dropouts",
		},
	},
	{ -- BMX Challenge (Bike, by SWEGTA) | BMX PARK | 8:00 AM - 2:00 PM
		name = "BMX Challenge (Bike)",
		id = "bmx_bikechallenge",
		description = "A hectic race through crazily spread out checkpoints. (Vehicle: Shop Class 4 BMX)",
		warp_pos = {236.37, -432.52, 2.70, -151.6}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {8, 0},
		end_time = {14, 0},
		area = 62,
		weather = 1,
		clock = {13, 00},
		blip = {-722.35, 647.20, 29.11, 8}, -- last number is radius to play
		spectator_bounds = {-781.80, 632.03, -777.65, 642.67}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {-779.79, 638.30, 29.51, 2}, -- last number is spawn radius not heading
		max_timer = 180, -- max seconds
		vehicle = 278,
		laps = 1,
		cameras = {
			results = {-722.65, 646.84, 29.08, -716.99, 647.44, 37.30},
			time_15 = {-761.52, 659.68, 36.79, -757.24, 650.83, 34.94},
			time_10 = {-751.80, 656.03, 29.93, -761.01, 659.92, 29.77},
		},
		spawns = {
			{-753.96, 657.74, 29.73, -178.4},
			{-755.04, 657.68, 29.73, -179.3},
			{-756.26, 657.58, 29.73, -174.7},
			{-757.46, 657.59, 29.73, -176.3},
			{-758.55, 657.58, 29.73, -179.9},
			{-759.54, 657.56, 29.73, -179.6},
			{-760.60, 657.48, 29.73, -176.4},
			{-761.69, 657.46, 29.73, -176.9},
			{-762.86, 657.46, 29.73, -176.7},
			{-763.99, 657.34, 29.73, -173.4},
		},
		checkpoints = {
			{-749.12, 637.33, 30.9},
			{-727.72, 621.48, 31.47},
			{-774.86, 623.13, 30.37},
			{-748.09, 657.30, 31.56},
			{-732.55, 626.68, 29.08},
			{-773.86, 658.01, 31.78},
			{-722.61, 657.66, 31.28},
			{-774.86, 616.59, 31.49},
			{-748.34, 653.15, 30.51},
			{-726.04, 622.85, 31.46},
			{-749.18, 636.67, 30.9},
			{-771.08, 643.13, 29.36},
			{-774.32, 639.35, 29.38},
			{-753.29, 616.35, 29.54},
			{-753.55, 619.55, 29.08},
			{-749.11, 646.12, 29.08},
			{-748.19, 628.21, 29.08},
			{-726.35, 622.46, 31.47},
			{-756.58, 637.09, 29.08},
			{-739.07, 636.47, 29.08},
			{-731.75, 624.81, 29.08},
		},
		music_replay = 135,
		music = {
			intro = "MS_Misbehaving_NISPrankInfo",
			gameplay = "MS_BikePractice",
			results = "MS_Misbehaving_NISPrankSucess",
		},
	},
	{ -- Back to School (Bike, by SWEGTA) | BULLWORTH TOWN | 8:00 AM - 2:00 PM
		name = "Back to School (Bike)",
		id = "town_backtoschool",
		description = "Playtime's over! Back to school to learn you some knowledge! (Vehicle: Aquaberry Cruiser)",
		warp_pos = {489.47, -67.46, 5.42, 177.3}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {8, 0},
		end_time = {14, 0},
		area = 0,
		weather = 1,
		clock = {9, 00},
		blip = {486.79, -76.26, 5.40, 8}, -- last number is radius to play
		spectator_bounds = {229.70, -96.24, 240.27, -85.80}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {234.37, -93.43, 6.25, 3}, -- last number is spawn radius not heading
		max_timer = 300, -- max seconds
		vehicle = 283,
		laps = 1,
		cameras = {
			results = {254.13, -106.11, 14.76, 246.17, -100.16, 15.79},
			time_15 = {588.09, -87.92, 6.33, 597.65, -88.82, 9.12},
			time_10 = {632.38, -82.13, 9.07, 634.00, -91.97, 9.91},
		},
		spawns = {
			{633.27, -83.81, 9.52, 90.0},
			{633.19, -84.71, 9.52, 93.7},
			{633.22, -85.75, 9.52, 93.2},
			{633.16, -86.55, 9.52, 95.4},
			{633.25, -87.36, 9.52, 99.4},
			{633.23, -90.51, 9.52, 83.3},
			{633.24, -91.45, 9.52, 88.8},
			{633.25, -92.39, 9.52, 94.8},
			{633.28, -93.40, 9.52, 99.6},
			{633.30, -94.31, 9.52, 97.1},
		},
		checkpoints = {
			{564.25, -89.56, 5.39},
			{478.88, -89.54, 5.34},
			{467.10, -29.94, 5.94},
			{534.49, 1.69, 6.0},
			{587.44, 30.20, 11.40},
			{647.29, 82.98, 8.62},
			{650.66, 156.41, 17.91},
			{580.28, 299.99, 14.16},
			{590.52, 369.41, 15.77},
			{591.29, 410.51, 17.05},
			{487.69, 423.97, 17.24},
			{436.55, 424.71, 17.42},
			{437.75, 390.98, 17.27},
			{457.95, 345.49, 16.44},
			{473.80, 275.27, 21.17},
			{435.88, 242.17, 9.77},
			{412.38, 198.42, 6.61},
			{358.30, 197.76, 5.84},
			{294.76, 213.14, 4.57},
			{339.20, 115.93, 5.13},
			{329.67, -12.51, 4.73},
			{303.78, -72.50, 5.81},
			{208.99, -73.37, 8.68},
		},
		music_replay = 108,
		music = {
			intro = "MS_PrepFight",
			gameplay = "MS_BikeRace02",
			results = "MS_BiologyClass",
		},
	},
	{ -- Fire Rescue (Moped, by SWEGTA) | BULLWORTH TOWN | 8:00 AM - 2:00 PM
		name = "Fire Rescue (Moped)",
		id ="town_firerescue",
		description = "The Bullworth Fire Rescue Department is hosting a moped race. Safety first! (Vehicle: Moped)",
		warp_pos = {489.47, -67.46, 5.42, 177.3}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {8, 0},
		end_time = {14, 0},
		area = 0,
		weather = 1,
		clock = {10, 00},
		blip = {486.85, -74.07, 5.42, 8}, -- last number is radius to play
		spectator_bounds = {587.65, -43.68, 597.88, -36.08}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {592.58, -39.97, 6.17, 3}, -- last number is spawn radius not heading
		max_timer = 240, -- max seconds
		vehicle = "scooter_fireman",
		laps = 1,
		cameras = {
			results = {254.13, -106.11, 14.76, 246.17, -100.16, 15.79},
			time_15 = {593.91, -23.00, 6.56, 598.06, -31.24, 10.40},
			time_10 = {533.70, -35.59, 6.89, 543.70, -35.57, 7.21},
		},
		spawns = {
			{595.08, -24.25, 6.43, 92.9},
			{595.24, -25.76, 6.43, 94.9},
			{595.30, -27.13, 6.42, 94.2},
			{595.32, -28.45, 6.41, 90.5},
			{595.38, -29.92, 6.40, 91.6},
			{595.42, -31.30, 6.38, 92.7},
			{595.44, -32.69, 6.37, 93.5},
			{595.53, -34.03, 6.35, 90.7},
			{595.61, -35.39, 6.34, 90.8},
			{595.69, -36.93, 6.32, 91.7},
		},
		checkpoints = {
			{568.49, -33.72, 5.42},
			{522.09, -50.90, 5.52},
			{527.81, -89.52, 4.11},
			{586.65, -74.46, 5.42},
			{620.11, -89.43, 5.42},
			{598.98, -104.78, 5.35},
			{570.88, -125.43, 5.44},
			{494.77, -149.11, 4.75},
			{501.54, -217.21, 2.01},
			{494.27, -264.89, 2.31},
			{477.06, -287.61, 2.80},
			{492.79, -327.20, 2.84},
			{494.48, -400.04, 2.32},
			{485.93, -451.35, 2.64},
			{518.35, -470.39, 4.33},
			{563.81, -485.47, 4.40},
			{567.67, -449.76, 4.35},
			{525.57, -444.90, 4.32},
			{513.43, -459.73, 4.06},
			{482.88, -444.44, 2.64},
			{501.98, -397.02, 2.21},
			{535.32, -390.62, 2.02},
			{545.66, -370.24, 2.01},
			{539.48, -293.66, 2.05},
			{508.09, -288.11, 2.05},
			{498.49, -230.98, 2.01},
			{500.62, -176.63, 3.01},
			{485.36, -137.41, 4.92},
			{448.51, -92.10, 5.28},
			{357.13, -115.60, 6.03},
			{326.64, -104.92, 6.22},
			{322.35, -37.77, 4.65},
			{340.75, 23.57, 5.21},
			{339.44, 95.73, 4.41},
			{347.62, 139.78, 5.16},
			{380.52, 165.62, 5.24},
			{388.21, 249.76, 8.35},
			{452.97, 249.60, 10.27},
			{486.07, 249.54, 13.06},
			{539.59, 237.44, 16.27},
			{543.34, 147.48, 12.77},
			{561.90, 74.39, 13.68},
			{576.06, 6.96, 8.37},
			{597.30, -31.83, 6.44},
		},
		music_replay = 162,
		music = {
			intro = "MS_BikeFastMid",
			gameplay = "MS_BikeFastHigh",
			results = "MS_BikeFun_NIS",
		},
	},
	{ -- On Board (Electric Skateboard, by SWEGTA) | NEW COVENTRY | 8:00 AM - 2:00 PM
		name = "On Board (Electric Skateboard)",
		id = "coventry_electricskateboard",
		description = "High-speed skating from Bullworth Central Station to the academy. (Vehicle: Electric Skateboard)",
		warp_pos = {478.82, -311.32, 2.82, 88.2}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {8, 0},
		end_time = {14, 0},
		area = 0,
		weather = 1,
		clock = {13, 30},
		blip = {471.17, -309.76, 2.89, 8}, -- last number is radius to play
		spectator_bounds = {92.83, -78.18, 113.54, -62.81}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {102.97, -65.21, 7.32, 2}, -- last number is spawn radius not heading
		max_timer = 240, -- max seconds
		vehicle = "skateboard_electric",
		laps = 1,
		cameras = {
			results = {100.69, -72.27, 12.26, 110.14, -75.45, 12.99},
			time_15 = {476.16, -314.95, 9.80, 466.80, -318.13, 8.25},
			time_10 = {462.40, -330.92, 20.12, 462.42, -321.95, 15.70},
		},
		spawns = {
			{468.00, -319.14, 7.41},
			{467.00, -319.14, 7.41},
			{466.00, -319.14, 7.41},
			{465.00, -319.14, 7.41},
			{464.00, -319.14, 7.41},
			{463.00, -319.14, 7.41},
			{462.00, -319.14, 7.41},
			{461.00, -319.14, 7.41},
			{460.00, -319.14, 7.41},
			{459.00, -319.14, 7.41},
		},
		checkpoints = {
			{460.16, -280.85, 2.01},
			{461.04, -240.47, 2.01},
			{475.00, -240.03, 2.41},
			{484.58, -291.98, 2.58},
			{516.05, -298.00, 2.35},
			{522.41, -330.50, 2.78},
			{517.72, -367.47, 2.95},
			{490.29, -373.11, 2.66},
			{472.18, -384.12, 4.14},
			{453.24, -423.01, 3.88},
			{448.67, -441.81, 4.42},
			{443.92, -484.34, 3.26},
			{490.19, -500.73, 5.23},
			{529.16, -510.49, 6.32},
			{540.13, -482.90, 4.40},
			{544.32, -451.79, 5.53},
			{556.35, -422.66, 5.78},
			{583.65, -378.26, 4.54},
			{571.46, -338.19, 4.93},
			{571.87, -288.49, 3.74},
			{522.10, -221.15, 7.13},
			{474.87, -227.16, 7.15},
			{430.44, -248.78, 3.87},
			{425.48, -197.85, 3.46},
			{446.93, -172.90, 3.52},
			{518.15, -173.11, 5.07},
			{538.19, -164.24, 5.33},
			{522.35, -132.22, 5.62},
			{529.66, -113.37, 5.27},
			{574.80, -110.44, 5.57},
			{577.50, -60.97, 5.51},
			{564.57, -18.30, 5.84},
			{550.40, -1.87, 5.42},
			{523.30, -3.90, 5.79},
			{468.81, -22.25, 5.86},
			{472.43, -67.42, 5.67},
			{502.22, -65.12, 7.10},
			{539.25, -70.60, 5.41},
			{533.61, -89.31, 4.43},
			{470.92, -89.92, 5.48},
			{437.58, -86.96, 5.59},
			{387.05, -58.77, 6.10},
			{341.57, -63.77, 4.41},
			{302.83, -72.46, 5.80},
			{271.77, -73.00, 6.00},
			{239.28, -63.49, 6.18},
			{209.22, -34.49, 6.17},
			{160.86, 5.79, 6.02},
			{134.56, 27.03, 6.13},
			{118.38, 3.29, 6.13},
			{109.92, -16.41, 6.12},
			{107.16, -38.79, 5.57},
			{103.24, -62.67, 7.39},
		},
		music_replay = 108,
		music = {
			intro = "MS_TensionBuilder01",
			gameplay = "MS_GoKart 01",
			results = "MS_TensionBuilder01",
		},
	},
	{ -- Shop 'til You Drop (Shopping Cart, by SWEGTA) | BULLWORTH ACADEMY | 8:00 AM - 2:00 PM
		name = "Shop 'til You Drop (Shopping Cart)",
		id = "school_shoppingcart",
		description = "Edna needs you to head into town and pick up a bunch of items. (Vehicle: Motorized Shopping Cart)",
		warp_pos = {198.76, -23.37, 6.19, -93.3}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {8, 0},
		end_time = {14, 0},
		area = 0,
		weather = 0,
		clock = {11, 38},
		blip = {201.92, -23.42, 6.24, 8}, -- last number is radius to play
		spectator_bounds = {183.21, -12.45, 214.35, 12.34}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {198.44, -1.11, 5.46, 1.2}, -- last number is spawn radius not heading
		max_timer = 300, -- max seconds
		vehicle = {
			"shoppingcart_fast",
			"shoppingcart_fast_basic",
		},
		laps = 1,
		cameras = {
			results = {252.41, 19.68, 21.48, 243.60, 15.59, 19.11},
			time_15 = {167.69, -15.35, 6.57, 164.88, -5.78, 7.35},
			time_10 = {215.96, 4.60, 6.95, 225.56, 5.02, 9.72},
		},
		spawns = {
			{164.91, -13.16, 6.08, -83.7},
			{164.93, -10.78, 6.00, -85.1},
			{164.86, -8.50, 5.93, -86.5},
			{164.83, -6.03, 5.84, -89.3},
			{164.75, -3.54, 5.76, -90.4},
			{164.80, -1.19, 5.67, -89.8},
			{164.82, 1.19, 5.64, -91.3},
			{164.92, 3.92, 5.63, -93.7},
			{165.06, 6.18, 5.62, -93.3},
			{165.20, 8.67, 5.59, -94.6},
		},
		checkpoints = {
			{224.72, 6.59, 5.97},
			{297.02, 5.81, 4.50},
			{338.05, 6.82, 4.75},
			{339.75, 95.25, 4.49},
			{350.89, 150.82, 5.17, sound = "BuyItem", bank = "Hud.bnk"}, -- Yum Yum Market Vale
			{370.11, 151.33, 4.92, sound = "BuyItem", bank = "Hud.bnk"}, -- Easy Drugs Vale
			{380.36, 163.58, 5.23},
			{390.54, 199.47, 6.46},
			{434.82, 184.16, 8.44, sound = "BuyItem", bank = "Hud.bnk"}, -- Aquaberry Vale
			{435.94, 216.68, 8.87},
			{414.62, 260.76, 9.17},
			{411.67, 286.35, 9.03},
			{405.45, 284.63, 9.05, sound = "BuyItem", bank = "Hud.bnk"}, -- Burgers Vale
			{350.84, 309.47, 8.46, sound = "BuyItem", bank = "Hud.bnk"}, -- Shinjo's Vale
			{331.19, 309.41, 6.39, sound = "BuyItem", bank = "Hud.bnk"}, -- Homemade Ice Cream Vale
			{332.43, 274.80, 6.06, sound = "BuyItem", bank = "Hud.bnk"}, -- Shiny Bikes Vale
			{328.73, 263.21, 5.93, sound = "BuyItem", bank = "Hud.bnk"}, -- Dry Seaman Bar Vale
			{322.46, 242.27, 4.88, sound = "BuyItem", bank = "Hud.bnk"}, -- Crabs Vale
			{294.47, 211.36, 4.54},
			{321.75, 158.75, 5.03},
			{337.97, 60.93, 6.79},
			{325.60, -14.90, 4.72},
			{319.00, -95.81, 5.59},
			{361.91, -117.12, 5.95},
			{428.42, -100.14, 5.74},
			{453.13, -94.11, 5.43},
			{467.65, -119.03, 5.51},
			{488.98, -140.06, 4.95},
			{501.59, -209.22, 2.04},
			{494.90, -277.60, 2.47, sound = "BuyItem", bank = "Hud.bnk"}, -- Yum Yum Market Coventry
			{477.06, -294.19, 2.77},
			{492.32, -326.98, 2.89},
			{495.04, -369.16, 2.79},
			{504.08, -395.60, 2.36},
			{531.48, -394.18, 2.10},
			{540.90, -366.58, 2.36, sound = "BuyItem", bank = "Hud.bnk"}, -- The Golden Horseshoe Coventry
			{550.70, -304.13, 2.44, sound = "BuyItem", bank = "Hud.bnk"}, -- The Final Cut Coventry
			{538.92, -293.36, 2.10},
			{507.85, -288.75, 2.10},
			{500.02, -230.67, 2.07},
			{503.38, -180.00, 2.88},
			{510.19, -128.20, 5.55, sound = "BuyItem", bank = "Hud.bnk"}, -- Spazz Industries Hardware Store Town
			{534.19, -129.24, 5.73, sound = "BuyItem", bank = "Hud.bnk"}, -- Come Hither Town
			{543.63, -141.65, 5.93, sound = "BuyItem", bank = "Hud.bnk"}, -- Worn In Town
			{558.00, -130.97, 5.54},
			{576.07, -109.92, 5.60},
			{570.44, -89.72, 5.63},
			{549.36, -81.20, 5.45, sound = "BuyItem", bank = "Hud.bnk"}, -- The Happy Diner Town
			{542.92, -96.45, 5.42, sound = "BuyItem", bank = "Hud.bnk"}, -- The Happy Mullet Town
			{534.02, -81.81, 4.71, sound = "BuyItem", bank = "Hud.bnk"}, -- Yum Yum Market Town
			{514.99, -98.36, 4.57, sound = "BuyItem", bank = "Hud.bnk"}, -- Easy Drugs Town
			{499.15, -80.99, 4.77, sound = "BuyItem", bank = "Hud.bnk"}, -- Rocket in My Pocket Town
			{486.81, -97.03, 5.30, sound = "BuyItem", bank = "Hud.bnk"}, -- Mexican Restaurant Town
			{480.92, -78.83, 5.57, sound = "BuyItem", bank = "Hud.bnk"}, -- Shiny Bikes Town
			{474.89, -98.60, 5.66, sound = "BuyItem", bank = "Hud.bnk"}, -- J Town
			{472.17, -62.85, 5.83, sound = "BuyItem", bank = "Hud.bnk"}, -- Sweet Cavity Town
			{473.00, -45.91, 5.52},
			{492.23, -43.74, 5.41},
			{516.60, -56.17, 5.57, sound = "BuyItem", bank = "Hud.bnk"}, -- Dragon's Wing Town
			{516.67, -89.55, 4.09},
			{433.58, -93.81, 5.59},
			{340.50, -111.75, 6.27},
			{324.53, -45.30, 4.77},
			{299.59, 5.79, 4.46},
			{226.60, 6.07, 5.96},
		},
		music_replay = 90,
		music = {
			intro = "MS_PrepFight",
			gameplay = "MS_GoKart02",
			results = "MS_PrepFight",
		},
	},
	{ -- Marathon (On Foot, by SWEGTA) | OLD BULLWORTH VALE | 8:00 AM - 2:00 PM
		name = "Marathon (On Foot)",
		id = "vale_marathon_foot",
		description = "A marathon from the makeout spot, past the pirate ship, all the way to the Bullworth Town statue. Bring your swimming gear! (On Foot)",
		warp_pos = {342.50, 263.53, 6.23, 75.6}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {8, 0},
		end_time = {14, 0},
		area = 0,
		weather = 0,
		clock = {14, 00},
		blip = {335.32, 269.05, 5.89, 8}, -- last number is radius to play
		spectator_bounds = {583.33, -97.76, 591.43, -92.36}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {587.61, -95.46, 5.61, 1.2}, -- last number is spawn radius not heading
		max_timer = 360, -- max seconds
		vehicle = -1,
		laps = 1,
		cameras = {
			results = {558.44, -89.49, 6.80, 568.33, -89.98, 8.19},
			time_15 = {254.44, 342.25, 26.10, 259.33, 350.89, 24.97},
			time_10 = {254.96, 374.42, 22.00, 264.64, 371.94, 21.87},
		},
		spawns = {
			{266.16, 378.28, 20.03, -123.4},
			{265.03, 376.93, 19.99, -111.2},
			{264.33, 374.65, 19.99, -111.2},
			{263.94, 373.30, 19.98, -108.6},
			{263.58, 371.84, 19.98, -105.6},
			{263.35, 370.50, 19.98, -102.4},
			{263.22, 369.20, 19.97, -98.6},
			{263.18, 367.77, 19.96, -93.4},
			{263.26, 366.29, 19.95, -91.3},
			{263.36, 364.92, 19.93, -89.4},
		},
		checkpoints = {
			{279.23, 368.63, 19.91},
			{330.28, 359.50, 16.09},
			{328.29, 335.52, 12.53},
			{283.33, 338.25, 6.73},
			{235.52, 349.31, 3.85},
			{231.90, 330.34, 1.57},
			{279.16, 299.90, 2.83},
			{274.33, 242.44, 4.61},
			{228.97, 241.93, 3.48},
			{213.77, 241.72, 4.34},
			{192.24, 241.32, -1.25},
			{161.15, 209.19, -1.25},
			{117.12, 149.18, -1.25},
			{57.25, 173.36, -1.25},
			{23.00, 198.40, 8.42},
			{25.80, 234.85, -1.25},
			{49.49, 285.86, -1.25},
			{51.30, 304.95, 2.34},
			{48.03, 309.26, 2.40},
			{46.43, 316.34, 2.46},
			{39.93, 315.66, 2.71},
			{33.10, 316.12, 2.89},
			{30.73, 300.25, 4.04},
			{25.60, 272.84, -1.25},
			{15.28, 216.24, -1.25},
			{28.17, 166.85, -1.25},
			{63.76, 126.69, -1.25},
			{121.35, 95.21, -1.12},
			{151.31, 81.34, 3.27},
			{154.07, 53.23, 5.11},
			{178.88, 32.55, 4.68},
			{242.42, 12.31, 6.05},
			{297.87, 5.75, 4.42},
			{323.97, -1.30, 4.46},
			{323.34, -48.78, 4.73},
			{340.98, -63.88, 4.43},
			{381.86, -55.95, 6.18},
			{430.41, -80.73, 5.02},
			{443.37, -93.15, 5.27},
			{499.14, -89.53, 4.41},
			{569.86, -89.50, 5.56},
			{594.69, -89.40, 5.99},
		},
		music_replay = 139,
		music = {
			intro = "MS_FunLow",
			gameplay = "MS_RunningFight-2 MIX TR",
			results = "MS_FunMid",
		},
	},
	{ -- Taking Out the Trash (Garbage Bin, by SWEGTA) | OLD BULLWORTH VALE | 8:00 AM - 2:00 PM
		name = "Taking Out the Trash (Garbage Bin)",
		id = "vale_garbagebinrace",
		description = "A fast paced race from Old Bullworth Vale to the mini-junkyard in New Coventry. Always recycle! (Vehicle: Garbage Bin)",
		warp_pos = {342.50, 263.53, 6.23, 75.6}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {8, 0},
		end_time = {14, 0},
		area = 0,
		weather = 3,
		clock = {8, 00},
		blip = {332.16, 263.82, 5.91, 8}, -- last number is radius to play
		spectator_bounds = {423.15, -460.75, 438.39, -453.26}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {430.27, -457.91, 2.78, 1.2}, -- last number is spawn radius not heading
		max_timer = 240, -- max seconds
		vehicle = "garbage_bin",
		laps = 1,
		cameras = {
			results = {426.17, -462.45, 3.49, 432.23, -454.72, 5.37},
			time_15 = {537.20, 475.37, 18.97, 547.10, 475.69, 20.27},
			time_10 = {522.47, 472.23, 18.85, 512.47, 472.39, 18.92},
		},
		spawns = {
			{551.44, 483.79, 18.34, 104.3},
			{551.73, 482.03, 18.27, 100.2},
			{551.97, 480.49, 18.19, 102.3},
			{552.29, 478.89, 18.13, 104.4},
			{552.53, 477.34, 18.09, 96.3},
			{552.62, 475.63, 18.06, 99.2},
			{552.63, 474.06, 18.02, 92.6},
			{552.76, 472.39, 17.99, 89.8},
			{552.84, 470.65, 17.95, 85.4},
			{553.01, 468.92, 17.95, 89.0},
		},
		checkpoints = {
			{498.12, 472.01, 18.02},
			{471.58, 429.52, 18.47},
			{436.16, 423.41, 17.42},
			{434.46, 387.13, 17.27},
			{419.63, 367.68, 16.30},
			{456.63, 345.74, 15.96},
			{477.13, 314.41, 20.16},
			{479.16, 278.92, 19.95},
			{493.87, 270.45, 19.88},
			{508.22, 288.04, 20.10},
			{497.02, 311.73, 20.09},
			{477.62, 314.53, 20.16},
			{469.54, 329.58, 19.24},
			{450.08, 356.41, 15.69},
			{443.97, 392.16, 17.27},
			{462.09, 401.49, 16.12},
			{474.39, 419.04, 17.92},
			{487.19, 424.48, 17.31},
			{495.28, 417.52, 16.85},
			{494.55, 390.56, 16.85},
			{482.78, 339.68, 17.57},
			{473.50, 323.73, 19.75},
			{473.65, 275.26, 21.27},
			{446.14, 249.46, 9.95},
			{371.76, 241.76, 7.77},
			{343.38, 240.99, 7.01},
			{338.38, 220.41, 4.91},
			{351.41, 172.90, 5.45},
			{367.53, 167.44, 5.61},
			{396.77, 161.67, 6.23},
			{421.62, 162.05, 6.16},
			{428.01, 127.60, 5.71},
			{432.99, 99.88, 5.26}, --33
			{455.88, 75.49, 4.88},
			{478.22, 79.23, 3.61},
			{468.94, 125.45, 8.29},
			{471.17, 149.06, 9.32},
			{497.82, 163.51, 9.86},
			{525.22, 157.01, 14.53},
			{543.34, 142.76, 12.65},
			{571.35, 38.33, 12.12},
			{570.47, -17.35, 5.99},
			{550.19, -41.82, 5.60},
			{539.70, -72.31, 5.44},
			{522.54, -108.70, 4.61},
			{518.43, -136.54, 5.57},
			{495.82, -159.23, 4.51},
			{493.21, -180.76, 3.04},
			{443.50, -191.78, 3.39},
			{448.17, -206.43, 3.40},
			{483.55, -195.13, 2.90},
			{502.76, -209.67, 2.05},
			{497.76, -264.49, 2.19},
			{478.26, -279.82, 2.77},
			{479.78, -315.36, 2.91},
			{501.42, -320.62, 2.73},
			{502.15, -330.16, 4.12},
			{502.17, -358.49, 4.12},
			{495.68, -393.62, 2.71},
			{476.98, -445.25, 2.89},
			{457.60, -441.75, 2.71},
			{435.66, -449.20, 2.59},
		},
		music_replay = 95,
		music = {
			intro = "MS_ShopClass",
			gameplay = "MS_GoKarts01A",
			results = "MS_ShopClass",
		},
	},
	{ -- Mountain Biking (Bike, by SWEGTA) | OLD BULLWORTH VALE | 8:00 AM - 2:00 PM
		name = "Mountain Biking (Bike)",
		id = "vale_mountainbiking",
		description = "From the Bullworth Vale beach and down the mountain we go! (Vehicle: Mountain Bike)",
		warp_pos = {342.50, 263.53, 6.23, 75.6}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {8, 0},
		end_time = {14, 0},
		area = 0,
		weather = 0,
		clock = {9, 30},
		blip = {337.09, 269.03, 5.93, 8}, -- last number is radius to play
		spectator_bounds = {298.09, 113.13, 312.21, 135.12}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {308.15, 124.45, 2.53, 2}, -- last number is spawn radius not heading
		max_timer = 240, -- max seconds
		vehicle = 280,
		laps = 1,
		cameras = {
			results = {230.52, 163.98, 4.64, 239.42, 159.42, 4.64},
			time_15 = {293.78, 202.58, 24.17, 294.03, 193.18, 20.75},
			time_10 = {308.97, 126.05, 6.21, 303.53, 134.37, 5.17},
		},
		spawns = {
			{313.61, 129.57, 2.89, 27.7},
			{312.39, 128.87, 2.83, 26.2},
			{310.98, 128.05, 2.77, 26.4},
			{309.34, 127.10, 2.67, 26.1},
			{307.69, 126.15, 2.55, 25.3},
			{306.34, 125.43, 2.39, 23.6},
			{304.80, 124.65, 2.21, 23.6},
			{303.28, 123.90, 2.04, 22.7},
			{301.42, 122.99, 1.58, 21.9},
			{299.56, 122.09, 1.13, 21.4},
		},
		checkpoints = {
			{289.46, 155.56, 2.57},
			{258.87, 240.04, 0.63},
			{281.43, 293.36, 3.37},
			{239.78, 325.44, 1.34},
			{224.85, 339.24, 3.24},
			{251.57, 348.03, 4.61},
			{303.29, 333.22, 11.55},
			{336.57, 343.81, 14.33},
			{323.76, 363.27, 17.05},
			{293.90, 372.20, 19.83},
			{286.00, 400.30, 20.11},
			{304.00, 424.45, 21.22},
			{355.23, 422.73, 21.17},
			{380.75, 388.73, 19.90},
			{409.16, 388.28, 17.08},
			{444.48, 392.81, 17.22},
			{464.39, 403.24, 16.19},
			{476.55, 431.56, 18.29},
			{484.97, 469.50, 17.46},
			{550.15, 485.77, 18.31},
			{554.84, 511.00, 21.93},
			{542.24, 533.21, 24.29},
			{513.13, 539.66, 23.80},
			{481.09, 520.77, 19.74},
			{439.42, 520.57, 21.98},
			{388.09, 504.20, 23.57},
			{361.00, 489.88, 22.27},
			{324.33, 447.20, 23.69},
			{333.74, 410.83, 22.74},
			{308.81, 371.71, 25.50},
			-- {303.67, 356.25, 20.22},
			{296.57, 343.99, 17.21},
			{292.16, 329.57, 9.02},
			{281.69, 291.97, 3.28},
			{258.93, 242.78, 0.62},
			{270.68, 185.37, 2.11},
			{302.41, 138.07, 2.35},
		},
		music_replay = 137,
		music = {
			intro = "MS_RomanceLow",
			gameplay = "MS_Somower",
			results = "MS_RomanceMid",
		},
	},
	{ -- Going Postal (Moped, by SWEGTA) | OLD BULLWORTH VALE | 8:00 AM - 2:00 PM
		name = "Going Postal (Moped)",
		id = "vale_maildelivery",
		description = "Neither snow nor rain nor other players shall keep you from delivering mail to the residents of Old Bullworth Vale. (Vehicle: Moped)",
		warp_pos = {342.50, 263.53, 6.23, 75.6}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {8, 0},
		end_time = {14, 0},
		area = 0,
		weather = 5,
		clock = {8, 00},
		blip = {338.82, 269.01, 5.99, 8}, -- last number is radius to play
		spectator_bounds = {408.11, 255.28, 420.74, 260.15}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {414.12, 257.83, 9.26, 1.1}, -- last number is spawn radius not heading
		max_timer = 240, -- max seconds
		vehicle = "scooter_mailman",
		laps = 1,
		cameras = {
			results = {408.26, 240.62, 9.24, 415.13, 234.65, 13.39},
			time_15 = {413.99, 256.63, 10.16, 411.50, 246.97, 10.95},
			time_10 = {397.51, 249.38, 13.10, 407.51, 249.03, 12.95},
		},
		spawns = {
			{412.31, 246.45, 9.06, -90.8},
			{412.33, 248.03, 9.09, -91.0},
			{412.31, 249.53, 9.12, -87.8},
			{412.33, 251.42, 9.19, -89.2},
			{412.31, 253.10, 9.25, -89.5},
			{408.31, 246.45, 9.06, -90.8},
			{408.33, 248.03, 9.09, -91.0},
			{408.31, 249.53, 9.12, -87.8},
			{408.33, 251.42, 9.19, -89.2},
			{408.31, 253.10, 9.25, -89.5},
		},
		checkpoints = {
			{430.93, 249.57, 9.72},
			{457.34, 267.80, 10.82},
			{459.83, 302.62, 14.29},
			{445.80, 329.43, 16.40},
			{400.53, 346.30, 17.53},
			{374.93, 359.86, 18.89},
			{377.11, 437.35, 21.64},
			{397.05, 456.60, 22.91},
			{398.65, 512.98, 22.38},
			{445.02, 526.42, 22.02},
			{477.56, 519.64, 19.73},
			{517.51, 546.07, 24.21},
			{552.08, 530.62, 23.90},
			{554.31, 479.77, 18.31},
			{553.13, 449.76, 17.36},
			{564.71, 422.52, 16.95},
			{589.95, 415.81, 16.95},
			{597.54, 394.30, 16.57},
			{596.52, 352.50, 15.84},
			{569.27, 350.51, 16.34},
			{546.15, 334.22, 17.04},
			{546.48, 305.33, 16.99},
			{546.41, 249.41, 16.61},
			{546.02, 197.62, 16.81},
			{532.72, 168.03, 15.58},
			{539.92, 202.93, 16.59},
			{532.88, 272.29, 16.84},
			{539.37, 314.13, 16.76},
			{536.57, 353.58, 16.74},
			{515.68, 341.29, 16.86},
			{487.38, 371.38, 17.05},
			{494.04, 393.25, 16.79},
			{506.21, 421.26, 16.80},
			{521.17, 421.09, 16.86},
			{547.64, 443.66, 17.45},
			{551.90, 492.46, 18.70},
			{550.41, 523.91, 23.41},
			{518.80, 540.43, 23.95},
			{490.71, 517.10, 19.67},
			{437.38, 514.85, 22.17},
			{412.11, 515.18, 21.95},
			{388.06, 504.01, 23.57},
			{360.90, 489.67, 22.27},
			{324.25, 447.56, 23.66},
			{310.77, 437.33, 21.66},
			{348.88, 419.53, 21.59},
			{370.83, 409.95, 20.87},
			{376.09, 359.46, 18.87},
			{396.98, 347.23, 17.45},
			{437.48, 334.28, 16.10},
			{458.24, 309.97, 15.16},
			{455.78, 261.69, 10.53},
			{413.00, 241.34, 9.23},
		},
		music_replay = 184,
		music = {
			intro = "MS_MathClassEnd",
			gameplay = "MS_PunishmentDetention",
			results = "MS_MathClassEnd",
		},
	},
	{ -- Yay Or Neigh (Horse, by SWEGTA) | OLD BULLWORTH VALE | 8:00 AM - 2:00 PM
		name = "Yay Or Neigh (Horse)",
		id = "vale_horserace",
		description = "Rudy would be upset to miss out on betting on this equestrian event. Giddy up! (On Horseback)",
		warp_pos = {342.50, 263.53, 6.23, 75.6}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {8, 0},
		end_time = {14, 0},
		area = 0,
		weather = 0,
		clock = {12, 00},
		blip = {333.42, 263.20, 5.94, 8}, -- last number is radius to play
		spectator_bounds = {57.32, -322.62, 70.14, -304.46}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {65.55, -314.98, 0.27, 1.5}, -- last number is spawn radius not heading
		max_timer = 500, -- max seconds
		vehicle = "horse",
		laps = 1,
		cameras = {
			results = {101.05, -326.67, 9.39, 91.46, -326.31, 6.57},
			time_15 = {474.92, 419.49, 19.10, 466.46, 424.81, 19.48},
			time_10 = {451.54, 376.99, 18.26, 449.70, 367.16, 17.95},
		},
		spawns = {
			{469.72, 425.11, 18.01, 160.1},
			{468.23, 425.45, 18.01, 161.5},
			{466.58, 425.94, 18.02, 159.4},
			{464.89, 426.28, 18.03, 160.1},
			{463.33, 426.54, 18.10, 159.6},
			{461.69, 426.68, 18.10, 155.8},
			{459.70, 426.87, 18.12, 166.8},
			{457.79, 426.97, 18.14, 176.5},
			{456.15, 427.21, 18.24, 176.2},
			{454.40, 427.19, 18.35, 177.6},
		},
		checkpoints = {
			{453.68, 385.49, 17.74},
			{446.68, 341.78, 16.85},
			{430.71, 313.49, 17.23},
			{402.40, 306.56, 12.28},
			{339.48, 306.85, 8.41},
			{301.72, 304.59, 7.35},
			{282.28, 300.05, 3.46},
			{279.52, 245.77, 4.62},
			{278.90, 206.36, 4.60},
			{278.83, 186.21, 2.41},
			{313.83, 104.38, 2.68},
			{332.27, 84.14, 0.68},
			{395.40, 92.80, 5.10},
			{423.11, 91.79, 5.14},
			{457.73, 75.48, 4.85},
			{476.14, 78.06, 3.42},
			{469.86, 117.99, 7.83},
			{473.34, 154.56, 9.40},
			{509.21, 158.45, 11.59},
			{523.21, 127.90, 10.17},
			{535.26, 105.69, 7.51},
			{561.84, 105.99, 7.90},
			{634.11, 129.06, 14.08},
			{649.32, 101.97, 8.57},
			{634.83, 66.07, 8.57},
			{600.15, 40.45, 14.11},
			{569.60, 15.88, 9.31},
			{506.03, -9.23, 5.83},
			{468.22, -24.43, 5.95},
			{465.60, -70.36, 5.52},
			{444.04, -99.94, 5.48},
			{437.69, -151.98, 3.21},
			{425.93, -189.02, 3.42},
			{430.40, -265.00, 2.70},
			{436.77, -301.82, 3.29},
			{460.69, -380.08, 3.10},
			-- {462.27, -417.70, 2.53},
			{460.75, -422.00, 2.60},
			{454.40, -447.10, 2.67},
			{422.74, -438.97, 2.78},
			{399.19, -420.92, 2.60},
			{344.75, -434.70, 2.75},
			{323.57, -437.67, 3.17},
			-- {295.81, -437.43, 2.67},
			{293.92, -445.82, 3.40},
			{291.70, -453.71, 3.70},
			{270.95, -454.88, 3.64},
			{267.20, -430.50, 2.69},
			{273.49, -415.37, 2.74},
			{272.61, -392.40, 2.69},
			{277.05, -365.17, 2.76},
			{266.52, -357.49, 2.70},
			{241.41, -353.90, 2.63},
			{225.54, -342.75, 2.52},
			{205.64, -350.98, 2.58},
			{186.80, -365.60, 2.58},
			{150.22, -371.11, 2.64},
			{118.28, -362.19, 2.49},
			{72.66, -361.26, 0.31},
			{70.49, -330.08, 0.31},
		},
		music_replay = 120,
		music = {
			intro = "MS_FightingJohnnyVincentBikeRide",
			gameplay = "MS_FightingJohnnyVincentBossFight",
			results = "MS_FightingJohnnyVincentBikeRide",
		},
	},
	{ -- Natural Revenge (Mossman, by SWEGTA) | BULLWORTH TOWN | 8:00 AM - 2:00 PM
		name = "Natural Revenge (Mossman)",
		id = "town_mossman",
		description = "The legendary Bullworth cryptid is seeking revenge on the Chemplant for destroying his natural habitat. (Vehicle: Mossman)",
		warp_pos = {489.47, -67.46, 5.42, 177.3}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {8, 0},
		end_time = {14, 0},
		area = 0,
		weather = 0,
		clock = {13, 37},
		blip = {491.74, -79.02, 5.01, 8}, -- last number is radius to play
		spectator_bounds = {92.38, -487.89, 101.51, -477.74}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {93.21, -477.98, 2.67, 1.7}, -- last number is spawn radius not heading
		max_timer = 240, -- max seconds
		vehicle = "mossman",
		laps = 1,
		cameras = {
			results = {125.05, -450.28, 23.35, 119.31, -458.08, 20.86},
			time_15 = {433.96, -104.39, 6.08, 441.87, -98.68, 8.27},
			time_10 = {444.94, -119.43, 5.49, 442.73, -129.18, 5.22},
		},
		spawns = {
			{434.90, -102.75, 6.24, -168.3},
			{436.13, -102.36, 6.22, -170.5},
			{437.39, -101.96, 6.19, -169.2},
			{438.61, -101.54, 6.16, -173.1},
			{439.87, -101.24, 6.13, -175.6},
			{441.15, -100.92, 6.10, -178.0},
			{442.56, -100.56, 6.08, -176.5},
			{443.87, -100.26, 6.07, 176.5},
			{445.21, -99.96, 6.06, -176.0},
			{446.62, -99.74, 6.05, -178.0},
		},
		checkpoints = {
			{442.87, -132.39, 3.11},
			{426.78, -184.40, 3.43},
			{429.33, -249.47, 3.79},
			{433.22, -283.99, 5.60},
			{459.44, -377.52, 2.79},
			{459.04, -427.27, 2.57},
			{463.55, -441.77, 2.65},
			{495.58, -455.29, 2.91},
			{518.65, -469.20, 4.25},
			{525.71, -480.06, 4.34},
			{541.02, -476.59, 4.45},
			{548.43, -452.79, 4.45},
			{527.11, -433.26, 4.46},
			{530.88, -419.55, 3.85},
			{540.43, -416.40, 3.12},
			{545.08, -370.94, 2.01},
			{540.48, -323.45, 2.28},
			{528.43, -322.75, 3.08},
			{519.55, -341.06, 2.23},
			{517.42, -370.48, 2.76},
			{505.17, -374.18, 4.27},
			{478.54, -374.08, 2.88},
			{465.85, -404.77, 3.03},
			{453.74, -414.39, 2.55},
			{437.58, -410.53, 2.47},
			{379.53, -425.03, 2.68},
			{332.42, -437.28, 3.12},
			{291.08, -427.21, 2.48},
			{251.95, -423.76, 2.56},
			{228.94, -433.82, 2.62},
			{210.75, -452.50, 2.67},
			{198.02, -459.65, 6.21},
			{186.35, -466.64, 9.36},
			{172.31, -476.02, 5.49},
			{156.45, -478.01, 2.21},
			{142.70, -429.99, 2.40},
			{136.65, -402.34, 2.69},
			{121.67, -392.74, 2.52},
			{104.27, -400.09, 1.98},
			{99.88, -410.85, 1.80},
			{91.26, -413.53, 1.58},
			{78.86, -406.40, 1.24},
			{56.75, -402.10, 0.32},
			{53.95, -389.78, 4.38},
			{43.58, -367.54, 0.37},
			{-0.81, -322.79, 3.17},
			{-29.96, -306.84, 3.43},
			{-49.73, -307.25, 4.09},
			{-69.02, -299.68, 4.58},
			{-49.63, -278.61, 6.35},
			{-28.31, -250.38, 6.25},
			{10.43, -270.97, 2.43},
			{57.76, -300.25, 1.59},
			{72.39, -359.07, 0.31},
			{99.31, -365.01, 0.72},
			{130.83, -377.48, 2.58},
			{144.73, -439.65, 2.40},
			{150.39, -482.93, 2.31},
			{132.21, -497.98, 2.65},
			{114.54, -499.71, 2.62},
			{95.36, -491.55, 2.80},
			{85.28, -501.58, 4.45},
		},
		music_replay = 194,
		music = {
			intro = "MS_ShowdownAtThePlantLow",
			gameplay = "MS_ShowdownAtThePlantHigh",
			results = "MS_ShowdownAtThePlantLow",
		},
	},
	{ -- Chow Down (Food Truck, by SWEGTA) | OLD BULLWORTH VALE | 8:00 AM - 2:00 PM
		name = "Chow Down (Food Truck)",
		id = "vale_fooddelivery",
		description = "They hunger, and the only cure is a food van with questionable hygienic standards. (Vehicle: Food Truck)",
		warp_pos = {342.50, 263.53, 6.23, 75.6}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {8, 0},
		end_time = {14, 0},
		area = 0,
		weather = 0,
		clock = {12, 00},
		blip = {334.66, 262.59, 5.97, 8}, -- last number is radius to play
		spectator_bounds = {339.81, 304.16, 354.95, 309.94}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {348.21, 307.12, 8.39, 1.1}, -- last number is spawn radius not heading
		max_timer = 480, -- max seconds
		vehicle = "foodvan",
		laps = 1,
		shuffle = 14, -- randomize all checkpoints except the last one
		cameras = {
			results = {284.25, 153.97, 19.20, 292.11, 160.11, 18.47},
			time_15 = {284.25, 153.97, 19.20, 292.11, 160.11, 18.47},
			time_10 = {284.25, 153.97, 19.20, 292.11, 160.11, 18.47},
		},
		spawns = {
			{312.43, 298.48, 7.29, -175.8},
			{279.02, 211.87, 5.58, -3.5},
			{333.77, 115.66, 6.26, 3.8},
			{436.47, 316.59, 17.34, -136.7},
			{546.91, 225.16, 17.83, 0.5},
			{501.78, 404.24, 18.15, 2.1},
			{523.89, 469.62, 19.01, -85.5},
			{331.42, 219.62, 5.93, 75.6},
			{548.80, 183.63, 17.50, 9.1},
			{397.36, 404.60, 22.66, 75.3},
		},
		checkpoints = {
			{366.10, 375.61, 19.71, sound = "BuyItem", bank = "Hud.bnk"},
			{443.87, 515.66, 21.99, sound = "BuyItem", bank = "Hud.bnk"},
			{558.58, 520.77, 23.04, sound = "BuyItem", bank = "Hud.bnk"},
			{536.08, 374.02, 17.19, sound = "BuyItem", bank = "Hud.bnk"},
			{544.09, 290.07, 16.98, sound = "BuyItem", bank = "Hud.bnk"},
			{536.59, 170.67, 15.29, sound = "BuyItem", bank = "Hud.bnk"},
			{439.03, 233.70, 9.76, sound = "BuyItem", bank = "Hud.bnk"},
			{379.14, 250.87, 7.93, sound = "BuyItem", bank = "Hud.bnk"},
			{324.88, 274.49, 5.87, sound = "BuyItem", bank = "Hud.bnk"},
			{385.01, 192.17, 6.42, sound = "BuyItem", bank = "Hud.bnk"},
			{385.97, 148.36, 5.05, sound = "BuyItem", bank = "Hud.bnk"},
			{316.33, 228.63, 4.86, sound = "BuyItem", bank = "Hud.bnk"},
			{379.55, 300.57, 8.68, sound = "BuyItem", bank = "Hud.bnk"},
			{385.76, 242.65, 8.16, sound = "BuyItem", bank = "Hud.bnk"},
			{435.27, 92.60, 5.18, sound = "BuyItem", bank = "Hud.bnk"},
			{490.49, 368.61, 16.94, sound = "BuyItem", bank = "Hud.bnk"},
			{535.39, 278.39, 16.68, sound = "BuyItem", bank = "Hud.bnk"},
			{348.78, 295.62, 7.27, sound = "BuyItem", bank = "Hud.bnk"},
			{314.30, 440.24, 21.54, sound = "BuyItem", bank = "Hud.bnk"},
			{362.67, 305.35, 8.45},
		},
		music_replay = 78,
		music = {
			intro = "MS_FunLow",
			gameplay = "MS_FunHigh",
			results = "MS_FunMid",
		},
	},
	{ -- Sky High (On Foot, by SWEGTA) | BULLWORTH TOWN | 2:00 PM - 8:00 PM
		name = "Sky High (On Foot)",
		id = "town_rooftoprace",
		description = "A race to see who can climb the Bullworth Town rooftops the fastest. (On Foot)",
		warp_pos = {489.47, -67.46, 5.42, 177.3}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {14, 0},
		end_time = {20, 0},
		area = 0,
		weather = 0,
		clock = {18, 50},
		blip = {486.85, -74.07, 5.42, 8}, -- last number is radius to play
		spectator_bounds = {437.80, -102.05, 449.86, -83.81}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {445.33, -92.71, 5.24, 1.1}, -- last number is spawn radius not heading
		max_timer = 420, -- max seconds
		vehicle = -1,
		laps = 1,
		shuffle = 6, -- randomize all checkpoints except the last one
		cameras = {
			results = {629.57, -104.37, 26.07, 620.66, -100.92, 23.11},
			time_15 = {499.85, -88.95, 6.06, 489.88, -88.90, 6.76},
			time_10 = {447.06, -90.50, 9.40, 457.05, -90.75, 9.05},
		},
		spawns = {
			{457.28, -85.43, 5.45, -97.9},
			{457.28, -87.67, 5.42, -95.6},
			{457.45, -89.90, 5.40, -95.6},
			{457.36, -91.85, 5.37, -93.1},
			{457.55, -94.54, 5.33, -93.0},
			{454.47, -93.98, 5.42, -91.9},
			{454.38, -91.72, 5.41, -91.9},
			{454.31, -89.53, 5.40, -93.6},
			{454.47, -87.88, 5.40, -98.4},
			{454.60, -85.56, 5.40, -99.3},
		},
		checkpoints = {
			{531.53, -158.89, 15.93},
			{476.97, -100.84, 16.69},
			{553.12, -75.61, 12.61},
			{648.97, -85.39, 28.66},
			{591.54, -122.28, 11.27},
			{546.41, -15.02, 11.15},
			{459.88, -89.77, 5.41},
		},
		music_replay = 127,
		music = {
			intro = "MS_WIldstyleLow",
			gameplay = "MS_WIldstyleHigh",
			results = "MS_WIldstyleMid",
		},
	},
	{ -- Gourmet (Moped, by SWEGTA) | BULLWORTH TOWN | 2:00 PM - 8:00 PM
		name = "Gourmet (Moped)",
		id = "town_foodrace",
		description = "I hunger! Let's go grab a bite to eat. (Vehicle: Scooter)",
		warp_pos = {489.47, -67.46, 5.42, 177.3}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {14, 0},
		end_time = {20, 0},
		area = 0,
		weather = 0,
		clock = {17, 00},
		blip = {486.79, -76.26, 5.40, 8}, -- last number is radius to play
		spectator_bounds = {514.06, -410.88, 526.52, -402.45}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {520.31, -406.78, 2.24, 1.4}, -- last number is spawn radius not heading
		max_timer = 480, -- max seconds
		vehicle = 276,
		laps = 1,
		cameras = {
			results = {537.99, -391.97, 3.86, 532.59, -400.01, 6.32},
			time_15 = {511.36, -202.07, 2.83, 503.53, -208.23, 3.62},
			time_10 = {505.18, -205.02, 9.90, 504.12, -195.09, 9.37},
		},
		spawns = {
			{508.74, -205.24, 2.06, 15.0},
			{507.45, -205.45, 2.04, 6.1},
			{506.46, -205.78, 2.01, 6.9},
			{505.51, -206.00, 2.00, 7.6},
			{504.59, -206.18, 1.99, 9.2},
			{503.69, -206.48, 1.98, 7.6},
			{502.78, -206.69, 1.97, 6.7},
			{501.94, -207.02, 1.97, 3.9},
			{501.09, -207.21, 1.96, 2.5},
			{500.07, -207.33, 1.95, -1.6},
		},
		checkpoints = {
			{499.74, -175.49, 3.12},
			{498.22, -140.46, 4.81},
			{522.78, -129.86, 5.57},
			{521.83, -98.47, 4.12},
			{549.22, -80.26, 5.41, sound = "MonkeyEat", bank = "Monkey.bnk"}, -- The Happy Diner
			{559.71, -89.62, 5.26},
			{576.55, -77.70, 5.35},
			{576.33, -39.29, 5.65},
			{566.73, -17.77, 5.90},
			{550.98, -19.11, 5.56, sound = "MonkeyEat", bank = "Monkey.bnk"}, -- Oil Spill
			{547.53, -33.80, 5.42},
			{522.15, -49.06, 5.55},
			{522.01, -68.52, 4.66},
			{513.49, -79.91, 4.46, sound = "SwallowBurp", bank = "DrnkMcn.bnk"}, -- Lounge
			{486.98, -97.94, 5.27, sound = "MonkeyEat", bank = "Monkey.bnk"}, -- Mexican Restaurant
			{471.27, -89.37, 5.47},
			{465.06, -74.82, 5.48},
			{473.14, -62.87, 5.74, sound = "MonkeyEat", bank = "Monkey.bnk"}, -- Sweet Cavity
			{472.67, -46.44, 5.47},
			{513.92, -44.28, 5.36},
			{550.47, -34.52, 5.46},
			{576.51, -25.61, 5.71},
			{571.67, 38.53, 12.07},
			{555.44, 98.26, 12.92},
			{542.04, 153.02, 13.19},
			{539.83, 205.46, 16.61},
			{539.76, 233.13, 16.22},
			{521.35, 249.48, 16.13},
			{448.91, 249.35, 10.02},
			{432.56, 249.64, 9.76},
			{414.56, 260.84, 9.09},
			{413.86, 282.58, 9.01},
			{404.97, 284.04, 9.03, sound = "MonkeyEat", bank = "Monkey.bnk"}, -- Burgers
			{389.62, 287.80, 8.76},
			{371.07, 299.08, 8.38},
			{350.17, 309.93, 8.42, sound = "MonkeyEat", bank = "Monkey.bnk"}, -- Shinjo's
			{330.81, 310.13, 6.32, sound = "MonkeyEat", bank = "Monkey.bnk"}, -- Home Made Ice Cream
			{314.26, 288.69, 6.15},
			{294.89, 227.31, 4.45},
			{296.44, 186.54, 4.47},
			{333.05, 145.34, 4.96},
			{351.35, 151.65, 5.11, sound = "MonkeyEat", bank = "Monkey.bnk"}, -- Yum Yum Market Old Bullworth Vale
			{376.69, 141.82, 4.64},
			{380.71, 184.27, 5.90},
			{392.40, 198.48, 6.42},
			{421.94, 198.14, 8.32},
			{450.23, 195.20, 8.39},
			{435.72, 222.73, 9.96},
			{435.64, 239.48, 9.69},
			{420.75, 249.54, 9.41},
			{390.63, 249.69, 8.31},
			{380.99, 234.09, 7.51},
			{381.21, 207.27, 6.43},
			{380.83, 164.37, 5.22},
			{378.30, 144.05, 4.64},
			{363.87, 139.75, 4.88},
			{345.99, 140.46, 5.17},
			{335.27, 157.54, 5.13},
			{328.20, 179.71, 5.01, sound = "SwallowBurp", bank = "DrnkMcn.bnk"}, -- Old Bullworth Vale Coffee House
			{318.00, 190.39, 4.69, sound = "MonkeyEat", bank = "Monkey.bnk"}, -- Fish Restaurant
			{305.06, 205.91, 4.51},
			{323.36, 242.26, 4.85, sound = "MonkeyEat", bank = "Monkey.bnk"}, -- Crab Restaurant
			{318.75, 250.42, 4.98},
			{329.53, 262.83, 5.86},
			{322.87, 281.30, 6.07},
			{326.66, 298.29, 6.11},
			{372.93, 298.67, 8.39},
			{380.47, 265.80, 8.21},
			{393.64, 249.62, 8.42},
			{466.90, 249.58, 11.19},
			{526.23, 249.45, 16.36},
			{539.51, 240.65, 16.25},
			{539.98, 184.07, 16.10},
			{546.16, 134.22, 12.24},
			{561.87, 74.46, 13.68},
			{574.23, 25.35, 10.34},
			{577.53, -54.23, 5.58},
			{576.15, -81.19, 5.33},
			{556.46, -89.57, 5.19},
			{533.90, -80.83, 4.68, sound = "MonkeyEat", bank = "Monkey.bnk"}, -- Yum Yum Market Bullworth Town
			{522.00, -89.49, 3.74},
			{478.39, -89.65, 5.31},
			{465.06, -99.23, 5.41},
			{470.07, -126.35, 5.43},
			{493.05, -147.71, 4.77},
			{504.30, -204.59, 1.94},
			{499.45, -236.70, 1.99},
			{494.71, -278.46, 2.41, sound = "MonkeyEat", bank = "Monkey.bnk"}, -- Yum Yum Market New Coventry
			{507.12, -282.84, 2.04},
			{508.82, -297.67, 2.34, sound = "MonkeyEat", bank = "Monkey.bnk"}, -- Slab o' Meat
			{530.70, -298.41, 2.35, sound = "SwallowBurp", bank = "DrnkMcn.bnk"}, -- Bar
			{534.94, -285.77, 2.30, sound = "MonkeyEat", bank = "Monkey.bnk"}, -- Hung Lo
			{544.34, -311.56, 2.04},
			{545.69, -343.34, 2.04},
			{540.03, -366.55, 2.34},
			{540.99, -381.04, 2.01, sound = "SwallowBurp", bank = "DrnkMcn.bnk"}, -- Golden Horseshoe
			{528.48, -402.29, 2.48, sound = "SwallowBurp", bank = "DrnkMcn.bnk"}, -- Blue Balls
		},
		music_replay = 115,
		music = {
			intro = "MS_FriendshipAllyMid",
			gameplay = "MS_FriendshipAllyHigh",
			results = "MS_FriendshipAllyLow",
		},
	},
	{ -- Skateboard Challenge (Skateboard, by SWEGTA) | BMX PARK | 2:00 PM - 8:00 PM
		name = "Skateboard Challenge (Skateboard)",
		id = "bmx_skateboardchallenge",
		description = "A hectic race through crazily spread out checkpoints. (Vehicle: Skateboard)",
		warp_pos = {236.37, -432.52, 2.70, -151.6}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {14, 0},
		end_time = {20, 0},
		area = 62,
		weather = 1,
		clock = {15, 00},
		blip = {-722.35, 647.20, 29.11, 8}, -- last number is radius to play
		spectator_bounds = {-781.80, 632.03, -777.65, 642.67}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {-779.79, 638.30, 29.51, 2}, -- last number is spawn radius not heading
		max_timer = 180, -- max seconds
		vehicle = -1,
		weapon = 437,
		laps = 1,
		cameras = {
			results = {-722.65, 646.84, 29.08, -716.99, 647.44, 37.30},
			time_15 = {-761.52, 659.68, 36.79, -757.24, 650.83, 34.94},
			time_10 = {-751.80, 656.03, 29.93, -761.01, 659.92, 29.77},
		},
		spawns = {
			{-753.96, 657.74, 29.73, -178.4},
			{-755.04, 657.68, 29.73, -179.3},
			{-756.26, 657.58, 29.73, -174.7},
			{-757.46, 657.59, 29.73, -176.3},
			{-758.55, 657.58, 29.73, -179.9},
			{-759.54, 657.56, 29.73, -179.6},
			{-760.60, 657.48, 29.73, -176.4},
			{-761.69, 657.46, 29.73, -176.9},
			{-762.86, 657.46, 29.73, -176.7},
			{-763.99, 657.34, 29.73, -173.4},
		},
		checkpoints = {
			{-745.02, 618.75, 29.11},
			{-732.47, 618.58, 31.49},
			{-725.23, 634.10, 31.98},
			{-748.03, 652.62, 30.53},
			{-774.27, 639.14, 29.76},
			{-753.33, 616.34, 30.09},
			{-738.23, 618.38, 31.69},
			{-727.57, 620.66, 31.49},
			{-725.16, 634.24, 31.98},
			{-747.80, 657.59, 31.61},
			{-773.85, 658.17, 30.64},
			{-771.08, 643.02, 29.77},
			{-753.69, 619.61, 29.72},
			{-737.80, 625.42, 29.11},
			{-722.47, 657.69, 31.01},
			{-747.98, 637.07, 30.93},
			{-775.69, 615.80, 31.68},
			{-748.95, 636.82, 30.93},
			{-722.37, 657.76, 31.17},
			{-736.27, 636.96, 29.11},
			{-745.77, 627.59, 29.11},
			{-759.55, 631.89, 29.11},
			{-753.60, 644.85, 29.11},
			{-733.48, 646.91, 29.11},
			{-724.88, 633.68, 31.85},
			{-725.90, 623.06, 31.49},
			{-738.04, 618.25, 31.68},
			{-753.01, 616.33, 30.00},
			{-775.67, 615.83, 31.66},
			{-753.40, 616.56, 30.06},
			{-738.03, 618.15, 31.68},
			{-728.47, 620.21, 31.49},
			{-725.07, 634.15, 31.98},
		},
		music_replay = 167,
		music = {
			intro = "MS_Misbehaving_NISPrankInfo",
			gameplay = "MS_Ambient01",
			results = "MS_Misbehaving_NISPrankSucess",
		},
	},
	{ -- Electric Skateboard Challenge (Electric Skateboard, by SWEGTA) | BMX PARK | 8:00 PM - 2:00 AM
		name = "Electric Skateboard Challenge (Electric Skateboard)",
		id = "bmx_electricskateboardchallenge",
		description = "A hectic race through crazily spread out checkpoints. (Vehicle: Electric Skateboard)",
		warp_pos = {236.37, -432.52, 2.70, -151.6}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {20, 0},
		end_time = {2, 0},
		area = 62,
		weather = 1,
		clock = {22, 00},
		blip = {-722.35, 647.20, 29.11, 8}, -- last number is radius to play
		spectator_bounds = {-781.80, 632.03, -777.65, 642.67}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {-779.79, 638.30, 29.51, 2}, -- last number is spawn radius not heading
		max_timer = 180, -- max seconds
		vehicle = "skateboard_electric",
		laps = 1,
		cameras = {
			results = {-722.65, 646.84, 29.08, -716.99, 647.44, 37.30},
			time_15 = {-761.52, 659.68, 36.79, -757.24, 650.83, 34.94},
			time_10 = {-751.80, 656.03, 29.93, -761.01, 659.92, 29.77},
		},
		spawns = {
			{-753.96, 657.74, 29.73, -178.4},
			{-755.04, 657.68, 29.73, -179.3},
			{-756.26, 657.58, 29.73, -174.7},
			{-757.46, 657.59, 29.73, -176.3},
			{-758.55, 657.58, 29.73, -179.9},
			{-759.54, 657.56, 29.73, -179.6},
			{-760.60, 657.48, 29.73, -176.4},
			{-761.69, 657.46, 29.73, -176.9},
			{-762.86, 657.46, 29.73, -176.7},
			{-763.99, 657.34, 29.73, -173.4},
		},
		checkpoints = {
			{-748.49, 636.84, 30.93},
			{-727.39, 620.42, 31.49},
			{-748.03, 659.76, 31.61},
			{-748.92, 636.91, 30.93},
			{-773.58, 658.91, 31.21},
			{-727.31, 621.00, 31.49},
			{-748.02, 636.92, 30.93},
			{-775.67, 614.92, 31.66},
			{-748.07, 654.97, 30.52},
			{-722.41, 657.81, 31.19},
			{-726.15, 622.31, 31.49},
			{-732.53, 626.02, 29.11},
			{-748.22, 636.29, 30.93},
			{-775.35, 639.20, 29.77},
			{-753.21, 614.90, 30.09},
			{-748.74, 636.68, 30.93},
			{-740.43, 629.95, 29.11},
			{-754.01, 642.74, 29.11},
			{-742.08, 642.49, 29.11},
			{-754.83, 631.90, 29.11},
			{-747.85, 644.64, 29.11},
			{-748.47, 629.02, 29.11},
			{-756.98, 637.06, 29.11},
			{-740.78, 637.53, 29.11},
			{-725.81, 623.40, 31.49},
			{-748.52, 636.71, 30.93},
			{-775.67, 614.92, 31.66},
			{-773.61, 658.87, 31.20},
			{-722.32, 657.69, 31.20},
			{-775.67, 623.48, 30.39},
			{-748.04, 659.76, 31.61},
			{-731.62, 626.39, 29.11},
			{-775.57, 639.28, 29.75},
			{-725.88, 622.90, 31.49},
			{-732.78, 627.08, 29.11},
			{-725.88, 622.90, 31.49},
			{-732.78, 627.08, 29.11},
			{-725.88, 622.90, 31.49},
			{-732.78, 627.08, 29.11},
			{-775.69, 623.57, 30.39},
		},
		music_replay = 160,
		music = {
			intro = "MS_Misbehaving_NISPrankInfo",
			gameplay = "MS_BikeNight",
			results = "MS_Misbehaving_NISPrankSucess",
		},
	},
	{ -- Motorcycle Challenge (Motorcycle, by SWEGTA) | BMX PARK | 2:00 AM - 8:00 AM
		name = "Motorcycle Challenge (Motorcycle)",
		id = "bmx_motorcyclechallenge",
		description = "A hectic race through crazily spread out checkpoints. (Vehicle: Motorcycle)",
		warp_pos = {236.37, -432.52, 2.70, -151.6}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {2, 0},
		end_time = {8, 0},
		area = 62,
		weather = 1,
		clock = {5, 00},
		blip = {-722.35, 647.20, 29.11, 8}, -- last number is radius to play
		spectator_bounds = {-781.80, 632.03, -777.65, 642.67}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {-779.79, 638.30, 29.51, 2}, -- last number is spawn radius not heading
		max_timer = 300, -- max seconds
		vehicle = 275,
		laps = 1,
		cameras = {
			results = {-722.65, 646.84, 29.08, -716.99, 647.44, 37.30},
			time_15 = {-761.52, 659.68, 36.79, -757.24, 650.83, 34.94},
			time_10 = {-751.80, 656.03, 29.93, -761.01, 659.92, 29.77},
		},
		spawns = {
			{-753.96, 657.74, 29.73, -178.4},
			{-755.04, 657.68, 29.73, -179.3},
			{-756.26, 657.58, 29.73, -174.7},
			{-757.46, 657.59, 29.73, -176.3},
			{-758.55, 657.58, 29.73, -179.9},
			{-759.54, 657.56, 29.73, -179.6},
			{-760.60, 657.48, 29.73, -176.4},
			{-761.69, 657.46, 29.73, -176.9},
			{-762.86, 657.46, 29.73, -176.7},
			{-763.99, 657.34, 29.73, -173.4},
		},
		checkpoints = {
			{-775.67, 623.45, 30.39},
			{-734.55, 624.79, 29.11},
			{-748.67, 637.34, 30.93},
			{-727.44, 620.74, 31.49},
			{-748.04, 659.75, 31.61},
			{-750.10, 629.30, 29.11},
			{-739.40, 636.60, 29.11},
			{-748.05, 645.00, 29.11},
			{-757.76, 635.94, 29.11},
			{-749.55, 628.47, 29.11},
			{-739.52, 636.03, 29.11},
			{-747.27, 645.10, 29.11},
			{-757.58, 637.95, 29.11},
			{-749.66, 628.33, 29.11},
			{-739.06, 637.13, 29.11},
			{-748.78, 645.43, 29.11},
			{-757.54, 637.26, 29.11},
			{-749.08, 628.42, 29.11},
			{-739.23, 636.63, 29.11},
			{-748.27, 645.32, 29.11},
			{-757.72, 637.72, 29.11},
			{-749.41, 628.44, 29.11},
			{-739.42, 636.36, 29.11},
			{-747.81, 645.21, 29.11},
			{-775.41, 639.12, 29.76},
			{-753.27, 614.90, 30.09},
			{-748.32, 636.47, 30.93},
			{-748.16, 654.96, 30.52},
			{-725.94, 622.66, 31.49},
			{-775.67, 614.92, 31.66},
			{-722.36, 657.75, 31.19},
			{-773.59, 658.88, 31.18},
			{-748.49, 637.23, 30.93},
			{-726.66, 621.43, 31.49},
			{-748.09, 659.75, 31.61},
			{-753.27, 614.92, 30.09},
			{-771.16, 643.09, 29.75},
			{-773.60, 658.89, 31.20},
			{-750.33, 647.31, 29.11},
			{-733.15, 629.33, 29.11},
			{-753.39, 618.83, 29.75},
			{-772.25, 643.20, 29.70},
			{-745.76, 647.43, 29.11},
			{-735.82, 631.09, 29.11},
			{-762.50, 626.15, 29.11},
			{-748.09, 659.77, 31.61},
			{-726.02, 622.23, 31.49},
			{-748.50, 635.99, 30.93},
			{-748.02, 659.76, 31.61},
			{-725.60, 622.06, 31.49},
			{-747.82, 636.29, 30.93},
			{-725.40, 622.71, 31.49},
			{-775.67, 614.92, 31.66},
			{-773.66, 658.83, 31.21},
			{-722.32, 657.69, 31.16},
			{-725.39, 622.03, 31.50},
			{-748.91, 636.15, 30.93},
			{-748.01, 659.77, 31.61},
			{-725.67, 622.03, 31.49},
			{-775.68, 623.43, 30.39},
			{-748.08, 654.97, 30.52},
			{-725.11, 622.21, 31.50},
			{-748.08, 636.25, 30.93},
			{-725.17, 622.26, 31.50},
			{-775.69, 623.42, 30.39},
			{-748.91, 637.04, 30.93},
			{-726.43, 621.54, 31.49},
			{-773.58, 658.91, 31.20},
			{-722.31, 657.69, 31.19},
			{-731.62, 626.35, 29.11},
			{-775.60, 614.92, 31.59},
			{-748.95, 636.90, 30.93},
			{-725.15, 622.79, 31.49},
			{-773.60, 658.86, 31.17},
			{-749.07, 637.42, 30.93},
			{-775.67, 623.42, 30.39},
		},
		music_replay = 0,
		music = {
			intro = "MS_ActionMid",
			gameplay = "MS_ActionHigh_NISReturn",
			results = "MS_ActionLow",
		},
	},
	{ -- Boozehound (Truck, by SWEGTA) | BLUE SKIES | 2:00 AM - 8:00 AM
		name = "Boozehound (Truck)",
		id = "blue_skies_booze",
		description = "The fine people of New Coventry need their liquor delivered to them from Spencer Shipping. (Vehicle: Truck)",
		warp_pos = {236.37, -432.52, 2.70, -151.6}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {2, 0},
		end_time = {8, 0},
		area = 0,
		weather = 3,
		clock = {3, 00},
		blip = {239.94, -438.85, 2.66, 8}, -- last number is radius to play
		spectator_bounds = {79.42, -418.48, 101.96, -384.29}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {96.46, -395.88, 1.86, 2}, -- last number is spawn radius not heading
		max_timer = 300, -- max seconds
		vehicle = "truck_booze",
		laps = 1,
		shuffle = 14, -- randomize all checkpoints except the last one
		cameras = {
			results = {141.59, -359.42, 15.56, 134.35, -366.16, 14.09},
			time_15 = {95.75, -385.87, 3.08, 90.11, -394.13, 2.97},
			time_10 = {92.38, -393.58, 3.35, 102.37, -393.17, 3.70},
		},
		spawns = {
			{95.10, -400.92, 2.83, -77.5},
			{94.26, -397.91, 2.86, -78.4},
			{93.55, -395.15, 2.88, -78.3},
			{92.95, -392.07, 2.90, -78.9},
			{92.48, -389.24, 2.90, -80.7},
			{89.94, -402.04, 2.70, -76.9},
			{89.37, -398.93, 2.73, -77.2},
			{88.74, -396.10, 2.76, -77.6},
			{88.08, -393.10, 2.79, -77.9},
			{87.54, -390.26, 2.79, -77.9},
		},
		checkpoints = {
			-- {251.59, -355.31, 2.65}, -- BLUE SKIES. Scrapped for now.
			-- {304.95, -334.78, 2.69},
			-- {316.57, -380.64, 2.67},
			-- {282.96, -419.19, 2.64},
			-- {272.49, -460.93, 3.82},
			-- {254.11, -434.29, 2.67},
			
			{410.48, -430.80, 2.88, sound = "BuyItem", bank = "Hud.bnk"},
			{477.97, -437.06, 2.68, sound = "BuyItem", bank = "Hud.bnk"},
			{497.81, -462.22, 3.37, sound = "BuyItem", bank = "Hud.bnk"},
			{493.54, -447.10, 3.05, sound = "BuyItem", bank = "Hud.bnk"},
			{504.87, -434.66, 4.09, sound = "BuyItem", bank = "Hud.bnk"},
			{499.50, -411.48, 2.27, sound = "BuyItem", bank = "Hud.bnk"},
			{529.19, -452.26, 4.44, sound = "BuyItem", bank = "Hud.bnk"},
			{561.39, -440.56, 4.46, sound = "BuyItem", bank = "Hud.bnk"},
			{572.30, -486.73, 4.46, sound = "BuyItem", bank = "Hud.bnk"},
			{528.46, -400.66, 2.39, sound = "BuyItem", bank = "Hud.bnk"},
			{518.80, -391.57, 2.28, sound = "BuyItem", bank = "Hud.bnk"},
			{541.70, -366.55, 2.25, sound = "BuyItem", bank = "Hud.bnk"},
			{530.88, -297.77, 2.32, sound = "BuyItem", bank = "Hud.bnk"},
			{511.95, -274.81, 2.33, sound = "BuyItem", bank = "Hud.bnk"},
			{506.11, -241.51, 2.30, sound = "BuyItem", bank = "Hud.bnk"},
			{480.95, -300.52, 2.52, sound = "BuyItem", bank = "Hud.bnk"},
			{432.56, -455.81, 2.61, sound = "BuyItem", bank = "Hud.bnk"},
			{463.65, -433.22, 2.57, sound = "BuyItem", bank = "Hud.bnk"},
			{112.07, -394.33, 2.35, sound = "BuyItem", bank = "Hud.bnk"},
		},
		music_replay = 195,
		music = {
			intro = "MS_Confrontation_NIS",
			gameplay = "MS_DestructionVandalismHigh",
			results = "MS_DestructionVandalismMid",
		},
	},
	{ -- N.I.M.B.Y. (On Foot, by SWEGTA) | BLUE SKIES | 2:00 AM - 8:00 AM
		name = "N.I.M.B.Y. (On Foot)",
		id = "blue_skies_nimbyrace",
		description = "Through the Blue Skies backyards and the chemplant, all the way to the top! (On Foot)",
		warp_pos = {236.37, -432.52, 2.70, -151.6}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {20, 0},
		end_time = {2, 0},
		area = 0,
		weather = 3,
		clock = {1, 00},
		blip = {239.94, -438.85, 2.66, 8}, -- last number is radius to play
		spectator_bounds = {22.71, -571.93, 40.01, -555.01}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {34.17, -564.02, 32.66, 2}, -- last number is spawn radius not heading
		max_timer = 300, -- max seconds
		vehicle = -1,
		laps = 1,
		cameras = {
			results = {62.36, -586.12, 39.88, 55.82, -578.98, 37.36},
			time_15 = {235.53, -428.44, 11.66, 244.73, -431.92, 9.84},
			time_10 = {263.05, -456.17, 6.09, 256.51, -448.80, 4.42},
		},
		spawns = {
			{258.18, -445.33, 3.44, -169.4},
			{257.24, -445.58, 3.36, -169.4},
			{256.42, -445.81, 3.29, -167.0},
			{255.72, -446.03, 3.23, -166.4},
			{254.95, -446.29, 3.16, -164.8},
			{254.13, -446.60, 3.09, -161.1},
			{253.39, -446.92, 3.03, -157.8},
			{252.81, -447.22, 2.97, -155.8},
			{252.03, -447.69, 2.91, -150.5},
			{251.34, -448.16, 2.84, -148.6},
		},
		checkpoints = {
			{262.52, -466.00, 3.66},
			{271.94, -472.58, 3.99},
			{299.01, -467.03, 4.52},
			{306.73, -458.55, 3.93},
			{301.92, -450.55, 3.55},
			{301.33, -441.88, 2.93},
			{312.91, -424.75, 2.80},
			{317.56, -404.87, 2.87},
			{332.29, -381.95, 2.67},
			{338.88, -367.93, 2.68},
			{333.97, -344.86, 3.38},
			{324.38, -345.35, 3.31},
			{315.27, -331.15, 2.84},
			{312.65, -320.67, 2.68},
			{298.99, -320.97, 2.68},
			{278.51, -331.03, 2.68},
			{264.56, -335.71, 2.86},
			{259.61, -347.82, 2.67},
			{258.69, -353.80, 2.67},
			{238.47, -370.21, 2.63},
			{206.65, -391.52, 4.42},
			{207.51, -398.11, 2.87},
			{196.86, -420.09, 4.40},
			{164.76, -421.16, 2.56},
			{149.78, -428.36, 2.53},
			{148.00, -442.66, 2.52},
			{150.86, -480.98, 2.28},
			{122.94, -498.27, 2.45},
			{97.88, -491.92, 2.77},
			{82.11, -504.74, 4.90},
			{74.61, -506.60, 5.32},
			{64.04, -495.87, 5.36},
			{67.38, -485.13, 5.37},
			{52.07, -459.36, 4.74},
			{54.52, -447.51, 2.40},
			{22.85, -415.98, 0.15},
			{5.77, -400.48, 0.45},
			{7.95, -391.98, 0.42},
			{-10.44, -418.40, 0.36},
			{-20.40, -443.57, 1.07},
			{-17.60, -470.22, 1.50},
			{5.52, -477.44, 1.81},
			{23.25, -461.47, 4.35},
			{36.99, -470.13, 5.35},
			{46.12, -498.51, 5.35},
			{38.79, -509.54, 4.35},
			{17.32, -489.66, 4.35},
			{14.12, -503.45, 1.90},
			{50.24, -529.98, 2.09},
			{69.83, -536.68, 4.36},
			{88.06, -524.62, 3.38},
			{64.38, -548.80, 2.97},
			{54.21, -551.59, 2.85},
			{39.55, -551.99, 8.08},
			{26.45, -559.29, 13.00},
			{18.78, -571.99, 17.76},
			{18.14, -584.89, 22.33},
			{25.30, -598.86, 27.78},
			{38.84, -605.94, 32.27},
			{52.34, -584.98, 32.37},
			{43.85, -565.19, 32.57},
		},
		music_replay = 233,
		music = {
			intro = "MS_BikeFunMid",
			gameplay = "MS_BikeFunHigh",
			results = "MS_BikeFun_NIS",
		},
	},
	{ -- New Coventry Circuit (Bike, by SWEGTA) | NEW COVENTRY | 2:00 PM - 8:00 PM
		name = "New Coventry Circuit (Bike)",
		id = "coventry_bikecircuit",
		description = "A wheel ain't a wheel without all its spokes. (Vehicle: Racer BMX)",
		warp_pos = {478.82, -311.32, 2.82, 88.2}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {14, 0},
		end_time = {20, 0},
		area = 0,
		weather = 4,
		clock = {18, 30},
		blip = {471.21, -312.13, 2.89, 8}, -- last number is radius to play
		spectator_bounds = {471.03, -293.88, 485.86, -277.35}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {477.43, -284.43, 2.77, 2}, -- last number is spawn radius not heading
		max_timer = 180, -- max seconds
		vehicle = 282,
		laps = 3,
		cameras = {
			results = {472.23, -313.55, 3.22, 466.15, -306.32, 6.51},
			time_15 = {481.33, -289.32, 4.32, 478.90, -299.01, 4.87},
			time_10 = {476.83, -315.67, 5.33, 477.80, -305.76, 4.43},
		},
		spawns = {
			{479.38, -305.90, 3.18, 1.6},
			{478.44, -305.90, 3.24, 1.7},
			{477.51, -305.90, 3.30, -2.0},
			{476.56, -305.90, 3.36, -4.0},
			{475.51, -305.90, 3.43, -0.7},
			{479.38, -308.33, 3.18, 1.6},
			{478.44, -308.33, 3.24, 1.7},
			{477.51, -308.33, 3.30, -2.0},
			{476.56, -308.33, 3.36, -4.0},
			{475.51, -308.33, 3.43, -0.7},
		},
		checkpoints = {
			{476.66, -295.15, 2.74},
			{478.09, -279.74, 2.72},
			{488.80, -269.34, 2.60},
			{504.40, -272.00, 2.06},
			{515.71, -298.72, 2.39},
			{519.89, -322.62, 2.12},
			{518.29, -363.62, 2.74},
			{491.08, -373.40, 2.65},
			{473.32, -381.45, 3.61},
			{462.31, -416.12, 2.52},
			{446.32, -475.62, 3.09},
			{489.68, -502.98, 5.28},
			{515.72, -509.84, 5.99},
			{537.12, -492.85, 5.70},
			{547.13, -454.73, 4.45},
			{529.76, -434.17, 4.47},
			{531.57, -420.39, 3.87},
			{541.50, -415.15, 2.86},
			{540.02, -401.95, 2.80},
			{514.95, -396.44, 2.01},
			{499.27, -389.99, 2.56},
			{494.91, -362.13, 2.78},
			{493.93, -335.92, 2.82},
			{476.78, -303.22, 2.74},
		},
		music_replay = 170,
		music = {
			intro = "MS_FightingJohnnyVincentBikeRide",
			gameplay = "MS_FightingJohnnyVincentFight",
			results = "MS_3B_JohhnyV_NIS",
		},
	},
	{ -- New Coventry Tour (Electric Scooter, by SWEGTA) | NEW COVENTRY | 8:00 AM - 2:00 PM
		name = "New Coventry Tour (Electric Scooter)",
		id = "coventry_electricscootertour",
		description = "Take a proper gander at the local scenery of New Coventry. (Vehicle: Electric Scooter)",
		warp_pos = {478.82, -311.32, 2.82, 88.2}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {8, 0},
		end_time = {14, 0},
		area = 0,
		weather = 0,
		clock = {12, 15},
		blip = {471.21, -312.13, 2.89, 8}, -- last number is radius to play
		spectator_bounds = {494.73, -431.72, 502.73, -429.60}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {498.39, -430.98, 3.28, 0.7}, -- last number is spawn radius not heading
		max_timer = 180, -- max seconds
		vehicle = "electric_scooter",
		laps = 1,
		cameras = {
			results = {467.21, -427.21, 10.15, 476.08, -425.59, 5.82},
			time_15 = {486.61, -424.17, 2.34, 489.58, -414.70, 3.54},
			time_10 = {490.18, -406.25, 3.03, 498.73, -401.22, 4.28},
		},
		spawns = {
			{491.13, -421.57, 2.00, -16.2},
			{489.59, -421.27, 2.01, -16.1},
			{488.19, -420.92, 2.02, -16.9},
			{486.88, -420.53, 2.02, -17.4},
			{485.35, -420.10, 2.03, -17.4},
			{490.57, -423.64, 2.00, -15.5},
			{489.06, -423.23, 2.01, -15.8},
			{487.65, -422.88, 2.02, -16.0},
			{486.34, -422.52, 2.02, -15.5},
			{484.74, -422.12, 2.03, -16.6},
		},
		checkpoints = {
			{500.94, -397.02, 2.20},
			{524.66, -392.05, 2.25},
			{526.80, -383.18, 2.36},
			{544.53, -370.62, 2.02},
			{545.32, -338.83, 2.04},
			{538.50, -323.41, 2.41},
			{524.21, -322.06, 3.38},
			{516.29, -312.37, 1.95},
			{515.60, -300.41, 2.42},
			{527.62, -287.13, 2.26},
			{527.42, -274.66, 2.31},
			{514.01, -270.41, 2.38},
			{480.25, -259.80, 2.70},
			{472.74, -240.91, 2.24},
			{462.36, -240.22, 2.00},
			{461.36, -285.06, 2.00},
			{470.90, -296.56, 2.90},
			{487.48, -319.87, 2.88},
			{494.11, -346.69, 2.82},
			{496.40, -383.02, 2.66},
			{490.49, -412.47, 2.01},
			{483.96, -436.85, 2.46},
			{489.04, -452.30, 2.64},
			{508.40, -458.44, 3.70},
			{522.72, -451.85, 4.26},
			{536.13, -441.93, 4.35},
			{562.65, -448.39, 4.34},
			{569.68, -464.99, 4.34},
			{566.00, -478.77, 4.34},
			{548.91, -486.21, 4.36},
			{527.22, -480.44, 4.35},
			{513.73, -460.75, 4.10},
			{473.42, -444.68, 2.93},
			{462.50, -441.34, 2.65},
			{459.28, -417.69, 2.55},
			{438.17, -410.30, 2.47},
			{422.29, -422.12, 2.57},
			{417.91, -433.08, 2.65},
			{437.54, -443.65, 2.63},
			{448.44, -452.96, 2.74},
			{444.82, -485.18, 3.23},
			{490.44, -503.37, 5.46},
			{528.69, -509.74, 6.21},
			{537.02, -493.46, 5.52},
			{548.22, -451.82, 4.46},
			{527.79, -432.70, 4.46},
			{531.68, -420.19, 3.88},
			{541.58, -415.53, 2.87},
			{565.37, -387.06, 2.50},
			{568.91, -370.90, 2.28},
			{553.74, -357.54, 4.08},
			{540.03, -356.67, 2.35},
			{519.00, -355.81, 2.66},
			{517.10, -368.81, 2.91},
			{505.37, -373.67, 4.23},
			{486.13, -374.40, 3.11},
			{475.98, -376.43, 2.84},
			{464.25, -410.09, 2.43},
			{481.10, -422.00, 2.01},
		},
		music_replay = 75,
		music = {
			intro = "MS_Misbehaving_NISPrankInfo",
			gameplay = "MS_GoKarts01B",
			results = "MS_Misbehaving_NISPrankInfo",
		},
	},
	{ -- Feelin' Freaky (Gokart, by SWEGTA) | NEW COVENTRY | 2:00 AM - 8:00 AM
		name = "Feelin' Freaky (Gokart)",
		id = "coventry_carnivalgokart",
		description = "A gokart trip from New Coventry, all the way to Billy Crane's Traveling Carnival. (Vehicle: Gokart)",
		warp_pos = {478.82, -311.32, 2.82, 88.2}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {2, 0},
		end_time = {8, 0},
		area = 0,
		weather = 3,
		clock = {3, 0},
		blip = {471.21, -312.13, 2.89, 8}, -- last number is radius to play
		spectator_bounds = {211.35, 411.40, 230.17, 418.56}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {220.43, 416.90, 4.37, 0.7}, -- last number is spawn radius not heading
		max_timer = 180, -- max seconds
		vehicle = 289,
		laps = 1,
		cameras = {
			results = {205.56, 451.61, 5.90, 202.33, 459.27, 11.46},
			time_15 = {567.89, -444.38, 4.85, 572.23, -453.24, 6.50},
			time_10 = {577.08, -452.08, 7.98, 567.71, -448.82, 6.79},
		},
		spawns = {
			{569.02, -446.08, 5.06, 72.1},
			{568.35, -447.99, 4.92, 74.7},
			{567.99, -449.29, 4.92, 72.4},
			{567.58, -450.67, 4.92, 72.0},
			{567.15, -452.10, 4.92, 71.4},
			{571.07, -446.75, 5.06, 72.1},
			{570.45, -448.56, 4.92, 75.2},
			{570.06, -449.97, 4.93, 72.6},
			{569.63, -451.39, 4.92, 71.4},
			{569.23, -452.83, 4.92, 71.9},
		},
		checkpoints = {
			{552.77, -445.63, 4.36},
			{527.49, -433.10, 4.46},
			{530.87, -420.94, 3.88},
			{541.47, -415.52, 2.89},
			{545.20, -372.85, 2.01},
			{544.52, -315.68, 2.04},
			{528.67, -286.24, 2.29},
			{523.22, -270.89, 2.31},
			{511.70, -270.21, 2.37},
			{499.70, -250.36, 2.01},
			{501.76, -216.98, 2.01},
			{498.39, -168.91, 3.72},
			{492.80, -146.20, 4.89},
			{476.02, -131.86, 5.18},
			{467.81, -121.01, 5.43},
			{464.35, -89.49, 5.46},
			{474.18, -68.84, 5.59},
			{502.60, -65.21, 7.09},
			{536.64, -68.13, 5.38},
			{549.32, -56.19, 5.43},
			{549.26, -44.36, 5.54},
			{562.55, -24.43, 5.58},
			{575.68, -7.95, 6.77},
			{586.45, 28.87, 11.27},
			{607.35, 46.29, 13.87},
			{647.47, 82.98, 8.57},
			{640.57, 124.21, 12.76},
			{616.79, 127.80, 13.05},
			{560.14, 105.55, 7.81},
			{532.07, 109.25, 7.71},
			{513.55, 151.96, 12.64},
			{496.87, 163.44, 9.77},
			{478.47, 159.11, 9.43},
			{468.03, 129.35, 8.53},
			{478.10, 82.07, 3.82},
			{458.02, 75.45, 4.87},
			{395.94, 114.73, 5.30},
			{373.79, 118.98, 6.85},
			{352.00, 119.38, 5.32},
			{321.62, 130.55, 5.11},
			{297.19, 149.36, 2.86},
			{268.52, 194.32, 2.01},
			{250.73, 239.84, 0.32},
			{265.33, 268.83, 0.81},
			{300.76, 287.12, 6.27},
			{313.74, 298.22, 6.03},
			{303.49, 339.85, 3.77},
			{280.44, 368.88, 3.58},
			{227.36, 411.44, 4.64},
		},
		music_replay = 162,
		music = {
			intro = "MS_CarnivalFunhouseMiner",
			gameplay = "MS_BikeFastHigh",
			results = "MS_Carnival01",
		},
	},
	{ -- Urban Exploration (On Foot, by SWEGTA) | NEW COVENTRY | 2:00 AM - 8:00 AM
		name = "Urban Exploration (On Foot)",
		id = "coventry_footrace",
		description = "Searching high and low, we explore the derelict and lesser known areas of New Coventry. (On Foot)",
		warp_pos = {478.82, -311.32, 2.82, 88.2}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {2, 0},
		end_time = {8, 0},
		area = 0,
		weather = 2,
		clock = {2, 15},
		blip = {471.17, -309.76, 2.89, 8}, -- last number is radius to play
		spectator_bounds = {522.35, -317.26, 531.05, -307.33}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {525.97, -311.62, 2.71, 0.7}, -- last number is spawn radius not heading
		max_timer = 360, -- max seconds
		vehicle = -1,
		health = 200,
		laps = 1,
		cameras = {
			results = {517.94, -366.23, 3.65, 518.37, -356.31, 4.85},
			time_15 = {538.41, -292.29, 26.25, 533.73, -300.57, 23.17},
			time_10 = {521.01, -331.47, 8.47, 524.11, -322.30, 5.93},
		},
		spawns = {
			{530.78, -308.60, 2.89, 160.8},
			{529.48, -308.37, 2.79, 168.2},
			{528.32, -308.25, 2.70, 170.3},
			{527.27, -308.23, 2.62, -184.7},
			{526.00, -308.29, 2.62, -180.7},
			{524.84, -308.40, 2.72, -177.3},
			{523.62, -308.64, 2.82, -171.3},
			{522.59, -308.93, 2.91, -167.8},
			{521.64, -309.25, 2.99, -166.0},
			{520.68, -309.66, 3.00, -163.8},
		},
		checkpoints = {
			{528.82, -320.49, 2.98},
			{540.76, -326.19, 2.27},
			{529.34, -336.04, 3.30},
			{538.81, -328.77, 2.39},
			{545.85, -353.00, 2.03},
			{552.14, -376.66, 2.33},
			{561.89, -376.68, 2.27},
			{551.84, -376.76, 2.33},
			{523.40, -370.72, 2.36},
			{517.57, -364.92, 2.84},
			{521.72, -332.03, 3.02},
			{514.79, -321.28, 3.45},
			{492.61, -319.51, 2.69},
			{476.97, -302.04, 2.72},
			{475.70, -261.06, 2.47},
			{471.90, -241.12, 2.19},
			{464.49, -239.49, 2.00},
			{464.75, -312.58, 2.00},
			{464.72, -316.76, 7.39},
			{466.03, -339.10, 12.18},
			{479.30, -343.49, 17.46},
			{481.84, -363.78, 9.24},
			{473.98, -385.74, 4.22},
			{472.85, -408.36, 8.87},
			{456.70, -437.82, 2.62},
			{436.66, -448.56, 2.46},
			{428.96, -459.78, 3.00},
			{436.56, -448.25, 2.47},
			{461.63, -441.63, 2.65},
			{483.72, -440.03, 2.57},
			{496.48, -392.70, 2.67},
			{504.28, -374.85, 2.73},
			{516.65, -369.28, 2.85},
			{519.08, -338.53, 2.50},
			{525.74, -320.12, 2.99},
		},
		music_replay = 124,
		music = {
			intro = "MS_FootStealthMid",
			gameplay = "MS_FootStealthHigh",
			results = "MS_FootStealthLow",
		},
	},
	{ -- Fountain of Knowledge (Bike, by SWEGTA) | NEW COVENTRY | 2:00 PM - 8:00 PM
		name = "Fountain of Knowledge (Bike)",
		id = "coventry_fountainrace",
		description = "Through the wilderness and train tracks, past the academy fountain, and back. (Vehicle: Shop Class 5 BMX)",
		warp_pos = {478.82, -311.32, 2.82, 88.2}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {14, 0},
		end_time = {20, 0},
		area = 0,
		weather = 1,
		clock = {16, 45},
		blip = {471.17, -309.76, 2.89, 8}, -- last number is radius to play
		spectator_bounds = {492.48, -270.88, 509.52, -249.77}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {499.89, -258.10, 2.06, 1.2}, -- last number is spawn radius not heading
		max_timer = 240, -- max seconds
		vehicle = 277,
		laps = 1,
		cameras = {
			results = {487.41, -251.27, 12.16, 495.15, -248.02, 6.72},
			time_15 = {503.73, -245.07, 2.96, 498.46, -253.56, 2.88},
			time_10 = {501.85, -261.41, 6.80, 501.47, -251.53, 5.29},
		},
		spawns = {
			{502.52, -248.95, 2.53, 7.0},
			{501.55, -248.89, 2.53, 0.4},
			{500.28, -248.88, 2.52, 4.1},
			{499.27, -248.93, 2.51, 5.8},
			{498.19, -248.98, 2.50, 1.6},
			{502.52, -251.01, 2.55, 2.8},
			{501.38, -250.99, 2.55, 0.6},
			{500.45, -251.30, 2.55, 4.1},
			{499.35, -251.32, 2.55, 7.6},
			{498.27, -251.42, 2.54, 1.6},
		},
		checkpoints = {
			{498.42, -230.72, 2.01},
			{504.02, -200.63, 2.01},
			{491.61, -167.54, 3.58},
			{465.80, -167.75, 3.06},
			{436.77, -175.70, 3.50},
			{427.39, -184.15, 3.43},
			{427.42, -235.49, 3.46},
			{436.83, -247.27, 4.47},
			{454.82, -234.59, 7.03},
			{474.80, -227.03, 7.14},
			{463.73, -223.40, 7.28},
			{401.83, -259.64, 9.11},
			{334.10, -296.97, 8.95},
			{296.33, -311.00, 8.30},
			{206.84, -329.90, 8.05},
			{121.07, -343.40, 8.04},
			{63.11, -345.76, 8.04},
			{25.97, -316.80, 7.52},
			{0.00, -280.01, 6.29},
			{-16.90, -244.60, 5.37},
			{-9.56, -225.98, 2.29},
			{-8.69, -212.26, 1.00},
			{-21.29, -195.08, 1.00},
			{-24.66, -176.18, 1.00},
			{-14.99, -164.74, 1.00},
			{-6.48, -140.83, 2.03},
			{7.50, -134.14, 2.64},
			{7.67, -114.77, 3.02},
			{-2.53, -111.36, 1.28},
			{-45.05, -107.19, 1.00},
			{-45.13, -40.66, 1.00},
			{-12.70, -39.93, 1.00},
			{-9.71, -73.09, 1.00},
			{12.62, -73.04, 4.96},
			{57.25, -73.36, 5.07},
			{88.09, -72.92, 5.73},
			{119.46, -73.20, 5.92},
			{145.53, -53.57, 6.25},
			{167.33, -35.13, 6.16},
			{183.17, -32.08, 5.93},
			{186.52, -18.32, 6.11},
			{226.04, 6.18, 5.91},
			{298.17, 5.58, 4.41},
			{320.28, 0.08, 4.40},
			{329.29, -13.40, 4.67},
			{324.31, -48.20, 4.72},
			{341.02, -63.74, 4.44},
			{368.46, -51.79, 5.63},
			{397.08, -63.80, 5.84},
			{432.31, -82.84, 5.26},
			{453.83, -93.52, 5.39},
			{463.83, -99.49, 5.40},
			{470.40, -126.54, 5.42},
			{490.39, -141.60, 4.90},
			{502.92, -187.78, 2.62},
			{499.35, -244.21, 1.96},
		},
		music_replay = 99,
		music = {
			intro = "MS_TenementsMid",
			gameplay = "MS_TenementsHigh",
			results = "MS_TenementsLow",
		},
	},
	{ -- First Aid (Ambulance, by SWEGTA) | NEW COVENTRY | 8:00 PM - 2:00 AM
		name = "First Aid (Ambulance)",
		id = "coventry_firstaid",
		description = "Help the injured residents of New Coventry get to the hospital. (Vehicle: Ambulance)",
		warp_pos = {478.82, -311.32, 2.82, 88.2}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {20, 0},
		end_time = {2, 0},
		area = 0,
		weather = 4,
		clock = {3, 0},
		blip = {471.17, -309.76, 2.89, 8}, -- last number is radius to play
		spectator_bounds = {514.62, -388.93, 521.48, -380.52}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {517.92, -384.30, 7.21, 0.8}, -- last number is spawn radius not heading
		max_timer = 300, -- max seconds
		vehicle = "ambulance",
		laps = 1,
		shuffle = 14,
		cameras = {
			results = {501.50, -390.97, 6.73, 508.25, -387.51, 13.25},
			time_15 = {499.48, -258.41, 17.31, 500.97, -268.09, 15.29},
			time_10 = {557.04, -495.57, 25.46, 551.11, -488.34, 21.92},
		},
		spawns = {
			{382.40, -424.31, 2.68+1, -74.3},
			{433.66, -442.62, 2.64+1, -107.1},
			{473.71, -461.15, 3.47+1, -19.4},
			{544.45, -464.59, 4.42+1, 165.3},
			{554.36, -429.44, 4.72+1, 163.2},
			{547.26, -398.44, 2.53+1, 57.9},
			{531.48, -323.19, 3.07+1, -88.3},
			{501.56, -302.08, 2.37+1, -0.6},
			{500.03, -226.26, 2.01+1, 175.3},
			{474.66, -252.22, 2.29+1, -179.3},
		},
		checkpoints = {
			{507.86, -241.45, 2.32, sound = "SmokeHelp", bank = "5_04.bnk"},
			{490.41, -251.04, 2.31, sound = "CupGagBarf", bank = "4_06.bnk"},
			{508.79, -263.84, 2.36, sound = "FartGroan", bank = "BathRm.bnk"},
			{513.95, -284.16, 2.29, sound = "FartPush", bank = "BathRm.bnk"},
			{545.40, -284.63, 2.30, sound = "BoyFallsOut", bank = "BoyFall.bnk"},
			{551.34, -331.46, 2.31, sound = "Gag", bank = "Candy.bnk"},
			{540.90, -350.45, 2.31, sound = "GagFemale", bank = "Candy.bnk"},
			{527.18, -370.36, 2.36, sound = "MaleDeathVox", bank = "Fight.bnk"},
			{518.77, -391.47, 2.29, sound = "FemaleDeathVox", bank = "Fight.bnk"},
			{481.89, -300.42, 2.52, sound = "Boy_Cry", bank = "Miss_206.bnk"},
			{500.11, -410.51, 2.27, sound = "SmokeHelp", bank = "5_04.bnk"},
			{477.72, -436.68, 2.69, sound = "CupGagBarf", bank = "4_06.bnk"},
			{450.71, -421.80, 3.86, sound = "FartGroan", bank = "BathRm.bnk"},
			{410.16, -430.79, 2.88, sound = "FartPush", bank = "BathRm.bnk"},
			{497.88, -461.99, 3.36, sound = "BoyFallsOut", bank = "BoyFall.bnk"},
			{512.73, -451.98, 3.95, sound = "Gag", bank = "Candy.bnk"},
			{528.18, -460.29, 4.44, sound = "GagFemale", bank = "Candy.bnk"},
			{528.63, -487.22, 4.37, sound = "MaleDeathVox", bank = "Fight.bnk"},
			{561.60, -469.28, 4.47, sound = "FemaleDeathVox", bank = "Fight.bnk"},
			{576.71, -443.92, 4.46, sound = "Boy_Cry", bank = "Miss_206.bnk"},
			{535.25, -434.24, 4.48, sound = "SmokeHelp", bank = "5_04.bnk"},
			{427.41, -457.02, 2.82, sound = "CupGagBarf", bank = "4_06.bnk"},
			{581.11, -457.51, 4.46, sound = "FartGroan", bank = "BathRm.bnk"},
			{454.39, -311.59, 2.00, sound = "FartPush", bank = "BathRm.bnk"},
			{508.32, -394.01, 2.25},
		},
		music_replay = 77,
		music = {
			intro = "MS_ChaseMid",
			gameplay = "MS_ChaseHigh",
			results = "MS_ChaseLow",
		},
	},
	{ -- Taxi Driver (Taxi, by SWEGTA) | BULLWORTH TOWN | 2:00 PM - 8:00 PM
		name = "Taxi Driver (Taxi)",
		id = "town_taxidriver",
		description = "Let's see who's the fastest cab driver in town! (Vehicle: Taxi)",
		warp_pos = {489.47, -67.46, 5.42, 177.3}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {20, 0},
		end_time = {2, 0},
		area = 0,
		weather = 3,
		clock = {1, 0},
		blip = {486.79, -76.26, 5.40, 8}, -- last number is radius to play
		spectator_bounds = {542.59, -78.61, 553.02, -73.49}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {549.74, -75.78, 12.61, 0.7}, -- last number is spawn radius not heading
		max_timer = 300, -- max seconds
		vehicle = 286,
		laps = 1,
		shuffle = 14,
		cameras = {
			results = {590.24, -91.68, 6.73, 599.74, -91.64, 9.85},
			time_15 = {484.98, -89.56, 10.31, 494.98, -89.71, 10.27},
			time_10 = {623.09, -77.41, 10.39, 614.04, -81.62, 9.90},
		},
		spawns = {
			{590.51, -74.84, 6.24, 87.0},
			{589.83, -138.12, 6.80, 15.3},
			{539.80, -113.29, 6.11, 90.4},
			{532.44, -67.82, 6.21, 93.7},
			{555.22, -21.88, 6.40, 133.6},
			{478.97, -67.52, 6.56, 95.6},
			{466.86, -31.30, 6.74, 178.5},
			{524.79, -173.80, 5.99, 99.5},
			{478.14, -202.13, 3.89, 14.9},
			{513.29, -113.16, 6.17, -88.7},
		},
		checkpoints = {
			{451.95, -196.94, 3.23, sound = "BuyItem", bank = "Hud.bnk"},
			{510.41, -128.83, 5.54, sound = "BuyItem", bank = "Hud.bnk"},
			{534.21, -128.79, 5.66, sound = "BuyItem", bank = "Hud.bnk"},
			{543.83, -141.70, 5.88, sound = "BuyItem", bank = "Hud.bnk"},
			{562.75, -136.12, 5.88, sound = "BuyItem", bank = "Hud.bnk"},
			{601.10, -109.27, 5.72, sound = "BuyItem", bank = "Hud.bnk"},
			{626.22, -91.35, 5.86, sound = "BuyItem", bank = "Hud.bnk"},
			{568.82, -60.65, 5.64, sound = "BuyItem", bank = "Hud.bnk"},
			{566.65, -99.65, 5.66, sound = "BuyItem", bank = "Hud.bnk"},
			{549.97, -82.84, 5.37, sound = "BuyItem", bank = "Hud.bnk"},
			{542.78, -95.62, 5.20, sound = "BuyItem", bank = "Hud.bnk"},
			{534.02, -82.62, 4.61, sound = "BuyItem", bank = "Hud.bnk"},
			{515.79, -97.63, 4.45, sound = "BuyItem", bank = "Hud.bnk"},
			{487.00, -96.72, 5.22, sound = "BuyItem", bank = "Hud.bnk"},
			{474.44, -97.61, 5.58, sound = "BuyItem", bank = "Hud.bnk"},
			{471.68, -63.28, 5.76, sound = "BuyItem", bank = "Hud.bnk"},
			{486.61, -37.14, 5.43, sound = "BuyItem", bank = "Hud.bnk"},
			{523.38, -32.18, 6.27, sound = "BuyItem", bank = "Hud.bnk"},
			{516.81, -56.30, 5.53, sound = "BuyItem", bank = "Hud.bnk"},
			{596.00, -17.62, 6.47, sound = "BuyItem", bank = "Hud.bnk"},
			{499.35, -82.06, 4.69, sound = "BuyItem", bank = "Hud.bnk"},
			{473.79, -37.81, 5.52, sound = "BuyItem", bank = "Hud.bnk"},
			{490.68, -50.63, 5.77, sound = "BuyItem", bank = "Hud.bnk"},
			{528.09, -59.25, 5.34, sound = "BuyItem", bank = "Hud.bnk"},
			{544.07, -23.02, 5.42, sound = "BuyItem", bank = "Hud.bnk"},
			{522.50, -89.42, 3.75},
		},
		music_replay = 70,
		music = {
			intro = "MS_InTroubleLow",
			gameplay = "MS_FightMid01",
			results = "MS_InTroubleLow",
		},
	},
	{ -- Keep It Tight (Gokart, by SWEGTA) | BULLWORTH TOWN | 8:00 PM - 2:00 AM
		name = "Keep It Tight (Gokart)",
		id = "town_tightcornersgokart",
		description = "This race is all about tight corners and narrow passages. (Vehicle: Gokart)",
		warp_pos = {489.47, -67.46, 5.42, 177.3}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {20, 0},
		end_time = {2, 0},
		area = 0,
		weather = 2,
		clock = {21, 0},
		blip = {486.85, -74.07, 5.42, 8}, -- last number is radius to play
		spectator_bounds = {584.29, -94.76, 593.67, -80.95}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {588.35, -89.14, 5.72, 1.1}, -- last number is spawn radius not heading
		max_timer = 240, -- max seconds
		vehicle = 289,
		laps = 1,
		cameras = {
			results = {583.02, -124.50, 21.88, 580.25, -115.50, 18.52},
			time_15 = {563.73, -89.60, 5.61, 573.54, -89.83, 7.53},
			time_10 = {586.86, -89.36, 13.14, 577.15, -88.94, 10.75},
		},
		spawns = {
			{569.92, -87.64, 6.13, 89.5},
			{570.00, -89.58, 6.13, 90.1},
			{570.07, -91.42, 6.12, 88.2},
			{572.56, -87.62, 6.09, 88.6},
			{572.47, -89.55, 6.08, 88.4},
			{572.43, -91.52, 6.06, 86.8},
			{574.99, -87.68, 5.98, 88.2},
			{574.95, -89.56, 5.97, 88.6},
			{574.85, -91.61, 5.96, 87.8},
			-- {567.56, -89.61, 6.04, 90.9},
		},
		checkpoints = {
			{553.61, -89.57, 5.13},
			{539.83, -80.51, 5.04},
			{541.95, -65.75, 5.41},
			{549.63, -52.09, 5.47},
			{540.54, -23.80, 5.44},
			{529.32, -3.15, 5.88},
			{468.04, -24.89, 5.99},
			{469.98, -66.01, 5.81},
			{486.08, -67.61, 5.58},
			{489.33, -80.63, 5.17},
			{470.92, -89.65, 5.47},
			{396.13, -105.47, 6.29},
			{347.70, -116.25, 6.20},
			{328.51, -107.28, 6.23},
			{318.21, -86.16, 5.18},
			{303.34, -72.45, 5.79},
			{279.67, -73.22, 5.97},
			{271.11, -99.84, 6.32},
			{258.80, -110.31, 6.20},
			{245.19, -119.51, 6.09},
			{246.39, -139.72, 6.11},
			{294.63, -140.57, 6.11},
			{295.69, -120.88, 6.10},
			{271.06, -101.61, 6.33},
			{271.15, -46.76, 6.23},
			{280.96, -37.87, 6.14},
			{296.16, -26.83, 6.50},
			{295.86, -8.41, 6.53},
			{247.38, -8.10, 6.35},
			{243.71, -18.86, 6.20},
			{244.95, -27.93, 6.07},
			{271.23, -44.79, 6.26},
			{271.10, -62.92, 6.00},
			{259.73, -72.99, 6.06},
			{234.18, -97.07, 6.19},
			{209.50, -111.69, 6.17},
			{167.91, -111.79, 6.14},
			{151.85, -99.84, 6.28},
			{129.08, -73.02, 6.02},
			{105.15, -63.32, 7.38},
			{106.91, -39.06, 5.55},
			{123.20, -20.05, 6.13},
			{109.58, -16.61, 6.11},
			{111.81, -1.44, 6.16},
			{117.91, 2.69, 6.12},
			{123.85, 12.18, 6.12},
			{129.31, 19.17, 6.10},
			{134.45, 27.39, 6.11},
			{140.29, 20.01, 6.12},
			{148.86, 6.76, 6.27},
			{226.19, 6.25, 5.92},
			{298.06, 5.68, 4.41},
			{319.93, 0.44, 4.40},
			{327.35, -18.72, 4.64},
			{316.13, -66.44, 4.98},
			{326.60, -104.82, 6.23},
			{347.20, -116.27, 6.20},
			{395.88, -105.75, 6.29},
			{446.77, -92.61, 5.21},
			{464.07, -100.75, 5.37},
			{471.32, -127.88, 5.33},
			{492.15, -146.23, 4.89},
			{511.73, -172.83, 4.38},
			{547.28, -173.41, 5.52},
			{580.03, -156.23, 5.87},
			{571.48, -114.71, 5.62},
			{530.11, -112.87, 5.22},
			{522.60, -102.47, 4.24},
			{531.99, -89.60, 4.31},
			{564.32, -89.62, 5.33},
		},
		music_replay = 168,
		music = {
			intro = "MS_Misbehaving_NISPrankInfo",
			gameplay = "MS_GoKarts02",
			results = "MS_Misbehaving_NISPrankSucess",
		},
	},
	{ -- Rollin' (Rolling Ball, by SWEGTA) | OLD BULLWORTH VALE | 2:00 PM - 8:00 PM
		name = "Rollin' (Rolling Ball)",
		id = "vale_rollin",
		description = "A balls to the wall-race from Old Bullworth Vale, to the academy, and back. (Vehicle: Rolling Ball)",
		warp_pos = {342.50, 263.53, 6.23, 75.6}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {14, 0},
		end_time = {20, 0},
		area = 0,
		weather = 0,
		clock = {14, 30},
		blip = {332.16, 263.82, 5.91, 8}, -- last number is radius to play
		spectator_bounds = {252.87, 368.11, 281.30, 379.18}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {268.26, 372.88, 19.96, 1.2}, -- last number is spawn radius not heading
		max_timer = 300, -- max seconds
		vehicle = "rolling_ball",
		laps = 1,
		cameras = {
			results = {245.72, 351.85, 23.14, 254.51, 356.60, 23.47},
			time_15 = {382.09, 273.54, 10.83, 381.26, 283.45, 11.82},
			time_10 = {376.56, 323.57, 21.32, 376.72, 313.85, 19.02},
		},
		spawns = {
			{372.29, 314.88, 15.83, -181.4},
			{373.98, 314.95, 15.83, -181.4},
			{375.84, 315.02, 15.82, -182.1},
			{377.91, 315.06, 15.82, -183.5},
			{380.09, 315.05, 15.81, -184.5},
			{381.82, 315.01, 15.81, 173.3},
			{383.52, 314.92, 15.82, 172.8},
			{385.21, 314.82, 15.84, 172.9},
			{387.65, 314.69, 15.84, 170.9},
			{390.12, 314.44, 15.85, 164.8},
		},
		checkpoints = {
			{380.53, 284.29, 8.32+0.05},
			{381.27, 258.93, 8.22+0.05},
			{392.70, 249.57, 8.38+0.05},
			{466.84, 249.64, 11.19+0.05},
			{530.04, 249.60, 16.53+0.05},
			{539.42, 262.76, 16.45+0.05},
			{539.07, 335.02, 16.65+0.05},
			{545.35, 349.59, 16.63+0.05},
			{581.01, 350.82, 15.60+0.05},
			{590.55, 359.24, 15.59+0.05},
			{590.13, 413.61, 16.97+0.05},
			{581.53, 421.70, 16.95+0.05},
			{554.90, 428.88, 16.95+0.05},
			{551.26, 463.72, 17.64+0.05},
			{538.75, 475.40, 17.54+0.05},
			{499.29, 472.13, 18.05+0.05},
			{484.10, 468.56, 17.55+0.05},
			{476.06, 429.03, 18.07+0.05},
			{470.02, 409.81, 17.08+0.05},
			{437.45, 388.56, 17.22+0.05},
			{420.70, 374.46, 16.25+0.05},
			{420.65, 363.38, 16.25+0.05},
			{435.63, 354.25, 15.62+0.05},
			{460.63, 342.36, 17.39+0.05},
			{477.60, 313.99, 20.10+0.05},
			{478.40, 292.01, 19.98+0.05},
			{447.91, 248.43, 9.96+0.05},
			{435.67, 224.01, 9.93+0.05},
			{435.14, 208.44, 8.30+0.05},
			{423.70, 198.64, 8.32+0.05},
			{365.84, 198.05, 6.29+0.05},
			{346.33, 201.07, 4.41+0.05},
			{337.77, 225.43, 4.90+0.05},
			{342.58, 253.97, 6.63+0.05},
			{356.18, 286.09, 7.73+0.05},
			{375.51, 309.55, 8.52+0.05},
			{376.30, 350.28, 18.78+0.05},
			{372.25, 398.26, 19.99+0.05},
			{364.66, 416.78, 20.93+0.05},
			{326.70, 435.54, 21.63+0.05},
			{317.40, 438.88, 21.74+0.05},
			{311.01, 432.23, 21.77+0.05},
			{313.62, 424.52, 21.97+0.05},
			{324.66, 425.25, 21.77+0.05},
			{342.60, 425.80, 21.52+0.05},
			{364.37, 418.94, 20.91+0.05},
			{373.90, 368.01, 19.14+0.05},
			{392.77, 348.34, 17.32+0.05},
			{425.52, 338.83, 16.22+0.05},
			{405.35, 306.71, 12.28+0.05},
			{389.77, 306.03, 8.54+0.05},
			{341.65, 306.84, 8.44+0.05},
			{329.40, 306.38, 6.35+0.05},
			{312.81, 289.17, 6.14+0.05},
			{296.29, 242.00, 4.17+0.05},
			{296.25, 187.45, 4.46+0.05},
			{332.03, 147.10, 4.98+0.05},
			{337.77, 59.69, 6.76+0.05},
			{336.42, 13.58, 4.87+0.05},
			{315.64, -62.06, 4.98+0.05},
			{303.65, -72.54, 5.78+0.05},
			{257.32, -72.87, 6.08+0.05},
			{235.24, -62.77, 6.19+0.05},
			{233.13, -47.38, 6.19+0.05},
			{215.49, -34.82, 6.19+0.05},
			{163.84, -35.03, 6.16+0.05},
			{147.03, -56.87, 6.28+0.05},
			{137.33, -72.89, 6.10+0.05},
			{120.46, -73.11, 5.93+0.05},
			{69.89, -73.54, 5.17+0.05},
			{11.29, -73.25, 4.95+0.05},
			{-27.66, -73.81, 1.00+0.05},
			{-46.30, -73.71, 1.06+0.05},
			{-44.97, -106.43, 1.00+0.05},
			{-12.44, -106.99, 1.01+0.05},
			{-11.79, -39.75, 1.00+0.05},
			{-44.59, -39.75, 1.00+0.05},
			{-44.97, -73.31, 1.00+0.05},
			{8.91, -72.77, 4.91+0.05},
			{82.22, -73.05, 5.73+0.05},
			{124.08, -73.21, 6.00+0.05},
			{139.62, -74.45, 6.21+0.05},
			{153.77, -105.36, 6.21+0.05},
			{168.03, -111.45, 6.14+0.05},
			{208.93, -111.65, 6.16+0.05},
			{219.41, -108.44, 6.19+0.05},
			{233.44, -97.80, 6.19+0.05},
			{234.43, -85.59, 6.21+0.05},
			{246.93, -72.79, 6.15+0.05},
			{302.47, -72.36, 5.79+0.05},
			{315.29, -76.40, 5.04+0.05},
			{331.93, -110.97, 6.22+0.05},
			{347.55, -116.32, 6.20+0.05},
			{396.52, -105.94, 6.29+0.05},
			{453.74, -90.93, 5.38+0.05},
			{521.91, -89.47, 3.74+0.05},
			{567.16, -89.39, 5.44+0.05},
			{575.47, -81.17, 5.35+0.05},
			{575.83, -2.40, 7.46+0.05},
			{562.14, 73.72, 13.67+0.05},
			{543.54, 146.43, 12.72+0.05},
			{530.80, 157.21, 14.64+0.05},
			{489.73, 164.13, 9.51+0.05},
			{470.88, 149.33, 9.26+0.05},
			{469.75, 119.39, 7.91+0.05},
			{478.30, 81.08, 3.73+0.05},
			{466.96, 67.36, 2.41+0.05},
			{433.52, 63.09, 2.66+0.05},
			{347.23, 84.29, 0.32+0.05},
			{326.55, 85.57, 0.77+0.05},
			{309.94, 110.43, 2.64+0.05},
			{276.89, 176.16, 2.31+0.05},
			{259.30, 233.46, 0.60+0.05},
			{265.87, 259.95, 1.22+0.05},
			{276.69, 301.95, 2.30+0.05},
			{244.66, 325.66, 1.67+0.05},
			{225.99, 337.14, 2.98+0.05},
			{232.32, 347.42, 3.79+0.05},
			{286.04, 338.37, 7.12+0.05},
			{326.20, 336.19, 12.41+0.05},
			{333.42, 355.31, 15.24+0.05},
			{289.83, 368.91, 19.75+0.05},
		},
		music_replay = 211,
		music = {
			intro = "MS_RomanceMid",
			gameplay = "MS_JockBossBattle",
			results = "MS_RomanceLow",
		},
	},
	{ -- Chomsky's Day Out (Gnome, by SWEGTA) | OLD BULLWORTH VALE | 2:00 PM - 8:00 PM
		name = "Chomsky's Day Out (Gnome)",
		id = "vale_gnome",
		description = "Chomsky is looking for some fun across the Vale. (Vehicle: Gnome)",
		warp_pos = {342.50, 263.53, 6.23, 75.6}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {14, 0},
		end_time = {20, 0},
		area = 0,
		weather = 0,
		clock = {17, 15},
		blip = {333.42, 263.20, 5.94, 8}, -- last number is radius to play
		spectator_bounds = {504.43, 495.17, 530.91, 512.08}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {515.64, 506.78, 19.61, 1.5}, -- last number is spawn radius not heading
		max_timer = 180, -- max seconds
		vehicle = "gnome",
		laps = 1,
		cameras = {
			results = {497.68, 514.95, 26.54, 506.19, 510.67, 23.50},
			time_15 = {525.07, 498.02, 20.14, 529.67, 506.90, 20.16},
			time_10 = {513.50, 505.39, 19.96, 523.48, 505.12, 20.54},
		},
		spawns = {
			{526.15, 498.75, 20.20, 67.8},
			{526.41, 500.18, 20.20, 68.5},
			{526.69, 501.73, 20.20, 73.7},
			{526.94, 503.14, 20.20, 69.9},
			{527.26, 504.48, 20.20, 62.9},
			{527.54, 505.87, 20.20, 68.8},
			{527.77, 507.21, 20.20, 75.8},
			{527.99, 508.60, 20.20, 74.5},
			{528.16, 510.00, 20.20, 84.7},
			{528.27, 511.30, 20.20, 90.3},
		},
		checkpoints = {
			{502.66, 510.10, 19.61, sound = "EatGood", bank = "Sumo.bnk"},
			{452.87, 519.95, 21.87},
			{416.87, 517.75, 22.24},
			{388.05, 504.06, 23.58},
			{361.25, 490.31, 22.28},
			{324.70, 447.76, 23.64},
			{299.61, 421.22, 20.74},
			{288.10, 383.66, 20.11},
			{314.68, 363.50, 17.70},
			{342.75, 331.09, 13.19},
			{357.95, 324.70, 13.08},
			{359.27, 308.69, 8.40},
			{374.30, 287.27, 8.31},
			{374.79, 262.58, 8.08},
			{374.90, 208.41, 6.38},
			{373.46, 175.49, 5.68},
			{369.87, 167.19, 5.44},
			{357.95, 168.31, 5.67},
			{346.35, 176.99, 5.44},
			{338.02, 171.10, 5.19},
			{338.71, 161.24, 5.31},
			{350.29, 151.37, 5.15, sound = "BuyItem"},
			{347.63, 144.41, 5.28},
			{347.50, 120.21, 5.43},
			{370.94, 119.22, 6.85},
			{393.48, 119.83, 5.30},
			{393.74, 142.75, 5.21},
			{386.82, 166.96, 5.96},
			{386.40, 191.43, 6.38},
			{423.18, 198.59, 8.32},
			{434.21, 204.35, 8.30},
			{435.93, 226.18, 9.88},
			{434.26, 255.75, 9.91},
			{419.64, 258.55, 9.32},
			{412.51, 285.46, 8.98},
			{403.79, 287.08, 8.99, sound = "MonkeyEat", bank = "Monkey.bnk"},
			{386.58, 295.19, 8.67},
			{373.63, 305.14, 8.62},
			{341.28, 306.74, 8.44},
			{325.05, 307.67, 6.28},
			{301.83, 343.18, 3.56},
			{278.87, 370.64, 3.73},
			{230.08, 409.47, 4.70},
			{215.94, 419.02, 4.15, sound = "W_ERROR", bank = "BioClass.bnk"},
			{228.26, 410.89, 4.66, sound = "Death", bank = "Sumo.bnk"},
			{284.59, 365.29, 3.33},
			{323.23, 307.61, 6.19},
			{328.27, 282.23, 6.27},
			{329.56, 262.91, 5.87, sound = "SwallowBurp", bank = "DrnkMcn.bnk"},
			{315.15, 250.02, 4.95},
			{314.64, 219.86, 4.70},
			{328.43, 218.01, 4.67},
			{351.29, 199.88, 4.40},
			{366.38, 198.53, 6.29},
			{375.66, 207.01, 6.36},
			{375.77, 238.30, 7.63},
			{398.06, 240.99, 8.51},
			{429.48, 241.98, 9.81, sound = "FartPush", bank = "BathRm.bnk"},
			{483.78, 242.28, 12.90, sound = "FartGroan", bank = "BathRm.bnk"},
			{530.84, 242.80, 16.64},
			{531.00, 257.11, 16.83, sound = "FartGroan", bank = "BathRm.bnk"},
			{503.88, 262.77, 20.07},
			{501.40, 271.93, 20.01, sound = "FartPush", bank = "BathRm.bnk"},
			{506.85, 280.79, 20.03},
			{507.87, 299.47, 20.05},
			{509.54, 317.34, 20.04, sound = "Fart", bank = "BathRm.bnk"},
			{495.21, 312.53, 20.04, sound = "Ahhh", bank = "DrnkMcn.bnk"},
			{480.22, 313.35, 20.09},
			{449.43, 349.87, 15.67},
			{428.22, 356.97, 15.66},
			{419.44, 366.50, 16.25},
			{422.51, 377.74, 16.30},
			{437.00, 388.31, 17.22},
			{457.93, 398.89, 16.12},
			{468.68, 408.12, 16.82},
			{477.67, 435.11, 18.41},
			{482.32, 465.62, 17.73},
			{497.18, 471.71, 17.91},
			{532.47, 488.64, 18.88},
			{533.63, 494.80, 19.30},
		},
		music_replay = 84,
		music = {
			intro = "MS_RomanceMid",
			gameplay = "MS_PrepFight",
			results = "MS_RomanceLow",
		},
	},
	{ -- Ghost Rider (Pumpkinhead, by SWEGTA) | OLD BULLWORTH VALE | 8:00 PM - 2:00 AM
		name = "Ghost Rider (Pumpkinhead)",
		id = "vale_ghostrider",
		description = "The creepy cryptid himself is haunting the sleeping citizens of Old Bullworth Vale. (Vehicle: Pumpkinhead)",
		warp_pos = {342.50, 263.53, 6.23, 75.6}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {20, 0},
		end_time = {2, 0},
		area = 0,
		weather = 3,
		clock = {0, 0},
		blip = {332.16, 263.82, 5.91, 8}, -- last number is radius to play
		spectator_bounds = {540.25, 133.11, 547.27, 163.42}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {542.97, 147.76, 12.77, 1.7}, -- last number is spawn radius not heading
		max_timer = 240, -- max seconds
		vehicle = "pumpkinhead",
		laps = 1,
		cameras = {
			results = {547.48, 192.90, 17.42, 552.18, 201.10, 20.72},
			time_15 = {541.51, 202.95, 16.99, 538.34, 193.92, 19.92},
			time_10 = {537.85, 188.05, 20.13, 538.73, 197.99, 19.42},
		},
		spawns = {
			{541.78, 199.54, 17.18+1, 0.1},
			{539.75, 199.47, 17.11+1, 1.6},
			{537.68, 199.40, 17.04+1, -2.1},
			{541.82, 196.92, 17.13+1, 0.1},
			{539.84, 196.90, 17.05+1, -1.3},
			{537.65, 196.96, 16.97+1, -3.5},
		},
		checkpoints = {
			{539.61, 239.80, 16.26, sound = "ReaperHit", bank = "FunHouse.bnk"},
			{538.87, 340.71, 16.56},
			{556.95, 359.26, 16.49},
			{568.01, 385.04, 14.80},
			{556.56, 406.42, 16.99},
			{532.95, 409.87, 17.48},
			{513.26, 398.98, 17.42},
			{517.34, 361.80, 16.64, sound = "ReaperHit", bank = "FunHouse.bnk"},
			{482.05, 339.10, 17.60},
			{468.93, 331.66, 19.00},
			{437.09, 368.19, 16.67},
			{412.30, 387.41, 17.05},
			{384.10, 388.56, 19.79},
			{376.38, 406.22, 20.41},
			{396.00, 403.90, 21.42},
			{408.45, 395.71, 21.33},
			{420.44, 396.23, 21.33},
			{421.43, 419.51, 21.37},
			{404.78, 421.00, 21.33},
			{387.27, 408.65, 21.50},
			{353.88, 416.96, 21.24},
			{334.65, 410.48, 22.72},
			{308.93, 371.94, 25.39},
			{297.82, 344.04, 17.28},
			{287.90, 310.76, 3.44},
			{279.66, 243.14, 4.62},
			{279.59, 206.55, 4.52},
			{280.62, 179.73, 2.29},
			{296.39, 150.33, 2.86},
			{321.56, 130.77, 5.11},
			{347.38, 100.94, 4.91},
			{393.37, 100.97, 5.24},
			{458.44, 75.44, 4.91},
			{476.34, 79.18, 3.53},
			{467.75, 131.80, 8.73},
			{488.85, 163.20, 9.46},
			{508.45, 158.30, 11.46},
			{524.71, 122.50, 9.45},
			{552.32, 103.53, 7.56},
			{637.68, 136.43, 14.59},
			{659.60, 174.38, 15.57},
			{648.65, 193.77, 17.01},
			{633.26, 158.83, 20.01},
			{609.70, 174.09, 20.02},
			{604.62, 164.71, 20.34},
			{624.21, 155.00, 19.99},
			{635.32, 149.49, 20.11},
			{641.36, 157.42, 19.96},
			{642.25, 179.46, 18.91},
			{649.57, 196.05, 16.63, sound = "ReaperHit", bank = "FunHouse.bnk"},
			{629.62, 220.74, 17.12},
			{604.27, 268.76, 15.56},
			{581.12, 298.56, 14.11},
			{579.15, 338.00, 15.76},
			{591.36, 386.34, 16.15},
			{588.48, 418.37, 16.95},
			{564.88, 423.22, 16.95},
			{554.13, 440.25, 17.15},
			{553.52, 467.40, 17.93},
			{574.73, 477.37, 18.83},
			{575.26, 484.12, 18.90},
			{564.71, 484.90, 18.93},
			{564.68, 476.62, 18.75, sound = "ReaperHit", bank = "FunHouse.bnk"},
			{558.76, 469.70, 18.19},
			{499.74, 472.23, 18.04},
			{482.85, 466.10, 17.68},
			{480.06, 428.44, 17.93},
			{487.70, 424.60, 17.18},
			{494.51, 400.42, 16.79},
			{494.45, 358.37, 16.80},
			{504.84, 350.32, 16.80},
			{530.64, 349.28, 16.43},
			{539.45, 286.78, 16.68},
			{540.03, 183.24, 16.08},
		},
		music_replay = 182,
		music = {
			intro = "MS_MathClassEnd",
			gameplay = "MS_PunishmentDetention",
			results = "MS_MathClassEnd",
		},
	},
	{ -- Alleyway Action (Electric Scooter, by SWEGTA) | OLD BULLWORTH VALE | 2:00 PM - 8:00 PM
		name = "Alleyway Action (Electric Scooter)",
		id = "vale_electricscooterrace",
		description = "Laps around the fancy alleys of Old Bullworth Vale. (Vehicle: Electric Scooter)",
		warp_pos = {342.50, 263.53, 6.23, 75.6}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {14, 0},
		end_time = {20, 0},
		area = 0,
		weather = 4,
		clock = {18, 35},
		blip = {334.66, 262.59, 5.97, 8}, -- last number is radius to play
		spectator_bounds = {388.56, 188.22, 399.19, 204.28}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {395.62, 198.25, 6.45, 1.5}, -- last number is spawn radius not heading
		max_timer = 300, -- max seconds
		vehicle = "electric_scooter",
		laps = 4,
		cameras = {
			results = {386.68, 190.69, 7.22, 390.59, 185.25, 14.64},
			time_15 = {383.37, 205.20, 6.95, 379.14, 196.26, 8.38},
			time_10 = {380.63, 235.47, 9.37, 372.68, 241.51, 9.78},
		},
		spawns = {
			{382.98, 202.05, 6.35, 1.2},
			{381.69, 201.99, 6.32, -0.7},
			{380.35, 202.06, 6.28, -2.1},
			{378.99, 202.09, 6.24, -2.1},
			{383.05, 200.28, 6.35, 1.0},
			{381.64, 200.26, 6.33, -0.3},
			{380.34, 200.30, 6.29, -2.0},
			{378.95, 200.33, 6.25, -1.1},
		},
		checkpoints = {
			{381.19, 220.06, 6.94},
			{373.41, 240.74, 7.71},
			{345.23, 241.05, 6.96},
			{339.27, 225.64, 4.90},
			{349.24, 188.09, 4.47},
			{347.34, 177.61, 5.41},
			{338.48, 171.39, 5.18},
			{347.88, 150.12, 5.22},
			{367.25, 146.69, 4.82},
			{392.94, 139.57, 5.19},
			{395.31, 119.74, 5.30},
			{422.15, 117.47, 5.40},
			{427.61, 155.75, 6.10},
			{371.49, 166.71, 5.35},
			{357.71, 168.18, 5.65},
			{350.04, 178.53, 5.35},
			{339.33, 228.47, 4.90},
			{348.26, 263.61, 6.43},
			{356.27, 289.56, 7.75},
			{335.13, 291.87, 6.32},
			{331.07, 267.93, 5.88},
			{343.46, 259.29, 6.33},
			{338.82, 228.54, 4.90},
			{351.68, 199.51, 4.42},
			{368.33, 198.54, 6.26},
		},
		music_replay = 100.5,
		music = {
			intro = "MS_Ambient01",
			gameplay = "MS_SneakDate_SexyGirl",
			results = "MS_Ambient01",
		},
	},
	{ -- Pretzel (Bike, by SWEGTA) | OLD BULLWORTH VALE | 8:00 PM - 2:00 AM
		name = "Pretzel (Gokart)",
		id = "vale_pretzel",
		description = "A tight race through the Old Bullworth Vale Park. (Vehicle: Gokart)",
		warp_pos = {342.50, 263.53, 6.23, 75.6}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {20, 0},
		end_time = {2, 0},
		area = 0,
		weather = 3,
		clock = {0, 0},
		blip = {335.32, 269.05, 5.89, 8}, -- last number is radius to play
		spectator_bounds = {562.88, 413.03, 586.05, 432.99}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {574.22, 422.14, 16.95, 1.3}, -- last number is spawn radius not heading
		max_timer = 360, -- max seconds
		vehicle = 289,
		laps = 6,
		cameras = {
			results = {494.04, 425.22, 17.68, 484.61, 424.97, 20.98},
			time_15 = {524.33, 421.48, 17.11, 514.49, 421.75, 18.89},
			time_10 = {536.09, 410.30, 27.01, 528.57, 415.57, 23.06},
		},
		spawns = {
			{520.29, 419.35, 17.45, -89.2},
			{520.22, 421.54, 17.45, -90.7},
			{520.24, 423.75, 17.45, -91.2},
			{517.74, 419.31, 17.44, -89.2},
			{517.79, 421.56, 17.44, -89.1},
			{517.89, 423.82, 17.43, -91.8},
			{515.43, 419.33, 17.43, -89.9},
			{515.45, 421.55, 17.42, -90.9},
			{515.43, 423.88, 17.42, -92.0},
			{512.76, 419.44, 17.41, -91.9},
			{512.88, 421.65, 17.41, -92.1},
			{513.00, 423.97, 17.41, -91.8},
		},
		checkpoints = {
			{537.00, 422.25, 16.93},
			{553.10, 429.20, 16.95},
			{551.96, 463.83, 17.71},
			{544.00, 475.53, 17.59},
			{501.98, 472.43, 17.94},
			{486.09, 469.68, 17.38},
			{481.06, 459.97, 18.00},
			{474.83, 422.14, 17.90},
			{469.40, 408.87, 16.94},
			{434.20, 386.37, 17.22},
			{423.37, 378.62, 16.33},
			{419.07, 369.62, 16.25},
			{423.39, 359.95, 15.97},
			{457.50, 345.07, 16.33},
			{474.17, 321.14, 19.82},
			{478.17, 308.45, 20.08},
			{473.61, 275.24, 21.27},
			{458.57, 273.56, 11.26},
			{459.16, 307.36, 14.85},
			{446.52, 340.42, 16.85},
			{449.59, 356.25, 15.64},
			{450.25, 367.49, 15.82},
			{436.02, 393.40, 17.22},
			{431.38, 404.33, 16.82},
			{433.03, 420.10, 17.36},
			{445.48, 429.44, 18.24},
			{467.34, 430.34, 18.65},
			{488.30, 423.88, 17.17},
		},
		music_replay = 0,
		music = {
			intro = "MS_Misbehaving_NISPrankInfo",
			gameplay = "MS_GoKart 01",
			results = "MS_Misbehaving_NISPrankInfo",
		},
	},
	{ -- Electric Avenue (Electric Skateboard, by SWEGTA) | OLD BULLWORTH VALE | 2:00 AM - 8:00 AM
		name = "Electric Avenue (Electric Skateboard)",
		id = "vale_electricsk8tochemplant",
		description = "A journey from Tad Spencer's house to the Blue Skies Chemplant. (Vehicle: Electric Skateboard)",
		warp_pos = {342.50, 263.53, 6.23, 75.6}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {2, 0},
		end_time = {8, 0},
		area = 0,
		weather = 1,
		clock = {4, 45},
		blip = {332.16, 263.82, 5.91, 8}, -- last number is radius to play
		spectator_bounds = {105.20, -528.33, 119.57, -495.23}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {109.68, -513.77, 2.99, 1.3}, -- last number is spawn radius not heading
		max_timer = 180, -- max seconds
		vehicle = "skateboard_electric",
		laps = 1,
		cameras = {
			results = {164.40, -492.31, 17.43, 155.09, -493.66, 14.04},
			time_15 = {400.77, 402.55, 26.34, 409.25, 407.41, 28.44},
			time_10 = {379.94, 407.18, 21.90, 389.73, 407.17, 23.92},
		},
		spawns = {
			{412.81, 413.58, 28.85, 88.2},
			{412.86, 412.05, 28.85, 87.9},
			{412.92, 410.42, 28.85, 87.4},
			{412.95, 408.82, 28.85, 86.7},
			{412.97, 407.29, 28.85, 86.2},
			{412.98, 405.90, 28.85, 84.8},
			{412.95, 404.66, 28.85, 83.7},
		},
		checkpoints = {
			{388.88, 407.71, 21.49},
			{355.83, 421.56, 21.12},
			{303.21, 423.33, 21.02},
			{285.91, 398.03, 20.11},
			{297.11, 370.25, 19.58},
			{334.87, 350.54, 14.82},
			{345.76, 329.28, 13.18},
			{358.91, 322.64, 13.08},
			{357.29, 289.26, 7.85},
			{342.53, 254.47, 6.59},
			{339.37, 228.70, 4.90},
			{349.14, 189.07, 4.53},
			{351.21, 175.78, 5.34},
			{359.63, 167.81, 5.81},
			{397.39, 162.62, 6.16},
			{420.04, 161.47, 6.10},
			{428.05, 123.25, 5.55},
			{446.99, 81.62, 5.05},
			{459.21, 75.40, 4.94},
			{477.24, 78.18, 3.44},
			{475.92, 102.18, 6.70},
			{468.48, 140.88, 9.11},
			{482.49, 161.18, 9.42},
			{525.64, 156.97, 14.55},
			{545.87, 136.11, 12.31},
			{561.73, 74.36, 13.68},
			{572.65, 32.88, 11.39},
			{576.05, -77.61, 5.36},
			{569.68, -112.52, 5.79},
			{530.44, -113.11, 5.24},
			{522.02, -130.88, 5.59},
			{494.56, -153.32, 4.65},
			{503.94, -207.80, 1.99},
			{500.74, -256.72, 2.07},
			{515.79, -299.03, 2.39},
			{520.98, -323.73, 2.12},
			{518.53, -364.18, 2.76},
			{496.24, -379.72, 2.61},
			{489.49, -414.30, 2.01},
			{460.24, -416.94, 2.54},
			{429.83, -411.22, 2.48},
			{360.83, -430.12, 2.68},
			{326.39, -437.51, 3.28},
			{285.90, -425.43, 2.52},
			{256.36, -423.66, 2.48},
			{223.43, -430.76, 2.72},
			{208.00, -398.18, 2.88},
			{195.95, -400.58, 2.83},
			{209.78, -436.29, 2.89},
			{208.44, -453.60, 2.73},
			{186.70, -466.24, 9.36},
			{163.57, -481.35, 2.17},
			{150.42, -483.07, 2.32},
			{135.46, -495.80, 2.58},
			{131.07, -509.26, 3.17},
			{143.19, -525.20, 4.96},
		},
		music_replay = 187,
		music = {
			intro = "MS_DestructionVandalismMid",
			gameplay = "MS_DestructionVandalismHigh",
			results = "MS_DestructionVandalismMid",
		},
	},
	{ -- Paying Back the Kindness (Lawnmower, by SWEGTA) | BULLWORTH ACADEMY | 2:00 AM - 8:00 AM
		name = "Paying Back the Kindness (Lawnmower)",
		id = "school_lawnmowerrace",
		description = "The football field is in dire need of a good mowing. (Vehicle: Lawnmower)",
		warp_pos = {198.76, -23.37, 6.19, -93.3}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {2, 0},
		end_time = {8, 0},
		area = 0,
		weather = 1,
		clock = {6, 0},
		blip = {201.92, -23.42, 6.24, 8}, -- last number is radius to play
		spectator_bounds = {-6.97, -101.97, 3.93, -80.60}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {-0.43, -89.90, 1.05, 0.7}, -- last number is spawn radius not heading
		max_timer = 300, -- max seconds
		vehicle = 284,
		laps = 1,
		shuffle = 25,
		cameras = {
			results = {-47.03, -81.80, 1.96, -52.49, -74.50, 6.08},
			time_15 = {-55.54, -110.55, 14.10, -49.05, -103.72, 10.72},
			time_10 = {-8.23, -35.10, 1.95, -14.61, -42.79, 2.25},
		},
		spawns = {
			{-16.27, -36.87, 1.64, 178.2},
			{-40.02, -37.00, 1.65, 179.1},
			{-40.15, -109.69, 1.65, -1.8},
			{-16.45, -109.72, 1.66, -1.0},
			{-8.14, -94.03, 1.62, 88.5},
			{-8.11, -53.44, 1.64, 88.5},
			{-48.77, -63.41, 1.81, -91.8},
			{-48.82, -89.74, 1.87, -90.6},
			{-31.41, -110.14, 1.65, -0.9},
			{-24.17, -110.15, 1.65, -1.8},
			{-23.65, -36.58, 1.65, 179.6},
			{-32.73, -36.61, 1.64, 178.3},
		},
		checkpoints = {
			{-16.29, -100.38, 1.00, sound = "GrassCutBlade", bank = "LwnMwr.bnk"},
			{-40.46, -100.37, 1.00, sound = "GrassCutBlade", bank = "LwnMwr.bnk"},
			{-27.87, -93.69, 1.00, sound = "GrassCutBlade", bank = "LwnMwr.bnk"},
			{-16.24, -86.93, 1.00, sound = "GrassCutBlade", bank = "LwnMwr.bnk"},
			{-40.33, -86.82, 1.00, sound = "GrassCutBlade", bank = "LwnMwr.bnk"},
			{-11.33, -80.02, 1.01, sound = "GrassCutBlade", bank = "LwnMwr.bnk"},
			{-45.37, -80.09, 1.00, sound = "GrassCutBlade", bank = "LwnMwr.bnk"},
			{-40.36, -73.81, 1.00, sound = "GrassCutBlade", bank = "LwnMwr.bnk"},
			{-16.22, -73.63, 1.01, sound = "GrassCutBlade", bank = "LwnMwr.bnk"},
			{-11.67, -66.83, 1.01, sound = "GrassCutBlade", bank = "LwnMwr.bnk"},
			{-44.95, -66.94, 1.00, sound = "GrassCutBlade", bank = "LwnMwr.bnk"},
			{-28.71, -60.14, 1.00, sound = "GrassCutBlade", bank = "LwnMwr.bnk"},
			{-40.25, -53.36, 1.00, sound = "GrassCutBlade", bank = "LwnMwr.bnk"},
			{-16.29, -53.31, 1.00, sound = "GrassCutBlade", bank = "LwnMwr.bnk"},
			{-28.40, -46.55, 1.00, sound = "GrassCutBlade", bank = "LwnMwr.bnk"},
			{-22.68, -103.85, 1.00, sound = "GrassCutBlade", bank = "LwnMwr.bnk"},
			{-36.96, -103.66, 1.00, sound = "GrassCutBlade", bank = "LwnMwr.bnk"},
			{-38.46, -90.32, 1.00, sound = "GrassCutBlade", bank = "LwnMwr.bnk"},
			{-20.21, -90.31, 1.00, sound = "GrassCutBlade", bank = "LwnMwr.bnk"},
			{-18.03, -77.09, 1.01, sound = "GrassCutBlade", bank = "LwnMwr.bnk"},
			{-36.52, -77.58, 1.00, sound = "GrassCutBlade", bank = "LwnMwr.bnk"},
			{-23.74, -62.63, 1.00, sound = "GrassCutBlade", bank = "LwnMwr.bnk"},
			{-32.72, -63.78, 1.00, sound = "GrassCutBlade", bank = "LwnMwr.bnk"},
			{-35.42, -50.24, 1.00, sound = "GrassCutBlade", bank = "LwnMwr.bnk"},
			{-23.27, -49.67, 1.00, sound = "GrassCutBlade", bank = "LwnMwr.bnk"},
			{-27.61, -73.43, 1.00, sound = "EngineStop", bank = "LwnMwr.bnk"},
		},
		music_replay = 199.5,
		music = {
			intro = "MS_Confrontation_NIS",
			gameplay = "MS_CarnivalFunhouseMaze",
			results = "MS_Confrontation_NIS",
		},
	},
	{ -- Dragon's Town (Bike, by SWEGTA) | BULLWORTH TOWN | 2:00 AM - 8:00 AM
		name = "Dragon's Town (Bike)",
		id = "town_dragonswingrace",
		description = "The Dragon's Wing customers are claiming Bullworth Town! (Vehicle: Racer BMX)",
		warp_pos = {489.47, -67.46, 5.42, 177.3}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {2, 0},
		end_time = {8, 0},
		area = 0,
		weather = 0,
		clock = {2, 15},
		blip = {486.85, -74.07, 5.42, 8}, -- last number is radius to play
		spectator_bounds = {502.45, -50.54, 512.98, -32.40}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {506.77, -43.72, 5.34, 0.9}, -- last number is spawn radius not heading
		max_timer = 360, -- max seconds
		vehicle = 282,
		laps = 6,
		cameras = {
			results = {517.78, -55.03, 7.17, 512.54, -59.18, 14.60},
			time_15 = {518.11, -76.32, 8.46, 520.98, -66.78, 7.55},
			time_10 = {522.06, -48.39, 7.34, 521.48, -58.36, 6.88},
		},
		spawns = {
			{520.64, -59.22, 5.79, -179.6},
			{522.18, -59.03, 5.74, 178.8},
			{523.67, -59.18, 5.65, 177.3},
			{520.60, -57.19, 5.87, -179.3},
			{522.19, -56.95, 5.87, 179.0},
			{523.74, -57.03, 5.78, 177.3},
			{520.57, -54.98, 5.95, -179.3},
			{522.19, -54.85, 5.95, 179.4},
			{523.81, -54.85, 5.91, 177.3},
			{520.54, -52.74, 6.03, -179.3},
			{522.20, -52.66, 6.04, 179.8},
			{523.89, -52.61, 6.04, 177.4},
		},
		checkpoints = {
			{522.38, -88.06, 3.77},
			{515.19, -112.55, 5.13},
			{489.66, -123.87, 5.94},
			{507.67, -168.14, 4.49},
			{527.26, -163.78, 10.00},
			{551.74, -159.62, 11.07},
			{572.90, -154.33, 8.01},
			{578.58, -143.45, 8.01},
			{576.78, -133.53, 5.85},
			{576.85, -74.49, 5.43},
			{575.57, -27.82, 5.64},
			{548.63, 0.69, 5.46},
			{522.78, -2.97, 5.78},
			{468.34, -23.92, 5.90},
			{466.37, -43.78, 5.43},
			{471.35, -66.78, 5.71},
			{502.63, -65.08, 7.08},
			{532.94, -67.66, 5.29},
			{541.79, -65.61, 5.41},
			{549.27, -55.15, 5.44},
			{547.91, -40.96, 5.57},
			{527.20, -42.23, 5.40},
			{522.11, -55.91, 5.33},
		},
		music_replay = 101.8,
		music = {
			intro = "MS_Confrontation_NIS",
			gameplay = "MS_FightingNerds",
			results = "MS_Confrontation_NIS",
		},
	},
	{ -- Out With the Old (Trash Car, by SWEGTA) | BULLWORTH TOWN | 2:00 PM - 8:00 PM
		name = "Out With the Old (Trash Car)",
		id = "town_trashcarrace",
		description = "This car is a pile of junk! Let's drop it off at the junkyard. (Vehicle: Trash Car)",
		warp_pos = {489.47, -67.46, 5.42, 177.3}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {14, 0},
		end_time = {20, 0},
		area = 0,
		weather = 5,
		clock = {19, 0},
		blip = {491.74, -79.02, 5.01, 8}, -- last number is radius to play
		spectator_bounds = {553.45, -494.23, 574.98, -484.31}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {559.68, -489.33, 4.34, 0.7}, -- last number is spawn radius not heading
		max_timer = 300, -- max seconds
		vehicle = {
			"trash_car",
			"trash_car2",
		},
		laps = 1,
		cameras = {
			results = {566.21, -499.40, 13.75, 558.65, -493.39, 11.19},
			time_15 = {573.00, 21.79, 10.83, 573.50, 31.63, 12.56},
			time_10 = {573.64, 37.62, 15.89, 573.90, 27.97, 13.26},
		},
		spawns = {
			{571.51, 27.97, 11.76+.05, -165.1},
			{574.00, 29.31, 11.89+.05, -165.9},
			{576.42, 29.56, 11.87+.05, -166.1},
			{574.97, 35.41, 12.74+.05, -169.0},
			{572.76, 34.04, 12.60+.05, -163.8},
			{570.09, 33.50, 12.58+.05, -165.2},
		},
		checkpoints = {
			{576.76, -24.40, 5.78},
			{567.48, -33.34, 5.43},
			{543.47, -36.00, 5.45},
			{522.50, -43.62, 5.41},
			{477.16, -44.27, 5.46},
			{468.42, -49.72, 5.44},
			{465.38, -79.13, 5.59},
			{475.30, -89.52, 5.37},
			{521.28, -89.58, 3.78},
			{567.25, -89.48, 5.44},
			{575.88, -98.18, 5.33},
			{575.22, -117.07, 5.48},
			{568.49, -127.33, 5.48},
			{536.83, -135.47, 5.40},
			{522.42, -128.72, 5.50},
			{522.50, -97.08, 4.13},
			{529.02, -89.84, 4.22},
			{539.07, -79.89, 4.98},
			{537.25, -68.94, 5.38},
			{516.04, -65.42, 4.99},
			{505.54, -60.96, 5.66},
			{506.82, -38.54, 5.43},
			{536.34, -29.69, 5.84},
			{553.75, -20.88, 5.45},
			{555.60, -6.11, 5.47},
			{528.55, -2.68, 5.90},
			{496.54, -12.01, 6.11},
			{468.26, -25.36, 5.98},
			{465.40, -73.19, 5.50},
			{467.18, -115.18, 5.41},
			{474.03, -130.69, 5.21},
			{488.03, -137.04, 4.82},
			{523.31, -136.87, 5.58},
			{568.64, -126.99, 5.48},
			{581.20, -133.38, 5.86},
			{583.40, -151.23, 5.88},
			{561.65, -168.69, 5.88},
			{510.93, -175.58, 4.00},
			{504.37, -191.98, 2.52},
			{499.16, -244.67, 1.95},
			{509.52, -270.38, 2.29},
			{525.21, -272.21, 2.31},
			{528.40, -285.77, 2.30},
			{536.00, -292.70, 2.04},
			{544.05, -306.31, 2.04},
			{539.88, -321.17, 2.32},
			{522.04, -327.00, 2.14},
			{518.31, -360.41, 2.48},
			{491.77, -373.06, 2.66},
			{473.10, -380.86, 3.51},
			{463.00, -413.46, 2.47},
			{480.65, -422.22, 2.01},
			{481.66, -439.98, 2.59},
			{472.66, -443.61, 2.90},
			{449.53, -445.36, 2.59},
			{421.26, -437.24, 2.80},
			{414.52, -422.81, 2.72},
			{431.08, -412.04, 2.49},
			{479.50, -422.04, 2.01},
			{483.48, -440.32, 2.58},
			{483.55, -450.54, 2.63},
			{513.63, -460.12, 4.08},
			{521.63, -457.21, 4.20},
			{526.29, -443.08, 4.34},
			{549.43, -444.54, 4.31},
			{547.93, -456.57, 4.45},
			{541.90, -475.82, 4.45},
			{548.35, -493.97, 4.42},
		},
		music_replay = 142,
		music = {
			intro = "MS_Misbehaving_NISPrankSucess",
			gameplay = "MS_FightingDropouts",
			results = "MS_Misbehaving_NISPrankInfo",
		},
	},
	{ -- Midnight Carnival Crew (Unicycle, by SWEGTA) | OLD BULLWORTH VALE | 8:00 PM - 2:00 AM
		name = "Midnight Carnival Crew (Unicycle)",
		id = "vale_unicyclerace",
		description = "The Carnies are hittin' the road, one wheel at a time! (Vehicle: Unicycle)",
		warp_pos = {342.50, 263.53, 6.23, 75.6}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {20, 0},
		end_time = {2, 0},
		area = 0,
		weather = 0,
		clock = {0, 0},
		blip = {333.42, 263.20, 5.94, 8}, -- last number is radius to play
		spectator_bounds = {210.05, 411.52, 228.58, 416.25}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {221.16, 416.24, 4.41, 1.2}, -- last number is spawn radius not heading
		max_timer = 300, -- max seconds
		vehicle = "unicycle",
		laps = 1,
		cameras = {
			results = {198.84, 452.26, 4.85, 199.06, 459.60, 11.64},
			time_15 = {230.90, 405.82, 4.98, 225.67, 413.49, 8.71},
			time_10 = {215.45, 416.76, 7.92, 222.67, 423.57, 6.69},
		},
		spawns = {
			{234.26, 440.83, 4.93, 146.7},
			{235.71, 439.93, 4.86, 148.7},
			{237.32, 439.01, 4.81, 148.8},
			{238.90, 438.05, 4.79, 147.6},
			{240.48, 437.06, 4.78, 147.3},
			{242.09, 436.06, 4.79, 147.2},
		},
		checkpoints = {
			{226.76, 412.55, 4.61},
			{254.63, 390.28, 4.81},
			{284.31, 365.66, 3.34},
			{308.46, 327.65, 5.00},
			{313.55, 285.77, 6.16},
			{298.42, 251.56, 4.59},
			{294.72, 220.01, 4.53},
			{325.13, 220.24, 4.67},
			{350.09, 198.76, 4.41},
			{374.42, 198.85, 6.22},
			{380.87, 182.29, 5.82},
			{379.58, 147.09, 4.64},
			{371.21, 131.77, 5.33},
			{353.17, 119.04, 5.32},
			{339.64, 92.54, 4.73},
			{340.23, 43.88, 6.16},
			{334.06, 4.04, 4.68},
			{316.48, 1.62, 4.40},
			{268.73, 6.46, 5.36},
			{243.82, 11.75, 6.04},
			{218.49, 25.47, 3.71},
			{179.84, 31.88, 4.82},
			{144.80, 45.44, 3.67},
			{114.11, 39.33, 4.66},
			{80.13, 30.19, 5.83},
			{48.53, 26.13, 6.09},
			{14.63, 31.07, 5.17},
			{-26.81, 35.49, 5.06},
			{-50.88, 20.72, 4.34},
			{-68.61, -26.11, 4.20},
			{-72.92, -77.09, 3.87},
			{-71.20, -95.24, 2.58},
			{-87.64, -149.11, 4.07},
			{-85.85, -188.05, 6.10},
			{-69.58, -229.40, 6.15},
			{-55.11, -240.53, 5.95},
			{-22.48, -247.06, 5.41},
			{11.65, -271.54, 2.35},
			{57.74, -300.19, 1.59},
			{71.51, -342.84, 0.20},
			{72.57, -360.69, 0.32},
			{50.39, -371.82, 0.35},
			{40.55, -382.96, 0.46},
			{86.01, -376.13, 2.69},
			{125.07, -370.63, 2.29},
			{190.44, -365.03, 2.59},
			{211.09, -347.00, 2.59},
			{232.85, -345.30, 2.59},
			{247.00, -356.68, 2.65},
			{270.28, -355.44, 2.70},
			{294.32, -341.82, 2.83},
			{315.11, -341.72, 2.85},
			{322.43, -356.22, 2.68},
			{321.18, -369.45, 2.69},
			{303.23, -384.68, 2.69},
			{295.52, -422.46, 2.90},
			{312.34, -435.30, 2.64},
			{330.40, -437.53, 3.22},
			{377.30, -425.37, 2.68},
			{423.80, -412.31, 2.48},
			{450.16, -413.64, 2.63},
			{463.77, -412.66, 2.43},
			{474.12, -379.98, 3.32},
			{489.65, -372.44, 2.67},
			{494.08, -341.13, 2.82},
			{492.44, -326.12, 2.83},
			{478.24, -314.45, 2.87},
			{478.54, -277.67, 2.72},
			{498.33, -263.92, 2.09},
			{498.09, -230.54, 2.00},
			{504.05, -202.13, 1.99},
			{493.36, -148.21, 4.74},
			{479.63, -133.86, 5.06},
			{468.73, -123.43, 5.43},
			{465.51, -82.09, 5.50},
			{466.73, -34.43, 5.63},
			{472.22, -19.60, 5.84},
			{516.27, -6.05, 5.86},
			{566.90, 14.03, 9.23},
			{571.69, 37.10, 11.99},
			{551.53, 113.05, 11.99},
			{539.65, 176.38, 15.70},
			{539.44, 242.85, 16.34},
			{515.02, 249.58, 15.82},
			{436.76, 249.55, 9.83},
			{390.84, 249.57, 8.30},
			{380.96, 264.46, 8.24},
			{379.42, 293.74, 8.37},
			{352.37, 299.08, 7.56},
			{326.76, 298.40, 6.11},
			{312.36, 316.84, 5.42},
			{294.60, 353.85, 3.17},
			{251.72, 392.90, 4.92},
			{226.62, 412.14, 4.60},
		},
		music_replay = 162,
		music = {
			intro = "MS_Carnival01",
			gameplay = "MS_BikeFastHigh",
			results = "MS_Carnival01",
		},
	},
	{ -- Dirty Deeds (Limo, by SWEGTA) | BULLWORTH TOWN | 8:00 PM - 2:00 AM
		name = "Dirty Deeds (Limo)",
		id = "town_dirtymagdelivery",
		description = "The residents of Old Bullworth Vale have ordered some spicy reading material. (Vehicle: Limo)",
		warp_pos = {489.47, -67.46, 5.42, 177.3}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {20, 0},
		end_time = {2, 0},
		area = 0,
		weather = 1,
		clock = {20, 0},
		blip = {491.74, -79.02, 5.01, 8}, -- last number is radius to play
		spectator_bounds = {539.41, -158.12, 541.51, -144.28}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {540.71, -152.12, 16.34, 0.5}, -- last number is spawn radius not heading
		max_timer = 300, -- max seconds
		vehicle = "limo_dirtymags",
		laps = 1,
		shuffle = 10,
		cameras = {
			results = {528.90, -128.59, 9.31, 538.02, -131.82, 6.79},
			time_15 = {530.63, -133.03, 5.84, 535.30, -124.74, 8.91},
			time_10 = {557.43, -138.41, 15.64, 548.92, -135.37, 11.36},
		},
		spawns = {
			{544.22, -132.76, 6.35, -79.6},
			{544.82, -135.94, 6.38, -77.5},
			{538.14, -133.74, 6.32, 98.0},
			{538.68, -137.14, 6.31, 99.0},
		},
		checkpoints = {
			{388.38, 188.46, 6.39, sound = "BuyItem", bank = "Hud.bnk"},
			{434.34, 163.31, 6.10, sound = "BuyItem", bank = "Hud.bnk"},
			{334.68, 194.54, 4.63, sound = "BuyItem", bank = "Hud.bnk"},
			{370.99, 288.89, 8.25, sound = "BuyItem", bank = "Hud.bnk"},
			{374.15, 251.55, 7.99, sound = "BuyItem", bank = "Hud.bnk"},
			{388.86, 223.83, 7.51, sound = "BuyItem", bank = "Hud.bnk"},
			{426.00, 238.41, 9.60, sound = "BuyItem", bank = "Hud.bnk"},
			{445.36, 233.98, 9.67, sound = "BuyItem", bank = "Hud.bnk"},
			{448.78, 202.11, 8.39, sound = "BuyItem", bank = "Hud.bnk"},
			{529.93, 170.66, 15.97, sound = "BuyItem", bank = "Hud.bnk"},
			{548.82, 242.54, 17.04, sound = "BuyItem", bank = "Hud.bnk"},
			{548.96, 322.28, 17.25, sound = "BuyItem", bank = "Hud.bnk"},
			{535.93, 375.28, 17.20, sound = "BuyItem", bank = "Hud.bnk"},
			{600.09, 388.52, 16.39, sound = "BuyItem", bank = "Hud.bnk"},
			{577.17, 470.77, 18.51, sound = "BuyItem", bank = "Hud.bnk"},
			{364.37, 375.87, 20.05, sound = "BuyItem", bank = "Hud.bnk"},
			{414.83, 310.81, 12.28, sound = "BuyItem", bank = "Hud.bnk"},
			{534.37, -129.03, 5.67}, -- End
		},
		music_replay = 134.1,
		music = {
			intro = "MS_Misbehaving_NISPrankInfo",
			gameplay = "MS_MisbehavingHigh_NIS01",
			results = "MS_Misbehaving_NISPrankSucess",
		},
	},
	{ -- Four Wheels And A Box (Soapbox, by SWEGTA) | OLD BULLWORTH VALE | 2:00 AM - 8:00 AM
		name = "Four Wheels And A Box (Soapbox)",
		id = "vale_soapboxrace",
		description = "It's a soab box derby, through Vale, the Academy, Town, and back! (Vehicle: Soapbox)",
		warp_pos = {342.50, 263.53, 6.23, 75.6}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {2, 0},
		end_time = {8, 0},
		area = 0,
		weather = 0,
		clock = {6, 30},
		blip = {334.66, 262.59, 5.97, 8}, -- last number is radius to play
		spectator_bounds = {545.15, 215.88, 552.70, 228.50}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {548.93, 221.71, 16.74, 1.5}, -- last number is spawn radius not heading
		max_timer = 420, -- max seconds
		vehicle = "soapbox",
		laps = 5,
		cameras = {
			results = {543.49, 234.62, 16.95, 540.55, 225.51, 19.85},
			time_15 = {553.04, 253.12, 37.79, 549.20, 261.53, 33.98},
			time_10 = {539.72, 204.97, 18.25, 540.21, 214.96, 18.02},
		},
		spawns = {
			{541.79, 215.24, 17.01, 0.1},
			{539.69, 215.05, 16.97, 0.5},
			{537.67, 215.02, 16.89, -1.4},
			{541.80, 213.20, 17.06, 0.1},
			{539.71, 213.11, 17.02, -0.6},
			{537.65, 213.00, 16.95, -1.9},
			{541.77, 211.07, 17.10, -1.9},
			{539.71, 211.05, 17.07, -0.9},
			{537.60, 211.06, 17.01, -3.0},
			{541.68, 209.03, 17.15, -2.5},
			{539.76, 208.89, 17.11, -0.8},
			{537.51, 208.99, 17.06, -3.5},
		},
		checkpoints = {
			{539.52, 235.82, 16.24},
			{532.08, 249.45, 16.53},
			{496.25, 249.54, 14.11},
			{429.12, 249.57, 9.66},
			{390.89, 249.59, 8.30},
			{381.14, 235.56, 7.58},
			{381.10, 193.07, 6.29},
			{379.78, 150.03, 4.74},
			{371.98, 140.13, 4.63},
			{347.54, 139.79, 5.15},
			{338.94, 128.35, 5.05},
			{339.54, 90.64, 4.95},
			{339.97, 57.94, 6.67},
			{340.64, 19.63, 5.05},
			{332.46, 0.74, 4.68},
			{299.50, 5.64, 4.40},
			{226.45, 5.78, 5.89},
			{187.32, -18.11, 6.10},
			{181.45, -33.77, 5.91},
			{162.82, -35.27, 6.17},
			{151.83, -44.21, 6.30},
			{150.21, -98.88, 6.29},
			{162.55, -110.62, 6.16},
			{208.61, -111.55, 6.14},
			{222.62, -106.15, 6.19},
			{234.18, -96.89, 6.19},
			{234.99, -84.17, 6.21},
			{258.84, -72.74, 6.06},
			{302.24, -72.26, 5.79},
			{315.26, -77.39, 5.04},
			{327.30, -104.84, 6.24},
			{344.89, -115.84, 6.19},
			{396.32, -105.82, 6.29},
			{454.07, -90.72, 5.39},
			{505.64, -89.56, 4.22},
			{568.57, -89.48, 5.49},
			{576.45, -74.67, 5.43},
			{576.80, -20.77, 5.95},
			{571.31, 39.79, 12.17},
			{556.53, 94.14, 13.08},
			{542.64, 149.42, 12.90},
			{539.92, 202.31, 16.59},
		},
		music_replay = 0,
		music = {
			intro = "MS_WIldstyleMid",
			gameplay = "MS_WIldstyleHigh",
			results = "MS_WIldstyleLow",
		},
	},
	{ -- Recycling (Garbage Trolley, by SWEGTA) | OLD BULLWORTH VALE | 8:00 PM - 2:00 AM
		name = "Recycling (Garbage Trolley)",
		id = "vale_recycling",
		description = "Empty the garbage bins and dumpsters, and then transport the trash to New Coventry. (Vehicle: Garbage Trolley)",
		warp_pos = {342.50, 263.53, 6.23, 75.6}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {20, 0},
		end_time = {2, 0},
		area = 0,
		weather = 0,
		clock = {21, 30},
		blip = {334.66, 262.59, 5.97, 8}, -- last number is radius to play
		spectator_bounds = {423.15, -460.74, 438.36, -453.10}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {431.52, -456.72, 2.62, 1.2}, -- last number is spawn radius not heading
		max_timer = 300, -- max seconds
		vehicle = "garbage_trolley",
		laps = 1,
		shuffle = 20,
		cameras = {
			results = {424.30, -462.86, 7.72, 431.50, -456.53, 4.88},
			time_15 = {391.60, 291.80, 11.36, 388.78, 282.21, 11.67},
			time_10 = {325.97, 168.48, 6.04, 326.03, 178.34, 7.70},
		},
		spawns = {
			{355.84, 272.87, 7.84, -0.4},
			{360.43, 240.86, 7.34, -90.0},
			{356.95, 167.30, 5.65, -89.1},
			{343.91, 176.30, 5.47, 137.3},
		},
		checkpoints = {
			{370.76, 303.13, 8.64, sound = "GarbageStuff", bank = "GrbCan.bnk"},
			{367.81, 291.16, 8.26, sound = "GarbageStuff", bank = "GrbCan.bnk"},
			{393.56, 281.07, 8.92, sound = "GarbageStuff", bank = "GrbCan.bnk"},
			{374.22, 244.56, 7.87, sound = "GarbageStuff", bank = "GrbCan.bnk"},
			{403.41, 243.26, 8.80, sound = "GarbageStuff", bank = "GrbCan.bnk"},
			{444.21, 204.91, 8.35, sound = "GarbageStuff", bank = "GrbCan.bnk"},
			{387.94, 207.50, 6.74, sound = "GarbageStuff", bank = "GrbCan.bnk"},
			{382.55, 141.21, 4.93, sound = "GarbageStuff", bank = "GrbCan.bnk"},
			{398.16, 118.96, 5.28, sound = "GarbageStuff", bank = "GrbCan.bnk"},
			{423.74, 124.66, 5.57, sound = "GarbageStuff", bank = "GrbCan.bnk"},
			{357.60, 176.08, 5.52, sound = "GarbageStuff", bank = "GrbCan.bnk"},
			{350.11, 122.45, 5.32, sound = "GarbageStuff", bank = "GrbCan.bnk"},
			{315.34, 133.33, 2.96, sound = "GarbageStuff", bank = "GrbCan.bnk"},
			{326.62, 172.25, 5.15, sound = "GarbageStuff", bank = "GrbCan.bnk"},
			{291.31, 184.40, 4.57, sound = "GarbageStuff", bank = "GrbCan.bnk"},
			{309.61, 227.23, 4.69, sound = "GarbageStuff", bank = "GrbCan.bnk"},
			{351.04, 205.22, 4.65, sound = "GarbageStuff", bank = "GrbCan.bnk"},
			{284.33, 245.19, 4.59, sound = "GarbageStuff", bank = "GrbCan.bnk"},
			{308.18, 295.12, 6.19, sound = "GarbageStuff", bank = "GrbCan.bnk"},
			{358.79, 280.55, 8.00, sound = "GarbageStuff", bank = "GrbCan.bnk"},
			{435.33, -449.56, 2.52},
		},
		music_replay = 104.3,
		music = {
			intro = "MS_Confrontation_NIS",
			gameplay = "MS_CarnivalFunhouseMiner",
			results = "MS_Confrontation_NIS",
		},
	},
	{ -- 2.4 GHz (RC Car, by SWEGTA) | BULLWORTH TOWN | 2:00 AM - 8:00 AM
		name = "2.4 GHz (RC Car)",
		id = "town_rcrace1",
		description = "Dragon's Wing is hosting an RC car race. And no, they're not toys! (Vehicle: RC Car)",
		warp_pos = {489.47, -67.46, 5.42, 177.3}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {2, 0},
		end_time = {8, 0},
		area = 0,
		weather = 4,
		clock = {2, 15},
		blip = {491.74, -77.04, 5.03, 8}, -- last number is radius to play
		spectator_bounds = {503.04, -67.77, 515.54, -62.50}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {508.03, -65.42, 5.43, 0.6}, -- last number is spawn radius not heading
		max_timer = 420, -- max seconds
		vehicle = "rc_car",
		laps = 7,
		cameras = {
			results = {517.56, -50.82, 6.00, 514.08, -59.82, 8.64},
			time_15 = {518.07, -57.94, 5.97, 512.97, -53.91, 13.57},
			time_10 = {522.39, -79.49, 13.03, 522.39, -69.84, 10.42},
		},
		spawns = {
			{523.78, -58.56, 5.69, 1.1},
			{522.35, -58.66, 5.75, 1.2},
			{520.94, -58.66, 5.82, -1.4},
			{523.82, -60.56, 5.56, 1.5},
			{522.37, -60.63, 5.63, 1.3},
			{521.05, -60.71, 5.69, 2.1},
			{523.84, -62.49, 5.44, 1.4},
			{522.43, -62.56, 5.51, 1.7},
			{521.13, -62.65, 5.57, 0.5},
			{523.87, -64.53, 5.32, 1.6},
			{522.48, -64.61, 5.39, 2.0},
			{521.14, -64.76, 5.46, 0.8},
			{523.88, -66.57, 5.24, 1.5},
			{522.52, -66.72, 5.30, 2.0},
			{521.14, -66.75, 5.36, 1.0},
		},
		checkpoints = {
			{521.97, -50.45, 5.52},
			{529.76, -41.63, 5.38},
			{564.38, -33.48, 5.52},
			{577.40, -54.87, 5.57},
			{582.68, -73.30, 5.42},
			{612.55, -75.10, 5.33},
			{619.41, -99.19, 5.36},
			{584.91, -104.37, 5.31},
			{572.04, -89.68, 5.51},
			{545.58, -89.67, 4.97},
			{539.65, -81.01, 5.01},
			{536.89, -68.72, 5.38},
			{527.79, -68.03, 5.00},
			{522.25, -94.08, 4.08},
			{527.84, -112.46, 5.12},
			{564.63, -113.85, 5.65},
			{575.04, -122.09, 5.47},
			{578.89, -145.04, 8.01},
			{571.30, -155.17, 8.01},
			{538.26, -160.87, 10.72},
			{512.99, -169.29, 4.61},
			{496.05, -160.06, 4.36},
			{489.86, -138.52, 4.86},
			{472.32, -129.38, 5.28},
			{465.00, -98.22, 5.43},
			{487.35, -89.57, 4.85},
			{515.11, -89.42, 4.01},
			{521.90, -69.79, 4.62},
		},
		music_replay = 0,
		music = {
			intro = "ArcRaceMXmidi02SPLASHBED01",
			gameplay = "ArcRaceMXmidi02Drive01",
			results = "ArcRaceMXmidi02SPLASHBED04",
		},
	},
	{ -- Wicked (Broom, by SWEGTA) | OLD BULLWORTH VALE | 2:00 AM - 8:00 AM
		name = "Wicked (Broom)",
		id = "vale_witchrace",
		description = "The Witching Hour is at hand, and the academy is the playground. (Vehicle: Broom)",
		warp_pos = {342.50, 263.53, 6.23, 75.6}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {2, 0},
		end_time = {8, 0},
		area = 0,
		weather = 3,
		clock = {3, 0},
		blip = {333.42, 263.20, 5.94, 8}, -- last number is radius to play
		spectator_bounds = {304.52, 306.98, 320.30, 320.13}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {313.34, 313.25, 5.62, 1.2}, -- last number is spawn radius not heading
		max_timer = 300, -- max seconds
		vehicle = "broomstick",
		laps = 2,
		cameras = {
			results = {303.22, 330.34, 21.68, 305.63, 321.56, 17.56},
			time_15 = {309.83, 292.04, 6.63, 315.01, 300.43, 8.25},
			time_10 = {316.57, 253.55, 21.69, 316.25, 262.86, 18.05},
		},
		spawns = {
			{311.16, 295.44, 6.65, -175.7},
			{313.42, 295.73, 6.65, -172.8},
			{315.75, 296.09, 6.65, -172.0},
			{310.98, 297.76, 6.62, -175.8},
			{313.13, 298.00, 6.62, -172.8},
			{315.43, 298.38, 6.62, -172.0},
			{310.80, 300.19, 6.59, -175.7},
			{312.83, 300.45, 6.59, -172.8},
			{315.10, 300.73, 6.60, -172.0},
		},
		checkpoints = {
			{312.51, 278.94, 5.96},
			{297.74, 248.50, 4.38},
			{294.60, 211.72, 4.49},
			{296.61, 185.49, 4.48},
			{331.51, 147.65, 4.98},
			{339.53, 95.81, 4.38},
			{340.12, 59.44, 6.72},
			{340.61, 23.71, 5.21},
			{326.89, -20.45, 4.64},
			{310.53, -68.55, 5.37},
			{303.12, -72.39, 5.79, sound = "WitchHit", bank = "FunHouse.bnk"}, -- Gates
			{263.30, -73.16, 6.00},
			{251.54, -72.85, 6.12},
			{234.77, -91.64, 6.20},
			{222.99, -105.94, 6.19},
			{209.10, -111.91, 6.17},
			{168.01, -111.59, 6.14},
			{149.75, -99.54, 6.27},
			{133.14, -72.92, 6.02},
			{113.58, -73.22, 7.28},
			{93.06, -72.88, 7.30},
			{40.93, -73.09, 5.03},
			{9.09, -72.89, 4.91},
			{-28.09, -73.73, 1.00},
			{-52.00, -87.18, 1.50},
			{-53.07, -113.78, 1.54},
			{-28.16, -116.66, 1.25},
			{-3.94, -107.67, 1.08},
			{0.21, -68.25, 0.93},
			{6.30, -64.95, 0.87},
			{5.86, -42.60, 0.87},
			{-21.53, -23.98, 2.04},
			{-31.08, -31.67, 1.41},
			{-53.81, -46.69, 1.39},
			{-51.33, -63.55, 1.35},
			{-27.83, -73.78, 1.00},
			{9.13, -72.83, 4.92},
			{51.02, -73.33, 5.05},
			{92.87, -72.86, 7.29},
			{102.60, -62.46, 7.32},
			{107.44, -38.05, 5.57},
			{121.13, -19.68, 6.13},
			{109.53, -16.84, 6.11},
			{111.95, -1.16, 6.16},
			{117.85, 3.21, 6.12, sound = "WitchHit", bank = "FunHouse.bnk"},
			{123.89, 12.24, 6.12},
			{134.82, 27.52, 6.12},
			{141.25, 16.77, 6.12},
			{150.21, 7.02, 6.29},
			{177.88, 6.37, 5.46},
			{207.45, 8.42, 5.63},
			{214.86, -8.26, 6.01},
			{210.28, -16.35, 6.12},
			{201.50, -16.81, 6.06},
			{168.04, -34.23, 6.15},
			{150.59, -46.32, 6.33},
			{144.15, -84.18, 6.22},
			{155.39, -107.98, 6.20},
			{187.06, -111.73, 6.14},
			{209.85, -111.46, 6.17},
			{230.45, -102.37, 6.19},
			{249.57, -74.35, 6.14},
			{302.47, -72.30, 5.79},
			{341.39, -63.73, 4.44},
			{370.46, -51.58, 5.65},
			{394.92, -62.74, 5.88, sound = "WitchHit", bank = "FunHouse.bnk"},
			{432.79, -82.74, 5.29},
			{454.87, -93.17, 5.42},
			{506.64, -89.56, 4.19},
			{568.31, -89.17, 5.48},
			{577.95, -65.02, 5.49},
			{571.37, 38.21, 12.05},
			{556.89, 92.84, 13.13},
			{541.20, 157.17, 13.57},
			{550.07, 198.61, 16.94},
			{539.50, 243.68, 16.41},
			{514.24, 249.53, 15.78},
			{471.75, 252.51, 11.64},
			{458.38, 273.29, 11.23},
			{453.57, 304.54, 14.95},
			{432.45, 308.40, 17.21, sound = "WitchHit", bank = "FunHouse.bnk"},
			{402.38, 306.67, 12.28},
			{339.14, 306.90, 8.41},
			{314.41, 297.19, 6.05},
		},
		music_replay = 59,
		music = {
			intro = "MS_HalloweenMid",
			gameplay = "MS_HalloweenHigh",
			results = "MS_HalloweenLow",
		},
	},
	{ -- Rich Kid Blues (Bike, by SWEGTA) | OLD BULLWORTH VALE | 2:00 PM - 8:00 PM
		name = "Rich Kid Blues (Bike)",
		id = "vale_prepbikerace",
		description = "Aquaberry customers are hitting the streets, in style! (Vehicle: Aquaberry Cruiser)",
		warp_pos = {342.50, 263.53, 6.23, 75.6}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {14, 0},
		end_time = {20, 0},
		area = 0,
		weather = 4,
		clock = {18, 45},
		blip = {340.69, 268.98, 6.10, 8}, -- last number is radius to play
		spectator_bounds = {442.43, 196.89, 450.15, 214.07}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {446.59, 208.57, 8.36, 1.2}, -- last number is spawn radius not heading
		max_timer = 420, -- max seconds
		vehicle = 283,
		laps = 2,
		cameras = {
			results = {432.35, 184.71, 11.83, 440.06, 179.25, 15.12},
			time_15 = {435.34, 190.25, 8.54, 434.85, 180.90, 12.06},
			time_10 = {437.15, 186.57, 9.63, 437.14, 196.52, 10.62},
		},
		spawns = {
			{440.38, 196.81, 8.92, 2.6},
			{438.62, 196.71, 8.93, 1.4},
			{436.76, 196.59, 8.94, 1.1},
			{434.91, 196.47, 8.95, 0.9},
			{433.03, 196.44, 8.95, -1.2},
		},
		checkpoints = {
			{435.96, 227.06, 9.86},
			{438.14, 245.80, 9.74},
			{453.98, 255.82, 10.33},
			{460.14, 296.39, 13.44},
			{446.54, 340.51, 16.85},
			{450.32, 362.42, 15.59},
			{435.81, 393.87, 17.22},
			{431.26, 414.97, 17.35},
			{444.21, 428.79, 18.16},
			{476.58, 431.95, 18.32},
			{482.37, 465.38, 17.74},
			{496.78, 472.03, 17.90},
			{533.88, 475.98, 17.66},
			{551.00, 466.70, 17.70},
			{556.96, 412.38, 18.93},
			{567.72, 386.82, 14.80},
			{554.00, 365.60, 16.68},
			{537.87, 362.47, 16.79},
			{515.25, 375.86, 17.39},
			{513.40, 401.11, 17.25},
			{531.22, 408.29, 17.28},
			{569.50, 407.89, 15.83},
			{577.60, 397.90, 15.87},
			{568.74, 387.11, 17.26},
			{553.58, 376.25, 17.17},
			{535.88, 372.35, 16.96},
			{517.69, 360.42, 16.66},
			{485.39, 341.88, 17.25},
			{472.79, 332.99, 18.84},
			{478.37, 309.01, 20.09},
			{479.65, 278.17, 19.88},
			{492.58, 270.04, 19.77},
			{502.58, 264.48, 20.09},
			{513.70, 261.85, 16.05},
			{539.62, 239.28, 16.26},
			{539.68, 177.48, 15.76},
			{528.37, 158.66, 14.77},
			{511.35, 158.74, 12.04},
			{484.06, 163.06, 9.42},
			{469.29, 146.15, 9.18},
			{469.32, 119.63, 7.95},
			{479.78, 73.62, 3.35},
			{464.64, 64.33, 2.28},
			{430.91, 62.43, 2.53},
			{406.48, 70.24, 2.72},
			{343.19, 84.22, 0.58},
			{322.39, 88.15, 1.33},
			{301.96, 134.83, 2.06},
			{266.01, 197.77, 1.80},
			{258.71, 240.61, 0.61},
			{281.30, 296.65, 3.33},
			{239.70, 334.82, 5.15},
			{223.36, 339.59, 3.25},
			{252.10, 347.80, 4.64},
			{302.68, 333.69, 11.46},
			{346.28, 328.86, 13.18},
			{358.67, 323.05, 13.08},
			{350.40, 268.74, 6.85},
			{340.45, 249.99, 6.88},
			{343.29, 240.88, 6.95},
			{372.46, 241.41, 7.72},
			{381.28, 221.66, 7.00},
			{380.67, 174.43, 5.50},
			{384.32, 132.28, 6.68},
			{380.69, 111.81, 5.35},
			{366.55, 101.12, 5.16},
			{348.31, 100.73, 4.91},
			{328.89, 110.92, 5.13},
			{324.28, 144.44, 5.16},
			{298.05, 170.24, 4.87},
			{287.07, 188.92, 4.58},
			{294.40, 214.60, 4.52},
			{323.95, 221.04, 4.67},
			{343.27, 203.89, 4.48},
			{362.31, 198.67, 6.29},
			{410.66, 198.34, 6.54},
			{428.36, 199.25, 8.34},
		},
		music_replay = 0,
		music = {
			intro = "MS_ActionMid",
			gameplay = "MS_ActionHigh",
			results = "MS_ActionBeatBreak",
		},
	},
	{ -- Hit the Pavement (Skateboard, by SWEGTA) | OLD BULLWORTH VALE | 8:00 PM - 2:00 AM
		name = "Hit the Pavement (Skateboard)",
		id = "vale_skatehills",
		description = "It's all about skaters living life in the fast lane. (Vehicle: Skateboard)",
		warp_pos = {342.50, 263.53, 6.23, 75.6}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {20, 0},
		end_time = {2, 0},
		area = 0,
		weather = 2,
		clock = {20, 55},
		blip = {338.82, 269.01, 5.99, 8}, -- last number is radius to play
		spectator_bounds = {522.82, 466.55, 543.20, 493.20}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {532.18, 477.01, 17.75, 1.2}, -- last number is spawn radius not heading
		max_timer = 420, -- max seconds
		vehicle = -1,
		weapon = 437,
		laps = 3,
		cameras = {
			results = {485.82, 524.67, 20.77, 494.22, 529.51, 23.21},
			time_15 = {544.09, 538.44, 24.92, 544.92, 528.53, 25.96},
			time_10 = {559.36, 527.44, 31.97, 550.52, 531.15, 29.12},
		},
		spawns = {
			{546.49, 534.47, 24.80, 61.1},
			{545.77, 533.03, 24.76, 60.7},
			{544.97, 531.72, 24.74, 58.3},
			{544.09, 530.38, 24.72, 50.1},
			{543.07, 529.25, 24.73, 44.0},
			{542.06, 528.15, 24.74, 45.3},
			{544.58, 535.52, 24.91, 61.1},
			{543.86, 534.09, 24.89, 60.7},
			{543.14, 532.84, 24.87, 58.2},
			{542.35, 531.65, 24.86, 49.3},
			{541.38, 530.65, 24.84, 45.3},
			{540.42, 529.76, 24.82, 45.3},
		},
		checkpoints = {
			{527.00, 539.99, 24.19},
			{481.08, 520.85, 19.74},
			{422.83, 519.16, 22.26},
			{402.88, 499.32, 21.72},
			{393.37, 451.33, 22.72},
			{371.50, 398.12, 19.99},
			{382.11, 353.37, 18.48},
			{437.94, 333.65, 16.10},
			{459.13, 302.81, 14.33},
			{456.92, 265.91, 10.72},
			{436.01, 230.82, 9.79},
			{428.97, 199.73, 8.34},
			{381.50, 194.03, 6.30},
			{371.90, 140.32, 4.62},
			{338.92, 128.68, 5.04},
			{339.84, 60.18, 6.73},
			{340.34, 16.80, 4.94},
			{325.94, -23.91, 4.64},
			{328.88, -60.19, 4.49},
			{325.75, -90.53, 5.31},
			{340.47, -115.53, 6.18},
			{396.51, -106.03, 6.29},
			{440.87, -94.20, 5.32},
			{475.79, -89.60, 5.37},
			{528.81, -89.45, 4.22},
			{569.80, -87.57, 5.56},
			{577.80, -60.48, 5.52},
			{576.46, -6.71, 6.93},
			{570.57, 43.18, 12.42},
			{558.74, 88.02, 13.30},
			{546.37, 134.69, 12.25},
			{539.86, 184.11, 16.10},
			{539.60, 233.49, 16.22},
			{539.38, 281.71, 16.68},
			{540.11, 338.80, 16.67},
			{560.89, 350.06, 16.52},
			{590.62, 362.61, 15.62},
			{587.97, 418.95, 16.95},
			{554.56, 431.88, 16.95},
			{550.08, 480.73, 18.09},
			{553.55, 518.78, 22.80},
		},
		music_replay = 0,
		music = {
			intro = "MS_BikeActionMid",
			gameplay = "MS_BikeActionHigh",
			results = "MS_BikeActionMid",
		},
	},
	{ -- Director's Cut (RC Car, by SWEGTA) | BULLWORTH TOWN | 8:00 AM - 2:00 PM
		name = "Director's Cut (RC Car)",
		id = "town_rcrace2",
		description = "Famous film director Lionel Starkweather is shooting a commercial in Bullworth Town! Professional RC car drivers are needed for stunts. (Vehicle: RC Car)",
		warp_pos = {489.47, -67.46, 5.42, 177.3}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {8, 0},
		end_time = {14, 0},
		area = 0,
		weather = 0,
		clock = {13, 45},
		blip = {491.74, -77.04, 5.03, 8}, -- last number is radius to play
		spectator_bounds = {586.36, -118.60, 615.31, -107.81}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {591.62, -113.93, 5.82, 1.1}, -- last number is spawn radius not heading
		max_timer = 420, -- max seconds
		vehicle = "rc_car",
		laps = 3,
		cameras = {
			results = {636.54, -107.70, 33.97, 629.14, -104.08, 28.31},
			time_15 = {475.89, -89.67, 7.96, 485.86, -90.44, 8.28},
			time_10 = {588.90, -92.95, 6.61, 598.08, -90.09, 9.35},
		},
		spawns = {
			{547.20, -91.88, 5.56, -88.5},
			{547.18, -89.65, 5.59, -88.5},
			{547.16, -87.32, 5.63, -90.4},
			{544.95, -91.93, 5.51, -88.5},
			{544.97, -89.70, 5.55, -88.5},
			{544.96, -87.30, 5.59, -90.4},
			{542.74, -91.98, 5.46, -88.5},
			{542.75, -89.74, 5.50, -88.5},
			{542.72, -87.27, 5.53, -90.4},
			{540.61, -92.03, 5.37, -88.5},
			{540.54, -89.79, 5.39, -88.5},
			{540.54, -87.23, 5.42, -90.5},
			{538.11, -91.78, 5.24, -87.4},
			{538.02, -89.85, 5.25, -88.2},
			{538.03, -87.18, 5.28, -90.9},
		},
		checkpoints = {
			{588.88, -89.39, 5.72, sound = "Shutter", bank = "Camera.bnk"},
			{633.15, -89.07, 8.42, sound = "Shutter", bank = "Camera.bnk"},
			{635.68, -78.04, 9.78, sound = "Shutter", bank = "Camera.bnk"},
			{627.57, -62.70, 8.95, sound = "Shutter", bank = "Camera.bnk"},
			{605.03, -65.75, 5.83, sound = "Shutter", bank = "Camera.bnk"},
			{588.28, -65.84, 5.82, sound = "Shutter", bank = "Camera.bnk"},
			{568.74, -40.04, 5.65, sound = "Shutter", bank = "Camera.bnk"},
			{539.87, -30.73, 5.69, sound = "Shutter", bank = "Camera.bnk"},
			{514.37, -36.49, 5.95, sound = "Shutter", bank = "Camera.bnk"},
			{487.42, -36.57, 5.43, sound = "Shutter", bank = "Camera.bnk"},
			{458.63, -49.73, 5.43, sound = "Shutter", bank = "Camera.bnk"},
			{452.80, -68.96, 5.43, sound = "Shutter", bank = "Camera.bnk"},
			{453.18, -80.29, 5.58, sound = "Shutter", bank = "Camera.bnk"},
			{450.98, -101.37, 5.55, sound = "Shutter", bank = "Camera.bnk"},
			{455.86, -122.81, 5.52, sound = "Shutter", bank = "Camera.bnk"},
			{464.79, -139.32, 5.35, sound = "Shutter", bank = "Camera.bnk"},
			{475.95, -146.60, 5.38, sound = "Shutter", bank = "Camera.bnk"},
			{492.14, -148.11, 4.72, sound = "Shutter", bank = "Camera.bnk"},
			{507.63, -167.41, 4.57, sound = "Shutter", bank = "Camera.bnk"},
			{520.67, -167.26, 7.55, sound = "Shutter", bank = "Camera.bnk"},
			{543.53, -159.87, 10.94, sound = "Shutter", bank = "Camera.bnk"},
			{557.81, -158.18, 11.04, sound = "Shutter", bank = "Camera.bnk"},
			{573.18, -154.24, 8.01, sound = "Shutter", bank = "Camera.bnk"},
			{578.83, -144.57, 8.01, sound = "Shutter", bank = "Camera.bnk"},
			{576.68, -133.91, 5.85, sound = "Shutter", bank = "Camera.bnk"},
			{566.56, -114.24, 5.72, sound = "Shutter", bank = "Camera.bnk"},
			{530.85, -113.06, 5.24, sound = "Shutter", bank = "Camera.bnk"},
			{512.74, -112.68, 5.16, sound = "Shutter", bank = "Camera.bnk"},
			{489.75, -122.53, 6.35, sound = "Shutter", bank = "Camera.bnk"},
			{482.63, -135.94, 4.94, sound = "CowSucess", bank = "CowDance.bnk"}, -- Stunt Jump 1
			{465.83, -118.51, 5.33, sound = "Shutter", bank = "Camera.bnk"},
			{480.69, -89.61, 5.23, sound = "Shutter", bank = "Camera.bnk"},
			{495.11, -87.55, 4.63, sound = "Shutter", bank = "Camera.bnk"},
			{507.04, -82.50, 4.49, sound = "Shutter", bank = "Camera.bnk"},
			{515.46, -82.07, 4.42, sound = "Shutter", bank = "Camera.bnk"},
			{528.79, -68.61, 5.03, sound = "Shutter", bank = "Camera.bnk"},
			{542.71, -64.98, 5.41, sound = "Shutter", bank = "Camera.bnk"},
			{549.49, -54.65, 5.44, sound = "Shutter", bank = "Camera.bnk"},
			{552.05, -24.23, 5.44, sound = "Shutter", bank = "Camera.bnk"},
			{560.64, -17.03, 5.75, sound = "Shutter", bank = "Camera.bnk"},
			{575.76, -18.41, 6.00, sound = "Shutter", bank = "Camera.bnk"},
			{589.13, -32.88, 6.13, sound = "Shutter", bank = "Camera.bnk"},
			{591.39, -53.54, 6.06, sound = "Shutter", bank = "Camera.bnk"},
			{590.75, -54.59, 6.04, sound = "CowSucess", bank = "CowDance.bnk"}, -- Stunt Jump 2
			{588.08, -89.19, 5.72, sound = "Shutter", bank = "Camera.bnk"},
			{583.09, -118.89, 5.85, sound = "Shutter", bank = "Camera.bnk"},
			{583.97, -149.83, 5.88, sound = "Shutter", bank = "Camera.bnk"},
			{573.24, -161.51, 5.87, sound = "Shutter", bank = "Camera.bnk"},
			{548.36, -173.30, 5.56, sound = "Shutter", bank = "Camera.bnk"},
			{538.35, -164.86, 5.33, sound = "Shutter", bank = "Camera.bnk"},
			{534.43, -148.34, 5.62, sound = "Shutter", bank = "Camera.bnk"},
			{523.03, -130.38, 5.59, sound = "Shutter", bank = "Camera.bnk"},
			{522.33, -101.17, 4.19, sound = "Shutter", bank = "Camera.bnk"},
			{529.29, -89.68, 4.22, sound = "Shutter", bank = "Camera.bnk"},
			{562.54, -89.60, 5.30, sound = "CowSucess", bank = "CowDance.bnk"},
		},
		music_replay = 0,
		music = {
			intro = "ArcRaceMXmidi02SPLASHBED02",
			gameplay = "ArcRaceMXmidi02Drive02",
			results = "ArcRaceMXmidi02SPLASHBED05",
		},
	},
	{ -- Chemical Dip (On Foot, by SWEGTA) | OLD BULLWORTH VALE | 2:00 PM - 8:00 PM
		name = "Chemical Dip (On Foot)",
		id = "vale_swimtochemplant",
		description = "Nice day for a swim, eh? Let's see who can get to the Chemplant the fastest. (On Foot)",
		warp_pos = {342.50, 263.53, 6.23, 75.6}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {14, 0},
		end_time = {20, 0},
		area = 0,
		weather = 0,
		clock = {15, 30},
		blip = {338.82, 269.01, 5.99, 8}, -- last number is radius to play
		spectator_bounds = {126.74, -492.65, 154.75, -489.90}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {141.04, -491.25, 2.42, 1.2}, -- last number is spawn radius not heading
		max_timer = 300, -- max seconds
		vehicle = -1,
		laps = 1,
		cameras = {
			results = {165.62, -483.66, 8.18, 155.78, -483.06, 6.51},
			time_15 = {244.41, 216.46, 9.14, 248.57, 225.52, 8.28},
			time_10 = {219.17, 310.38, 1.80, 226.47, 303.55, 1.79},
		},
		spawns = {
			{262.12, 236.88, 0.72, 6.4},
			{260.55, 236.61, 0.71, 0.7},
			{259.12, 236.51, 0.68, -3.7},
			{257.52, 236.50, 0.58, -5.8},
			{255.95, 236.56, 0.47, -8.3},
			{252.91, 236.97, 0.37, -3.9},
			{251.73, 236.97, 0.36, -4.8},
			{250.53, 236.98, 0.36, -6.6},
			{249.26, 237.04, 0.39, -9.7},
			{247.77, 237.21, 0.22, -12.7},
		},
		checkpoints = {
			{262.76, 261.77, 0.86},
			{275.80, 289.49, 1.61},
			{251.70, 334.76, 2.29},
			{239.98, 331.63, 5.11},
			{236.74, 314.23, 4.91},
			{230.49, 302.27, 1.41},
			{221.54, 283.77, -1.21},
			{221.09, 246.28, -1.21},
			{205.55, 218.13, -1.21},
			{185.61, 193.45, -1.21},
			{208.04, 161.95, 0.58},
			{218.23, 167.35, 1.25},
			{233.01, 168.67, -1.25},
			{246.78, 143.21, -1.25},
			{266.54, 110.35, -1.25},
			{298.44, 77.39, -1.25},
			{332.40, 60.93, -1.25},
			{355.22, 54.31, -1.25},
			{382.74, 31.66, -1.25},
			{408.52, 18.54, -1.25},
			{421.23, 4.96, -1.25},
			{423.83, -12.16, -1.25},
			{410.48, -37.62, -1.25},
			{397.08, -62.94, -1.25},
			{397.07, -92.11, -1.25},
			{397.13, -145.52, -1.25},
			{381.57, -177.45, -1.25},
			{355.95, -203.21, -1.25},
			{333.13, -224.15, -1.25},
			{313.53, -240.85, -1.25},
			{292.90, -256.11, -1.25},
			{276.41, -261.07, -1.25},
			{237.35, -266.77, -1.25},
			{217.84, -274.78, -1.25},
			{202.24, -285.84, -1.25},
			{160.85, -300.11, -1.25},
			{130.93, -310.07, -1.25},
			{99.37, -318.00, -1.25},
			{85.26, -322.82, 0.13},
			{71.48, -343.14, 0.21},
			{72.41, -359.04, 0.31},
			{62.97, -370.52, 0.30},
			{35.34, -379.33, 0.39},
			{42.67, -383.49, 0.81},
			{53.07, -384.23, 2.44},
			{55.87, -398.05, 0.31},
			{66.06, -413.03, 0.63},
			{83.19, -414.04, 1.25},
			{100.26, -410.46, 1.81},
			{106.84, -399.74, 2.04},
			{124.25, -393.75, 2.48},
			{136.46, -404.73, 2.68},
			{149.63, -460.31, 2.57},
			{150.32, -482.70, 2.31},
		},
		music_replay = 0,
		music = {
			intro = "MS_PrepFight",
			gameplay = "MS_BikeRace01",
			results = "MS_RomanceMid",
		},
	},
	{ -- On the Fence (Bike, by SWEGTA) | OLD BULLWORTH VALE | 2:00 PM - 8:00 PM
		name = "On the Fence (Bike)",
		id = "vale_spencerestaterace",
		description = "Tad Spencer's away from home — Perfect time for some bike stunts in his yard! (Shop Class 4 BMX)",
		warp_pos = {342.50, 263.53, 6.23, 75.6}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {14, 0},
		end_time = {20, 0},
		area = 0,
		weather = 4,
		clock = {17, 35},
		blip = {337.09, 269.03, 5.93, 8}, -- last number is radius to play
		spectator_bounds = {428.34, 514.57, 454.59, 523.60}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {443.75, 520.56, 21.94, 1.3}, -- last number is spawn radius not heading
		max_timer = 360, -- max seconds
		vehicle = 278,
		laps = 10,
		cameras = {
			results = {408.57, 444.21, 30.14, 416.57, 450.08, 28.88},
			time_15 = {438.96, 515.47, 22.23, 435.25, 507.12, 26.29},
			time_10 = {408.54, 432.47, 22.42, 398.59, 432.04, 23.30},
		},
		spawns = {
			{406.23, 431.50, 22.38, -32.9},
			{404.77, 432.44, 22.51, -34.5},
			{403.42, 433.37, 22.56, -34.3},
			{402.04, 434.20, 22.67, -34.9},
			{400.60, 435.13, 22.73, -38.0},
			{399.24, 436.07, 22.71, -35.1},
			{397.85, 436.92, 22.79, -35.2},
			{396.56, 437.84, 22.82, -36.6},
		},
		checkpoints = {
			{419.01, 446.82, 23.35},
			{430.57, 447.22, 23.30},
			{439.54, 448.25, 23.27},
			{450.32, 440.85, 23.38},
			{461.85, 449.81, 23.29},
			{464.40, 477.61, 23.15},
			{461.27, 481.71, 23.24},
			{449.38, 486.25, 23.37},
			{439.97, 486.28, 23.37},
			{434.98, 492.13, 23.42},
			{436.52, 499.42, 23.41},
			{444.39, 503.11, 23.21},
			{463.90, 494.18, 22.63},
			{476.74, 495.35, 20.19},
			{485.17, 501.18, 19.88},
			{494.17, 497.45, 19.87},
			{493.12, 486.53, 19.91},
			{483.81, 485.39, 19.95},
			{465.34, 493.54, 22.65},
			{452.79, 499.36, 23.30},
			{438.87, 510.57, 22.29},
			{424.87, 508.03, 23.10},
			{410.63, 490.14, 22.89},
			{412.14, 470.32, 23.13},
			{410.16, 455.39, 23.35},
		},
		music_replay = 0,
		music = {
			intro = "MS_Confrontation_NIS",
			gameplay = "MS_BikeRace02",
			results = "MS_Confrontation_NIS",
		},
	},
	{ -- High Frequency (RC Car, by SWEGTA) | BULLWORTH TOWN | 2:00 PM - 8:00 PM
		name = "High Frequency (RC Car)",
		id = "town_rcrace3",
		description = "Dragon's Wing is hosting an RC tournament, from Bullworth Town to Old Bullworth Vale and back. (Vehicle: RC Car)",
		warp_pos = {489.47, -67.46, 5.42, 177.3}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {14, 0},
		end_time = {20, 0},
		area = 0,
		weather = 5,
		clock = {19, 45},
		blip = {491.74, -77.04, 5.03, 8}, -- last number is radius to play
		spectator_bounds = {436.58, -121.48, 448.72, -101.13}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {443.60, -112.96, 4.34, 1.4}, -- last number is spawn radius not heading
		max_timer = 360, -- max seconds
		vehicle = "rc_car",
		laps = 4,
		cameras = {
			results = {404.67, -96.86, 7.88, 414.66, -97.36, 8.02},
			time_15 = {367.07, -81.94, 18.50, 375.75, -86.55, 16.62},
			time_10 = {428.79, -97.29, 7.70, 418.99, -99.25, 8.03},
		},
		spawns = {
			{410.95, -98.17, 6.72, 104.9},
			{411.56, -100.03, 6.71, 105.9},
			{412.10, -101.96, 6.70, 106.6},
			{413.18, -97.57, 6.68, 104.9},
			{413.69, -99.42, 6.67, 105.9},
			{414.23, -101.33, 6.65, 106.6},
			{415.37, -96.99, 6.63, 104.9},
			{415.80, -98.81, 6.62, 105.9},
			{416.40, -100.67, 6.61, 106.6},
			{417.67, -96.37, 6.59, 104.9},
			{418.16, -98.13, 6.58, 105.9},
			{418.78, -99.96, 6.56, 106.6},
			{419.90, -95.77, 6.53, 104.9},
			{420.40, -97.49, 6.52, 105.9},
			{420.90, -99.32, 6.51, 106.6},
		},
		checkpoints = {
			{386.51, -108.61, 6.28},
			{345.84, -116.33, 6.20},
			{329.64, -108.72, 6.24},
			{315.92, -79.08, 5.03},
			{324.62, -28.73, 4.63},
			{337.76, 6.39, 4.70},
			{339.98, 59.44, 6.72},
			{339.63, 87.20, 5.36},
			{349.59, 119.25, 5.33},
			{371.39, 119.04, 6.85},
			{402.55, 115.26, 5.31},
			{425.27, 120.45, 5.49},
			{425.63, 157.28, 6.10},
			{370.97, 166.54, 5.37},
			{358.91, 168.11, 5.78},
			{350.24, 179.01, 5.34},
			{339.67, 228.68, 4.90},
			{342.32, 240.25, 6.95},
			{372.39, 241.78, 7.74},
			{394.73, 241.16, 8.38},
			{442.76, 242.05, 9.86},
			{460.70, 246.92, 10.58},
			{486.15, 241.86, 13.14},
			{502.58, 247.33, 14.75},
			{528.19, 237.95, 16.56},
			{547.49, 223.14, 16.58},
			{532.15, 192.51, 16.47},
			{539.78, 171.06, 15.20},
			{549.22, 121.61, 12.03},
			{563.36, 67.86, 13.47},
			{568.53, 18.37, 9.50},
			{543.55, 6.84, 5.92},
			{507.36, -8.70, 5.83},
			{468.06, -25.63, 5.98},
			{465.88, -59.00, 5.50},
			{459.52, -84.52, 5.44},
			{431.38, -97.08, 5.59},
		},
		music_replay = 0,
		music = {
			intro = "ArcRaceMXmidi02SPLASHBED03",
			gameplay = "ArcRaceMXmidi02Drive03",
			results = "ArcRaceMXmidi02SPLASHBED06",
		},
	},
	{ -- Dam It (Bike, by SWEGTA) | OLD BULLWORTH VALE | 2:00 AM - 8:00 AM
		name = "Dam It (Bike)",
		id = "vale_damrace",
		description = "Round and round the dam we go! (Vehicle: Mountain Bike)",
		warp_pos = {342.50, 263.53, 6.23, 75.6}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {2, 0},
		end_time = {8, 0},
		area = 0,
		weather = 1,
		clock = {5, 0},
		blip = {335.32, 269.05, 5.89, 8}, -- last number is radius to play
		spectator_bounds = {289.89, 226.70, 322.68, 244.07}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {305.50, 236.88, 4.22, 1.4}, -- last number is spawn radius not heading
		max_timer = 300, -- max seconds
		vehicle = 280,
		laps = 3,
		cameras = {
			results = {327.84, 221.95, 30.32, 328.11, 221.20, 20.35},
			time_15 = {325.73, 226.33, 8.83, 331.82, 220.28, 3.70},
			time_10 = {293.37, 219.98, 5.41, 303.28, 219.77, 6.73},
		},
		spawns = {
			{331.20, 224.87, 5.25, 92.4},
			{331.32, 222.83, 5.26, 90.6},
			{331.38, 220.62, 5.26, 89.8},
			{331.42, 218.49, 5.26, 89.1},
			{331.46, 216.08, 5.26, 87.7},
			{329.16, 224.78, 5.26, 92.4},
			{329.25, 222.81, 5.26, 90.6},
			{329.34, 220.62, 5.26, 89.8},
			{329.29, 218.53, 5.26, 89.1},
			{329.32, 216.17, 5.26, 87.7},
		},
		checkpoints = {
			{312.73, 220.04, 4.71},
			{278.68, 207.35, 4.35},
			{278.69, 190.24, 2.41},
			{288.28, 163.19, 2.76},
			{306.95, 129.69, 2.52},
			{315.15, 101.92, 2.66},
			{332.01, 84.27, 0.68},
			{380.42, 80.28, 2.75},
			{420.43, 77.40, 4.12},
			{435.81, 77.82, 5.18},
			{466.41, 75.39, 2.99},
			{477.68, 79.59, 3.58},
			{471.41, 112.91, 7.38},
			{468.32, 140.42, 9.10},
			{481.23, 160.43, 9.42},
			{509.88, 154.91, 12.07},
			{525.19, 120.93, 9.22},
			{542.88, 103.00, 7.18},
			{576.26, 113.37, 9.44},
			{609.88, 126.96, 12.58},
			{638.84, 125.06, 13.09},
			{649.61, 96.16, 8.57},
			{635.47, 66.70, 8.57},
			{607.01, 45.79, 13.89},
			{585.58, 28.53, 11.17},
			{570.18, 43.73, 12.46},
			{557.21, 92.07, 13.15},
			{546.00, 136.12, 12.31},
			{539.77, 185.50, 16.14},
			{539.51, 238.18, 16.26},
			{493.81, 249.59, 13.86},
			{437.38, 249.57, 9.83},
			{390.15, 249.58, 8.32},
			{381.06, 235.30, 7.57},
			{380.57, 203.42, 6.26},
			{361.50, 198.63, 6.29},
			{342.55, 205.66, 4.51},
		},
		music_replay = 0,
		music = {
			intro = "MS_Ambient01",
			gameplay = "MS_PhotographyClass",
			results = "MS_Misbehaving_NISPrankInfo",
		},
	},
	{ -- Off Road Robotics (RC Car, by SWEGTA) | BULLWORTH TOWN | 8:00 PM - 2:00 AM
		name = "Off Road Robotics (RC Car)",
		id = "town_rcrace4",
		description = "The RC cars are going rogue! Make your way around the forest and back. (Vehicle: RC Car)",
		warp_pos = {489.47, -67.46, 5.42, 177.3}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {20, 0},
		end_time = {2, 0},
		area = 0,
		weather = 4,
		clock = {22, 39},
		blip = {491.74, -77.04, 5.03, 8}, -- last number is radius to play
		spectator_bounds = {449.75, -99.68, 468.22, -78.52}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {456.80, -88.25, 5.40, 1.5}, -- last number is spawn radius not heading
		max_timer = 420, -- max seconds
		vehicle = "rc_car",
		laps = 3,
		cameras = {
			results = {432.68, -146.02, 15.22, 438.14, -138.48, 11.57},
			time_15 = {436.88, -121.86, 5.09, 440.00, -112.45, 6.38},
			time_10 = {446.96, -132.50, 3.89, 444.90, -122.74, 4.54},
		},
		spawns = {
			{436.60, -111.82, 4.73, -169.6},
			{438.14, -111.53, 4.77, -167.2},
			{439.86, -111.16, 4.87, -162.7},
			{441.24, -110.80, 5.00, -166.4},
			{442.97, -110.41, 5.14, -164.5},
			{436.23, -109.92, 5.10, -169.6},
			{437.75, -109.55, 5.10, -167.8},
			{439.39, -109.22, 5.12, -163.4},
			{440.79, -108.78, 5.20, -166.5},
			{442.44, -108.33, 5.33, -165.2},
			{435.85, -107.91, 5.49, -169.4},
			{437.38, -107.50, 5.49, -169.4},
			{438.89, -107.07, 5.50, -164.1},
			{440.39, -106.70, 5.50, -167.2},
			{441.88, -106.27, 5.56, -165.4},
		},
		checkpoints = {
			{440.25, -142.35, 3.14},
			{425.03, -189.91, 3.44},
			{428.05, -240.84, 3.63},
			{433.04, -283.84, 5.63},
			{434.54, -335.00, 2.92},
			{436.68, -367.24, 3.29},
			{460.75, -392.78, 4.11},
			{447.42, -438.86, 3.95},
			{443.52, -484.34, 3.26},
			{490.21, -503.35, 5.45},
			{528.96, -510.49, 6.28},
			{541.47, -475.43, 4.45},
			{553.30, -430.57, 4.61},
			{572.97, -399.52, 6.13},
			{584.00, -374.57, 4.43},
			{571.50, -350.12, 3.75},
			{571.69, -307.08, 3.46},
			{575.50, -276.79, 4.41},
			{591.11, -247.50, 5.27},
			{574.44, -227.60, 5.62},
			{542.58, -216.82, 7.05},
			{510.98, -223.59, 7.13},
			{478.35, -221.65, 7.15},
			{437.25, -238.67, 9.07},
			{392.52, -265.00, 9.11},
			{356.74, -285.66, 9.10},
			{320.89, -303.18, 8.43},
			{277.26, -314.85, 8.05},
			{225.05, -327.14, 8.05},
			{170.76, -335.28, 8.05},
			{131.02, -341.72, 8.04},
			{84.09, -346.82, 8.04},
			{54.50, -342.12, 7.87},
			{27.89, -318.98, 7.54},
			{7.49, -291.00, 7.27},
			{-1.64, -277.59, 6.25},
			{-22.26, -247.89, 5.40},
			{-55.36, -239.80, 5.90},
			{-71.49, -220.46, 5.12},
			{-61.98, -177.32, 4.11},
			{-76.87, -143.24, 3.69},
			{-76.24, -114.70, 2.55},
			{-68.11, -64.08, 2.65},
			{-67.20, -18.66, 4.27},
			{-51.61, 18.99, 4.34},
			{-21.51, 36.75, 5.06},
			{21.51, 29.77, 5.43},
			{58.31, 26.47, 6.07},
			{88.68, 31.64, 5.40},
			{126.36, 44.36, 3.74},
			{154.74, 41.56, 3.67},
			{194.35, 28.06, 3.67},
			{241.15, 13.05, 5.89},
			{270.02, 6.50, 5.33},
			{299.35, 5.72, 4.40},
			{322.03, -0.59, 4.41},
			{326.05, -23.30, 4.64},
			{326.65, -51.82, 4.67},
			{340.98, -63.64, 4.44},
			{371.66, -51.88, 5.70},
			{406.75, -68.79, 5.59},
			{430.29, -80.78, 5.03},
			{439.26, -104.93, 5.21},
			{442.28, -129.66, 3.14},
		},
		music_replay = 0,
		music = {
			intro = "ArcRaceMXmidi02SPLASHBED02",
			gameplay = "ArcRaceMXmidi02Drive02",
			results = "ArcRaceMXmidi02SPLASHBED05",
		},
	},
	{ -- Motel Hell (Electric Scooter, by SWEGTA) | BULLWORTH TOWN | 2:00 AM - 8:00 AM
		name = "Motel Hell (Electric Scooter)",
		id = "town_electricscooterrace",
		description = "A foggy race past the motel, to the gas station, and back. (Vehicle: Electric Scooter)",
		warp_pos = {489.47, -67.46, 5.42, 177.3}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {2, 0},
		end_time = {8, 0},
		area = 0,
		weather = 3,
		clock = {5, 0},
		blip = {491.74, -79.02, 5.01, 8}, -- last number is radius to play
		spectator_bounds = {584.43, -67.64, 590.83, -49.38}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {587.97, -58.55, 5.87, 1.1}, -- last number is spawn radius not heading
		max_timer = 360, -- max seconds
		vehicle = "electric_scooter",
		laps = 5,
		cameras = {
			results = {596.28, -25.66, 30.61, 590.77, -32.60, 25.97},
			time_15 = {594.64, -84.35, 17.13, 588.83, -77.02, 13.59},
			time_10 = {582.06, -56.04, 7.81, 578.27, -65.22, 6.68},
		},
		spawns = {
			{573.17, -62.15, 5.43, -179.5},
			{574.27, -62.11, 5.45, -179.2},
			{575.40, -62.05, 5.47, -179.9},
			{576.55, -61.96, 5.49, 178.3},
			{577.74, -61.96, 5.51, 179.2},
			{573.15, -60.47, 5.44, -179.4},
			{574.25, -60.44, 5.46, -179.2},
			{575.40, -60.39, 5.48, -179.9},
			{576.60, -60.37, 5.50, 178.3},
			{577.76, -60.38, 5.52, 179.2},
		},
		checkpoints = {
			{575.01, -117.16, 5.48},
			{560.57, -130.04, 5.47},
			{533.83, -136.93, 5.35},
			{534.20, -146.88, 5.62},
			{538.06, -165.28, 5.31},
			{518.70, -173.45, 5.07},
			{489.90, -180.53, 3.00},
			{455.41, -187.52, 3.37},
			{443.03, -191.83, 3.33},
			{447.56, -207.20, 3.33},
			{464.07, -203.77, 3.32},
			{476.05, -191.77, 2.96}, -- Loop start
			{470.61, -186.63, 3.03},
			{465.33, -193.05, 3.15},
			{472.25, -198.19, 3.05},
			{476.05, -191.77, 2.96},
			{470.61, -186.63, 3.03},
			{465.33, -193.05, 3.15},
			{472.25, -198.19, 3.05},
			{476.05, -191.77, 2.96},
			{470.61, -186.63, 3.03},
			{465.33, -193.05, 3.15},
			{472.25, -198.19, 3.05}, -- Loop end
			{493.27, -192.74, 2.84},
			{500.50, -179.24, 2.89},
			{489.06, -138.77, 4.86},
			{471.66, -128.37, 5.32},
			{465.13, -101.47, 5.36},
			{465.36, -81.06, 5.51},
			{475.20, -68.26, 5.61},
			{502.59, -65.14, 7.09},
			{529.14, -67.52, 5.10},
			{541.21, -65.98, 5.40},
			{549.05, -56.11, 5.43},
			{544.33, -35.00, 5.45},
			{537.48, -10.74, 5.62},
			{550.94, -2.17, 5.40},
			{559.75, -11.87, 5.91},
			{576.62, -40.41, 5.65},
		},
		music_replay = 0,
		music = {
			intro = "MS_StealthMid",
			gameplay = "MS_StealthHigh",
			results = "MS_StealthLow",
		},
	},
	{ -- Hasta La Vista (Motorcycle, by SWEGTA) | OLD BULLWORTH VALE | 2:00 AM - 8:00 AM
		name = "Hasta La Vista (Motorcycle)",
		id = "vale_motorcyclerace",
		description = "Bring your clothes, your boots, and your motorcycle! It's a stunt-driven race through Old Bullworth Vale. (Vehicle: Motorcycle)",
		warp_pos = {342.50, 263.53, 6.23, 75.6}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {2, 0},
		end_time = {8, 0},
		area = 0,
		weather = 3,
		clock = {2, 15},
		blip = {337.09, 269.03, 5.93, 8}, -- last number is radius to play
		spectator_bounds = {526.16, 481.37, 543.16, 492.91}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {532.45, 490.04, 18.98, 0.7}, -- last number is spawn radius not heading
		max_timer = 360, -- max seconds
		vehicle = 275,
		laps = 3,
		cameras = {
			results = {530.30, 479.03, 19.94, 521.29, 474.74, 19.28},
			time_15 = {520.48, 465.54, 19.91, 512.51, 471.19, 17.81},
			time_10 = {552.87, 467.29, 18.06, 542.97, 468.72, 18.38},
		},
		spawns = {
			{514.28, 468.02, 18.39, -88.0},
			{514.22, 469.82, 18.40, -89.2},
			{514.15, 471.74, 18.45, -90.0},
			{514.08, 473.51, 18.51, -90.0},
			{514.11, 475.46, 18.58, -90.1},
			{512.02, 467.94, 18.40, -88.0},
			{511.97, 469.79, 18.41, -89.2},
			{511.90, 471.75, 18.46, -90.0},
			{511.90, 473.52, 18.52, -90.0},
			{511.87, 475.48, 18.58, -90.1},
		},
		checkpoints = {
			{536.64, 473.06, 17.46},
			{550.69, 466.83, 17.67},
			{556.98, 412.73, 18.73},
			{567.29, 387.67, 14.80},
			{562.53, 360.54, 16.57},
			{574.93, 338.33, 15.98},
			{580.87, 298.11, 14.12},
			{601.63, 272.28, 15.56},
			{617.64, 233.74, 15.80},
			{643.37, 209.21, 16.36},
			{660.51, 187.67, 16.04},
			{646.07, 147.99, 17.31},
			{629.80, 130.73, 13.98},
			{590.85, 122.50, 10.97},
			{552.83, 103.70, 7.58},
			{530.85, 109.95, 7.89},
			{515.39, 151.67, 12.87},
			{537.52, 163.79, 14.56},
			{539.92, 201.52, 16.58},
			{539.49, 236.63, 16.25},
			{515.55, 260.87, 16.13},
			{502.30, 264.69, 20.09},
			{501.49, 287.79, 20.55},
			{480.50, 320.27, 19.92},
			{463.24, 338.82, 17.97},
			{444.32, 351.83, 15.66},
			{423.22, 359.81, 15.97},
			{410.84, 387.61, 17.00},
			{372.48, 386.25, 19.77},
			{376.05, 346.00, 17.97},
			{376.03, 311.19, 8.50},
			{380.67, 273.07, 8.33},
			{381.30, 232.55, 7.46},
			{380.77, 199.45, 6.30},
			{380.50, 173.24, 5.45},
			{384.50, 132.17, 6.68},
			{376.30, 118.99, 6.85},
			{347.92, 122.37, 5.42},
			{337.80, 153.50, 5.07},
			{328.39, 174.42, 5.17},
			{314.16, 191.29, 4.72},
			{318.45, 238.51, 5.70},
			{316.00, 245.66, 5.63},
			{329.47, 267.03, 5.89},
			{346.60, 265.47, 6.32},
			{356.27, 287.88, 7.74},
			{380.45, 297.44, 8.49},
			{416.71, 296.80, 9.04},
			{414.24, 263.94, 9.07},
			{430.56, 249.59, 9.71},
			{450.44, 253.10, 10.12},
			{460.50, 292.27, 12.88},
			{455.59, 317.17, 15.82},
			{446.60, 341.10, 16.85},
			{450.53, 359.71, 15.61},
			{454.39, 385.10, 17.81},
			{474.55, 421.59, 17.90},
			{480.64, 455.72, 18.23},
			{490.06, 470.87, 17.40},
			{509.06, 472.21, 17.90},
		},
		music_replay = 0,
		music = {
			intro = "MS_TenementsLow",
			gameplay = "MS_TenementsHigh",
			results = "MS_TenementsMid",
		},
	},
	{ -- One Flew Over the Ramp (Bike, by SWEGTA) | OLD BULLWORTH VALE | 2:00 AM - 8:00 AM
		name = "One Flew Over the Ramp (Bike)",
		id = "vale_rampasylumrace",
		description = "One big bike ride, from the fancy hills of Old Bullworth Vale, all the way to Happy Volts Asylum. (Vehicle: Shop Class 5 BMX)",
		warp_pos = {342.50, 263.53, 6.23, 75.6}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {2, 0},
		end_time = {8, 0},
		objects = {"race_vale_rampasylumrace"},
		area = 0,
		weather = 0,
		clock = {6, 35},
		blip = {338.82, 269.01, 5.99, 8}, -- last number is radius to play
		spectator_bounds = {-154.05, -383.53, -144.03, -368.56}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {-149.26, -378.14, 4.74, 1.1}, -- last number is spawn radius not heading
		max_timer = 300, -- max seconds
		vehicle = 277,
		laps = 1,
		cameras = {
			results = {-100.90, -338.47, 6.77, -108.01, -345.30, 8.43},
			time_15 = {386.23, 424.25, 39.52, 384.68, 433.37, 35.73},
			time_10 = {350.45, 440.33, 24.30, 358.93, 445.62, 24.40},
		},
		spawns = {
			{376.21, 470.09, 23.61, 143.5},
			{377.74, 468.92, 23.65, 141.2},
			{379.24, 467.82, 23.68, 143.3},
			{380.75, 466.71, 23.72, 142.0},
			{382.28, 465.53, 23.76, 143.1},
			{383.80, 464.45, 23.76, 141.9},
			{385.21, 463.42, 23.74, 142.2},
			{386.62, 462.23, 23.72, 138.4},
		},
		checkpoints = {
			{357.83, 444.75, 23.25},
			{336.97, 440.63, 23.47},
			{333.13, 411.65, 22.74},
			{320.27, 391.24, 24.71},
			{302.36, 358.17, 20.59},
			{297.26, 344.66, 17.30},
			{292.64, 329.14, 9.18},
			{286.02, 294.81, 3.51},
			{280.56, 260.08, 2.68},
			{286.62, 223.66, 4.61},
			{287.01, 195.58, 4.58},
			{292.69, 176.81, 4.74},
			{314.74, 154.14, 5.13},
			{326.87, 139.64, 5.17},
			{346.02, 90.17, 5.16},
			{363.28, 88.36, 2.44},
			{420.04, 77.36, 4.08},
			{436.54, 76.84, 5.18},
			{473.63, 77.13, 3.19},
			{476.96, 97.70, 6.14},
			{467.65, 133.96, 8.87},
			{480.60, 159.60, 9.42},
			{506.59, 159.52, 11.00},
			{520.14, 134.90, 10.70},
			{534.01, 106.48, 7.62},
			{560.62, 105.82, 7.84},
			{596.97, 124.18, 11.48},
			{632.43, 131.70, 14.04},
			{650.28, 154.80, 17.84},
			{661.37, 184.73, 16.09},
			{635.25, 216.69, 16.89},
			{615.87, 242.53, 15.52},
			{597.75, 277.29, 15.52},
			{580.18, 306.44, 14.04},
			{573.98, 338.69, 16.04},
			{546.41, 347.64, 16.69},
			{502.45, 346.50, 16.95},
			{481.34, 338.29, 17.71},
			{471.66, 331.25, 19.16},
			{478.35, 305.91, 20.07},
			{472.74, 272.92, 21.73},
			{445.84, 247.28, 9.88},
			{436.09, 223.09, 9.96},
			{429.76, 200.91, 8.34},
			{386.77, 190.81, 6.35},
			{386.72, 165.56, 5.84},
			{384.50, 131.94, 6.68},
			{382.05, 113.72, 5.35},
			{366.60, 101.44, 5.18},
			{344.84, 99.62, 4.67},
			{339.36, 68.62, 6.40},
			{340.63, 23.49, 5.21},
			{318.31, -9.26, 4.95},
			{314.96, -19.20, 5.02},
			{317.85, -41.14, 4.69},
			{308.74, -56.84, 5.01},
			{312.08, -75.72, 5.31},
			{312.24, -106.29, 6.30},
			{335.12, -116.57, 6.17},
			{363.65, -114.54, 5.92},
			{397.04, -105.66, 6.29},
			{435.82, -101.84, 5.65},
			{442.50, -121.98, 3.65},
			{437.46, -152.93, 3.21},
			{425.82, -184.98, 3.45},
			{426.80, -228.40, 3.48},
			{433.13, -283.51, 5.67},
			{447.98, -335.33, 3.71},
			{456.62, -366.52, 2.96},
			{467.42, -391.74, 5.35},
			{464.33, -410.84, 2.40},
			{452.39, -445.05, 2.64},
			{421.53, -437.28, 2.79},
			{403.51, -426.43, 2.84},
			{389.11, -422.42, 2.68},
			{347.74, -433.98, 2.73},
			{321.71, -437.45, 3.08},
			{288.10, -426.12, 2.51},
			{261.61, -423.50, 2.48},
			{224.69, -430.09, 2.68},
			{207.14, -393.34, 4.42},
			{199.96, -368.30, 2.77},
			{178.43, -361.01, 2.44},
			{143.61, -366.33, 2.67},
			{95.71, -375.39, 2.49},
			{66.37, -375.52, 3.07},
			{43.28, -366.29, 0.37},
			{12.09, -337.90, 1.15},
			{-9.00, -314.75, 3.19},
			{-27.86, -306.82, 3.36},
			{-55.29, -306.54, 4.15},
			{-82.08, -298.51, 6.44},
			{-100.98, -307.23, 4.32},
			{-126.06, -315.89, 4.39},
			{-137.04, -338.36, 4.44},
			{-146.33, -366.34, 4.63},
		},
		music_replay = 0,
		music = {
			intro = "MS_BikeChaseMid",
			gameplay = "MS_BikeChaseHigh",
			results = "MS_BikeChaseLow",
		},
	},
	{ -- Curricular Obstacles (Bike, by SWEGTA) | OLD BULLWORTH VALE | 8:00 PM - 2:00 AM
		name = "Curricular Obstacles (Bike)",
		id = "vale_biketoschool",
		description = "The academy is pretty calm and quiet tonight. Let's change that! (Vehicle: Shop Class 4 BMX)",
		warp_pos = {342.50, 263.53, 6.23, 75.6}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {20, 0},
		end_time = {2, 0},
		area = 0,
		weather = 4,
		clock = {20, 10},
		blip = {340.69, 268.98, 6.10, 8}, -- last number is radius to play
		spectator_bounds = {324.57, 128.18, 344.85, 150.03}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {338.17, 141.68, 4.98, 1.2}, -- last number is spawn radius not heading
		max_timer = 300, -- max seconds
		vehicle = 278,
		laps = 1,
		cameras = {
			results = {333.20, 84.81, 6.43, 335.55, 94.53, 6.46},
			time_15 = {335.51, 136.34, 7.84, 337.72, 126.77, 5.97},
			time_10 = {339.15, 118.56, 5.45, 338.94, 128.45, 6.91},
		},
		spawns = {
			{334.67, 126.26, 5.53, -177.2},
			{336.26, 126.40, 5.59, -177.0},
			{337.92, 126.50, 5.65, -178.3},
			{339.69, 126.60, 5.70, -178.5},
			{341.39, 126.75, 5.74, -178.0},
			{343.17, 126.88, 5.78, -178.6},
			{334.57, 128.53, 5.53, -177.2},
			{336.20, 128.62, 5.56, -177.1},
			{337.90, 128.77, 5.60, -178.4},
			{339.64, 128.86, 5.64, -178.4},
			{341.31, 128.98, 5.68, -178.0},
			{343.09, 129.10, 5.72, -178.3},
		},
		checkpoints = {
			{339.40, 95.60, 4.39},
			{340.40, 58.69, 6.69},
			{340.93, 23.69, 5.20},
			{335.63, 1.60, 4.69},
			{324.80, -28.18, 4.63},
			{315.46, -60.63, 4.98},
			{303.73, -72.38, 5.77},
			{263.54, -73.01, 6.00},
			{229.09, -79.76, 6.22},
			{219.63, -77.75, 8.55},
			{217.19, -59.76, 8.61},
			{214.31, -34.24, 6.19},
			{198.17, -32.27, 6.04},
			{182.50, -11.91, 5.69},
			{158.22, 6.38, 6.35},
			{143.69, 11.06, 6.24},
			{134.59, 27.20, 6.11},
			{125.44, 12.87, 6.10},
			{116.23, 0.34, 6.12},
			{108.72, -7.64, 6.16},
			{112.41, -18.50, 6.13},
			{149.57, -29.45, 7.92},
			{154.50, -42.62, 6.28},
			{141.58, -68.75, 6.24},
			{111.84, -66.98, 7.28},
			{99.73, -67.03, 7.28},
			{93.12, -72.78, 7.30},
			{74.96, -73.15, 5.30},
			{49.90, -81.50, 5.04},
			{49.92, -96.96, 5.07},
			{68.48, -98.06, 5.06},
			{67.86, -81.42, 5.07},
			{68.27, -65.55, 5.06},
			{68.90, -48.90, 5.07},
			{48.90, -49.33, 5.09},
			{47.46, -66.22, 5.05},
			{37.33, -72.04, 5.03},
			{8.94, -73.00, 4.91},
			{-26.73, -73.70, 1.00},
			{-42.31, -59.67, 1.00},
			{-52.67, -55.94, 1.38},
			{-53.14, -44.01, 1.36},
			{-47.34, -30.95, 1.55},
			{-27.56, -32.43, 1.30},
			{5.22, -42.17, 0.88},
			{6.12, -65.94, 0.87},
			{-4.99, -67.80, 0.99},
			{-42.05, -91.63, 1.00},
			{-53.74, -96.75, 1.55},
			{-52.82, -114.23, 1.53},
			{-36.21, -117.32, 1.26},
			{-0.28, -113.00, 1.65},
			{20.16, -116.29, 2.97},
			{24.33, -129.80, 2.82},
			{21.89, -141.80, 2.77},
			{5.58, -140.85, 2.91},
			{-6.53, -139.86, 2.09},
			{-12.57, -163.18, 1.01},
			{-14.90, -164.60, 1.00},
			{-24.37, -174.20, 1.00},
			{-30.52, -186.13, 1.82},
			{-29.67, -200.25, 1.80},
			{-16.41, -216.76, 5.88},
			{6.14, -218.33, 1.51},
			{26.21, -210.70, 4.32},
			{45.58, -213.78, 2.52},
			{47.75, -232.73, 2.79},
			{32.14, -238.56, 3.46},
			{20.47, -221.54, 3.24},
			{5.44, -218.45, 1.46},
			{-7.95, -211.77, 1.00},
			{-21.58, -195.16, 1.00},
			{-25.35, -176.51, 1.00},
			{-14.86, -164.70, 1.00},
			{-8.68, -155.41, 1.39},
			{-12.89, -136.15, 2.92},
			{5.18, -119.36, 3.01},
			{-0.84, -111.93, 1.46},
			{-16.67, -106.18, 1.01},
			{-30.43, -95.45, 1.00},
			{-38.08, -83.62, 1.00},
			{-32.69, -70.74, 1.00},
			{-19.18, -68.27, 1.00},
			{-0.25, -72.96, 0.86},
			{17.72, -72.95, 4.98},
			{54.74, -73.31, 5.06},
			{82.43, -73.00, 5.75},
			{100.50, -78.83, 7.28},
			{130.53, -79.11, 6.16},
			{145.59, -89.31, 6.25},
			{162.61, -109.70, 6.16},
			{177.84, -118.19, 6.26},
			{197.54, -117.94, 6.27},
			{217.20, -109.63, 6.19},
			{233.47, -97.68, 6.19},
			{256.38, -72.92, 6.08},
			{303.41, -72.32, 5.79},
			{320.51, -51.54, 4.72},
			{329.63, -12.69, 4.68},
			{340.84, 21.57, 5.13},
			{340.06, 59.73, 6.72},
			{339.40, 98.47, 4.38},
			{339.02, 124.52, 5.10},
		},
		music_replay = 0,
		music = {
			intro = "MS_Misbehaving_NISPrankInfo",
			gameplay = "MS_BikeNight",
			results = "MS_Misbehaving_NISPrankInfo",
		},
	},
	{ -- Stairway to Heaven (On Foot, by SWEGTA) | BULLWORTH TOWN | 2:00 AM - 8:00 AM
		name = "Stairway to Heaven (On Foot)",
		id = "town_platformingrace1",
		description = "Your friends are waiting for you in a secret room, far up in the sky. (On Foot)",
		warp_pos = {489.47, -67.46, 5.42, 177.3}, -- x, y, z, heading
		warp_range = 1, -- how big of a radius the warp is
		start_time = {2, 0},
		end_time = {8, 0},
		objects = {"race_platforming_1"},
		area = 0,
		weather = 1,
		clock = {2, 00},
		blip = {486.79, -76.26, 5.40, 8}, -- last number is radius to play
		spectator_bounds = {419.06, -414.63, 435.55, -409.82}, -- minimum x, minimum y, maximum x, maximum y
		spectator_spawn = {428.38, -411.99, 2.49, 0.7}, -- last number is spawn radius not heading
		max_timer = 480, -- max seconds
		vehicle = -1,
		health = 150,
		parkour_height = 3,
		force_ladders = true,
		exact_respawns = true, -- respawn exactly at checkpoint coord
		laps = 1,
		cameras = {
			results = {415.42, -417.85, 2.97, 415.43, -417.84, -7.03},
			time_15 = {495.29, -90.66, 45.71, 500.17, -91.30, 54.42},
			time_10 = {494.93, -88.53, 34.19, 504.92, -88.83, 34.66},
		},
		spawns = {
			{506.63, -87.27, 33.01, 85.7},
			{506.60, -89.66, 33.01, 85.2},
			{504.91, -89.65, 33.01, 87.2},
			{504.85, -87.53, 33.01, 87.5},
			{503.37, -87.54, 33.01, 87.5},
			{503.39, -89.46, 33.01, 86.8},
			{501.38, -89.50, 33.01, 88.9},
			{501.25, -87.27, 33.01, 88.9},
			{499.45, -87.23, 33.01, 85.7},
			{499.36, -89.70, 33.01, 83.8},
		},
		checkpoints = {
			{481.90, -88.70, 32.98},
			{512.91, -88.49, 36.43},
			{476.36, -88.83, 39.21},
			{479.33, -134.68, 32.33},
			{520.49, -188.50, 32.25},
			{520.23, -233.68, 35.63},
			{520.29, -258.17, 34.93},
			{520.37, -317.90, 34.68},
			{520.29, -369.90, 34.70},
			{520.41, -396.27, 33.41},
			{489.12, -418.73, 36.78},
			{399.39, -436.38, 34.41},
			{399.95, -450.90, 34.41},
			{409.02, -476.11, 34.41},
			{408.88, -509.45, 34.41},
			{449.61, -539.23, 15.15},
			{467.98, -554.81, 39.01},
			{468.08, -576.29, 39.01},
			{464.51, -591.89, 39.03},
			{455.08, -574.21, 39.24},
			{453.26, -549.20, 37.35},
			{443.55, -576.81, 34.97},
		},
		music_replay = 0,
		music = {
			intro = "MS_BikeFunMid",
			gameplay = "MS_BikeFunHigh",
			results = "MS_BikeFunLow",
		},
	},
}
